//=============================================================================
// SlimeSlith.
//=============================================================================
class SlimeSlith expands Pack6Weps;

var() sound IdleSounds[5];
var float Decesion;
var pawn Enemy;

function TweenSelect()
{
	TweenAnim('Surface',0.001);
}
function TweenDown()
{
	PlayAnim('DIVE', 1.0, 0.05);
	Pawn(Owner).ClientMessage("Slith took the pay off eh?");
}
function PlaySelect()
{
	PlayAnim('Surface',1.0,0.0);
	Owner.PlaySound(SelectSound, SLOT_Misc, Pawn(Owner).SoundDampening);	
}
state Idle
{
Begin:
	bPointing=False;
	if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0) ) 
		Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
	if ( Pawn(Owner).bFire!=0 ) Fire(0.0);
	if ( Pawn(Owner).bAltFire!=0 ) AltFire(0.0);	
	Disable('AnimEnd');
	Decesion = FRand();
	if( Decesion<0.2 )
	{
		Owner.PlaySound(IdleSounds[0], SLOT_None,2.0*Pawn(Owner).SoundDampening);
		PlayAnim('SCRATCH');
	}
	else if( Decesion<0.4 )
	{
		Owner.PlaySound(IdleSounds[0], SLOT_None,2.0*Pawn(Owner).SoundDampening);
		PlayAnim('SLICK');
	}
	else if( Decesion<0.6 )
	{
		Owner.PlaySound(IdleSounds[1], SLOT_None,2.0*Pawn(Owner).SoundDampening);
		PlayAnim('Dead2');
		FinishAnim();
		TweenAnim('Breath',1);
		Sleep(1);
	}
	else
	{
		Owner.PlaySound(IdleSounds[2], SLOT_None,2.0*Pawn(Owner).SoundDampening);
		PlayAnim('DIVE');
		FinishAnim();
		PlayAnim('Swim');
		FinishAnim();
		Owner.PlaySound(IdleSounds[3], SLOT_None,2.0*Pawn(Owner).SoundDampening);
		PlayAnim('CLAW1');
		FinishAnim();
		PlayAnim('CLAW2');
		FinishAnim();
		Owner.PlaySound(IdleSounds[2], SLOT_None,2.0*Pawn(Owner).SoundDampening);
		PlayAnim('Surface');
	}
	FinishAnim();
	GoTo('Begin');
}
function Fire( float Value )
{
	if (AmmoType.UseAmmo(6))
	{
		GotoState('NormalFire');
		if ( PlayerPawn(Owner) != None )
			PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
		bPointing=True;
		if ( Owner.bHidden )
			CheckVisibility();
	}
	else
	{
		Pawn(Owner).ClientMessage("Slith wants at least 6 sludge to throw some more");
		DropFrom(Owner.Location);
	}
}

function AltFire( float Value )
{
	if (AmmoType.UseAmmo(15))
	{
		GotoState('AltFiring');
		if ( PlayerPawn(Owner) != None )
			PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
		bPointing=True;
		if ( Owner.bHidden )
			CheckVisibility();
	}
	else
	{
		Pawn(Owner).ClientMessage("Slith wants at least 15 sludge to throw some more");
		DropFrom(Owner.Location);
	}
}
function ShootTarget();
///////////////////////////////////////////////////////
state NormalFire
{
	function ShootTarget()
	{
		DoProjectileFire(ProjectileClass,900,true,3000);
		DoProjectileFire(ProjectileClass,900,true,3000);
		DoProjectileFire(ProjectileClass,900,true,3000);
		DoProjectileFire(ProjectileClass,900,true,3000);
		DoProjectileFire(ProjectileClass,900,true,3000);
		DoProjectileFire(ProjectileClass,900,true,3000);
		DoProjectileFire(ProjectileClass,900,true,3000);
	}
Begin:
	FinishAnim();
	PlayAnim('Shoot1');
	FinishAnim();
	Finish();
}

////////////////////////////////////////////////////////
state AltFiring
{
	function ShootTarget()
	{
		DoProjectileFire(AltProjectileClass,1300,true,0);
	}
Begin:
	FinishAnim();
	PlayAnim('CHARGEUP');
	Sleep(2);
	PlayAnim('Shoot1');
	FinishAnim();
	Finish();
}
function DoProjectileFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn, float missing)
{
	local Vector Start, X,Y,Z;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);
	Owner.MakeNoise(PawnOwner.SoundDampening);
	GetAxes(PawnOwner.ViewRotation,X,Y,Z);
	Start = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = PawnOwner.AdjustAim(ProjSpeed, Start, missing, True, bWarn);
	AdjustedAim.Roll+=Rand(missing)-missing/2;
	AdjustedAim.Yaw+=Rand(missing)-missing/2;
	AdjustedAim.Pitch+=Rand(missing)-missing/2;
	Spawn(ProjClass,,, Start,AdjustedAim);	
}
auto state Pickup
{
	function Tick(float DeltaTime)
	{
		Velocity=vector(Rotation)*100;
	}
	Event EndState()
	{
		bRotateToDesired=false;
		SetPhysics(PHYS_None);
		Velocity=vect(0,0,0);
		Super.EndState();
	}
	function ShootTarget()
	{
		Spawn(ProjectileClass,,,Location,rotator(Enemy.Location - Location));
	}
	function ClawDamageTarget()
	{
		if( VSize(Enemy.Location-Location)>100 )
			Return;
		
		Enemy.TakeDamage(50,None,(Location-Enemy.Location)/2+Enemy.Location,Location-Enemy.Location,'hacked');
	}
Begin:
	Disable('Tick');
	BecomePickup();
	if( FRand()<0.5 || MyMarker!=None )
		GoTo('Attacking');
	PlaySound(IdleSounds[2], SLOT_None);
	PlayAnim('DIVE');
	FinishAnim();
	SetPhysics(PHYS_Projectile);
	LoopAnim('Swim');
	Enable('Tick');
	bRotateToDesired=true;
	RemoteRole=ROLE_DumbProxy;
Move:
	DesiredRotation=RotRand(True);
	Sleep(3);
	GoTo('Move');
Dropped:
	Disable('Tick');
	if( bAmbientGlow )
		AmbientGlow=255;
	if( bSleepTouch )
		CheckTouching();
	GoTo('Begin');
Attacking:
	RemoteRole=ROLE_DumbProxy;
	if( FindEnemys() )
	{
Retry:
		SetRotation(rotator(Enemy.Location - Location));
		if( VSize(Enemy.Location-Location)<100 )
			PlayAnim('SLASH');
		else
			PlayAnim('Shoot1');
		Instigator=none;
		FinishAnim();
		if( bCanSee(Enemy) )
			GoTo('Retry');
		else
		{
			PlaySound(IdleSounds[0], SLOT_None);
			PlayAnim('SLICK');
			FinishAnim();
			GoTo('Attacking');
		}
	}
	PlayAnim('Breath');
	FinishAnim();
	Sleep(0.5);
	GoTo('Attacking');
}
function bool FindEnemys()
{
	local pawn p;
	local vector v1,v2;
	
	for( P=Level.PawnList; P!=None; P=P.nextPawn )
	{
		if( Trace(v1,v2,p.Location,Location,true)==p && p.Health>0 && !p.bHidden )
		{
			Enemy=P;
			Return true;
		}
	}
	Return false;
}
function bool bCanSee( Pawn Other )
{
	local vector v1,v2;
	
	if( Trace(v1,v2,Other.Location,Location,true)==Other && Other.Health>0 )
		Return true;
	Return false;
}

defaultproperties
{
     IdleSounds(0)=Sound'UnrealShare.Slith.yell2sl'
     IdleSounds(1)=Sound'UnrealShare.Slith.yell1sl'
     IdleSounds(2)=Sound'UnrealShare.Slith.dive2sl'
     IdleSounds(3)=Sound'UnrealShare.Slith.scratch1sl'
     IdleSounds(4)=Sound'UnrealShare.Slith.scratch1sl'
     AmmoName=Class'UnrealI.Sludge'
     PickupAmmoCount=50
     FireOffset=(X=12.000000,Y=-10.000000,Z=-15.000000)
     ProjectileClass=Class'Pack6.TinySlimeBall'
     AltProjectileClass=Class'Pack6.HugeSlimeBall'
     AutoSwitchPriority=5
     InventoryGroup=5
     PickupMessage="You got a Slith"
     ItemName="Slith"
     PlayerViewOffset=(X=4.200000,Y=-3.000000,Z=-3.000000)
     PlayerViewMesh=LodMesh'UnrealShare.Slith1'
     PlayerViewScale=0.020000
     PickupViewMesh=LodMesh'UnrealShare.Slith1'
     PickupViewScale=0.500000
     ThirdPersonMesh=LodMesh'UnrealShare.Slith1'
     ThirdPersonScale=0.400000
     PickupSound=Sound'UnrealShare.Slith.yell3sl'
     Mesh=LodMesh'UnrealShare.Slith1'
     DrawScale=0.500000
     CollisionRadius=20.000000
     CollisionHeight=20.000000
     RotationRate=(Pitch=66000,Yaw=66000,Roll=66000)
}
