//=============================================================================
// SmokeExp.
//=============================================================================
class SmokeExp expands RingExplosion4;

simulated function Tick( float DeltaTime )
{
	ScaleGlow = (Lifespan/Default.Lifespan)*1.2;
	AmbientGlow = ScaleGlow * 210;
}


simulated function PostBeginPlay()
{
	PlayAnim  ( 'Explosion', 0.1 );
	SetTimer(0.06, false);
}

simulated function Timer()
{
	local SmokeExp r;
	local EnergyBurst EB;

	//log(self$" timer "$Level.TimeSeconds$" role "$Role$" Location "$Location$" rot "$Rotation$" numpuffs "$numpuffs);

	//log("self lifespan "$lifespan);
	
	if (NumPuffs>0)
	{
		r = Spawn(class'SmokeExp',,,Location+MoveAmount);
		r.RemoteRole = ROLE_None;
		r.NumPuffs = NumPuffs -1;
		r.MoveAmount = MoveAmount;
		eb = Spawn(class'EnergyBurst',,,Location+MoveAmount);
		eb.RemoteRole = ROLE_None;
	}
}

defaultproperties
{
     Texture=FireTexture'XFX.chinese'
     bMeshEnviroMap=True
}
