//=============================================================================
// SquidProj.
//=============================================================================
class SquidProj expands PeaceRocket;

var bool bFound;
function Timer()
{
	local pawn Victims;
	local float thisDist;

	ClosestDistance = 100000;
	ClosestPawn = None;	
	Count++;
	if (Count==20)
	{
		Explode(Location, vect(0,0,0));
		return;
	}

	//FIXME - use the pawnlist for this
	foreach VisibleCollidingActors( class'Pawn', Victims )
	{
		if( Victims.Class!=Instigator.Class )
		{
			thisDist = VSize(Victims.Location - Location); 
			if ( thisDist < ClosestDistance) 
			{
				ClosestPawn = Victims;
				ClosestDistance = thisDist;
			}
		}
	}			
}
function ProcessTouch (Actor Other, Vector HitLocation)
{
	local int hitdamage;
	if (Other == ClosestPawn)
	{
		SetBase(ClosestPawn);
		bFound=True;
		SetPhysics(PHYS_None);
		GoToState('GotIt');
	}
}
function Tick( float DeltaTime )
{
	if( !bFound ) Super.Tick(DeltaTime);
	else Velocity *= 0;
}
State GotIt
{
Begin:
	FinishAnim();
	PlayAnim('Hold');
	ClosestPawn.TakeDamage(10,instigator,Location,vect(0,0,0),'hacked');
	if( ClosestPawn.Health<=0 )
		Explode(Location,vect(0,0,0));
	GoTo('Begin');
}
function Explode(vector HitLocation, vector HitNormal)
{
	HurtRadius(damage, 50.0, 'exploded', MomentumTransfer, HitLocation);
	Spawn(class'EnergyBurst');
	Destroy();
}

defaultproperties
{
     Damage=10.000000
     Mesh=LodMesh'UnrealI.Squid1'
     DrawScale=0.100000
}
