//=============================================================================
// SupaProj.
//=============================================================================
class SupaProj expands Projectile;

var bool bTemp;


auto state Flying
{
	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
		local vector momentum;
	
		if ( Other!=instigator )
		{
			if ( Role == ROLE_Authority )
			{
				momentum = 10000.0 * Normal(Velocity);
				Other.TakeDamage(Damage, instigator, HitLocation, momentum, 'zapped');
			}
			Explode(Location, vect(0,0,0));
		}
	}

	function MakeSound()
	{
		PlaySound(ImpactSound);
		MakeNoise(1.0);
	}
			
	simulated function Explode(vector HitLocation, vector HitNormal)
	{
		local EnergyBurst e;
		local SupaProj s;

		MakeSound();
		e = spawn(class 'EnergyBurst',,,HitLocation+HitNormal*9);
		e.RemoteRole = ROLE_None;
		if( !bTemp )
		{
			s = spawn(class 'SupaProj',instigator,,,Rotation+Rot(36000,1000,0));
			s.DrawScale = 1;
			s.bTemp = True;
			s.Texture = FireTexture'UnrealShare.Effect1.FireEffect1p';
			s = spawn(class 'SupaProj',instigator,,,Rotation+Rot(1000,36000,0));
			s.DrawScale = 1;
			s.bTemp = True;
			s.Texture = FireTexture'UnrealShare.Effect1.FireEffect1p';
			s = spawn(class 'SupaProj',instigator,,,Rotation+Rot(0,5000,36000));
			s.DrawScale = 1;
			s.bTemp = True;
			s.Texture = FireTexture'UnrealShare.Effect1.FireEffect1p';
			s = spawn(class 'SupaProj',instigator,,,Rotation+Rot(90000,0,10000));
			s.DrawScale = 1;
			s.bTemp = True;
			s.Texture = FireTexture'UnrealShare.Effect1.FireEffect1p';
			s = spawn(class 'SupaProj',instigator,,,Rotation+Rot(1000,90000,0));
			s.DrawScale = 1;
			s.bTemp = True;
			s.Texture = FireTexture'UnrealShare.Effect1.FireEffect1p';
			s = spawn(class 'SupaProj',instigator,,,Rotation+Rot(0,0,90000));
			s.DrawScale = 1;
			s.bTemp = True;
			s.Texture = FireTexture'UnrealShare.Effect1.FireEffect1p';
		}
		destroy();
	}

	function BeginState()
	{
		if ( ScriptedPawn(Instigator) != None )
			Speed = ScriptedPawn(Instigator).ProjectileSpeed;
		Velocity = Vector(Rotation) * speed;
		PlaySound(SpawnSound);
	}

Begin:
	if( !bTemp )
		Sleep(2.0); //self destruct after 2.0 seconds
	else Sleep(7.0); //self destruct after 7.0 seconds
	Explode(Location, vect(0,0,0));
}

defaultproperties
{
     speed=800.000000
     MaxSpeed=1200.000000
     Damage=50.000000
     SpawnSound=Sound'UnrealShare.Skaarj.Skrjshot'
     ImpactSound=Sound'UnrealShare.Skaarj.SkrjImp'
     RemoteRole=ROLE_SimulatedProxy
     DrawType=DT_Sprite
     Style=STY_Translucent
     Texture=FireTexture'UnrealShare.Effect1.FireEffect1pb'
     DrawScale=2.000000
}
