//=============================================================================
// SupriceDec.
//=============================================================================
class SupriceDec expands Decoration;

var() string ToDrop;
var Pawn Enemy;

function bool GetVisiblePawn()
{
	local Pawn P;
	local vector HitL,HitN;
	local Actor TraceActor;
	
	For( P=Level.PawnList; P!=None; P=P.NextPawn )
	{
		if( P.bIsPlayer && P.Health>0 && VSize(P.Location-Location)<1500 && !P.bHidden )
		{
			TraceActor = Trace(HitL,HitN,P.Location,Location);
			if( TraceActor==P || TraceActor==None )
			{
				Enemy = P;
				Return True;
			}
		}
	}
	Return false;
}
Auto state Supricy
{
	Event Bump( Actor Other )
	{
		if( Pawn(Other)!=None )
			TakeDamage(1000,Enemy,Location,Velocity,'HurtMe');
	}
	function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
	{
		local int NumChunks;
		local SpriteBallExplosion s;
		local RingExplosion3 r;
		local Actor A;
		local class<Actor> Ac;
		
		Instigator = InstigatedBy;
		if ( Instigator != None )
			MakeNoise(10.0);
		NumChunks = 12;
		s = spawn(class'SpriteBallExplosion');
		r = spawn(class'RingExplosion3',,,Location - Vect(0,0,16),rot(16384,0,0));
		r.PlaySound(r.ExploSound,,6);
		HurtRadius(700, 300, 'destroyed', 0, Location);
		skinnedFrag(class'Fragment1', texture'JSteelBarrel2', Vect(20000,0,0),1.0, 7);
		if( ToDrop!="" )
		{
			Ac = class<Actor>(DynamicLoadObject(ToDrop, class'Class'));
			if( Ac!=None )
			{
				A = Spawn(Ac);
				if( A!=None && Inventory(A)!=None )
					Inventory(A).RespawnTime = 0;
			}
		}
	}
Begin:
	Disable('Bump');
	if( FRand()<0.4 ) GoTo 'Attacker';
	else if( FRand()<0.4 ) GoTo 'SupriceBomb';
	Stop;

Attacker:
	if( GetVisiblePawn() )
	{
		PlaySound(Sound'UnrealI.Throw1t',SLOT_Interact);
		Velocity = vect(0,0,400);
		bBounce = True;
		SetPhysics(PHYS_Falling);
		Sleep(0.7);
		SetRotation(rotator(Enemy.Location-Location));
		Velocity = vector(Rotation)*1000;
		Velocity.Z = VSize(Enemy.Location-Location)/2;
		SetPhysics(PHYS_Falling);
		Enable('Bump');
		Sleep(3);
		bBounce = False;
		Disable('Bump');
		SetPhysics(PHYS_None);
	}
	Sleep(2+4*FRand());
	GoTo 'Attacker';

SupriceBomb:
	if( GetVisiblePawn() )
	{
		PlaySound(Sound'Pack6.Klaxon',SLOT_Interact);
		Sleep(2);
		TakeDamage(1000,Enemy,Location,Velocity,'HurtMe');
	}
	Sleep(2+4*FRand());
	GoTo 'SupriceBomb';
}	

defaultproperties
{
     bPushable=True
     bStatic=False
     bStasis=False
     DrawType=DT_Mesh
     Mesh=LodMesh'UnrealShare.WoodenBoxM'
     CollisionRadius=5.000000
     CollisionHeight=5.000000
     bCollideActors=True
     bCollideWorld=True
     bBlockActors=True
     bBlockPlayers=True
     bProjTarget=True
}
