//=============================================================================
// TitaniumTank.
//=============================================================================
class TitaniumTank expands Decoration;

// Used from my 'Vehicles' mod, the
// scripts...
const FullLap=65536; // Full rotated actor
const ForthLap=8192; // 1/4 rotated actor
var PlayerPawn Driver,Passengers[10],MyNetOwnerActor;
var vector ActualLocation,ActualVelocity,OldChecks[2];
var rotator ActualRot,OldRotCheck,DriverRot;
var() const bool FlipUpDown; // Do flip up and down when moving up n down?
var() const int MaxPassengers; // WARNING, MAX IS 10!
var() float MaxSpeed,AccelRate,GroundHeight,Steering,ReFireRate;
var() string VehicleName;
var() int Health;
var() sound Step;
var EPhysics OldPhysic;
var float Count;
var() Sound HitSound;
var bool bAccelRateing;
var float RespawnT,LiveT;

replication
{
	// Stuff server should send for clients!
	unreliable if( Role==ROLE_Authority )
		ActualLocation,FlipUpDown,Driver,Passengers,MaxSpeed,AccelRate,GroundHeight,Steering,
		ActualVelocity,ActualRot,bAccelRateing,DriverRot,Step;
}
simulated function PlayerPawn GetMyActor()
{
	local PlayerPawn P;
	
	Foreach AllActors(class'PlayerPawn',P)
		if( P.Player!=None && P.Player.Console!=None )
			Return P;
}
simulated function CheckReplicationProxy()
{
	if( MyNetOwnerActor==None && Level.NetMode==NM_Client )
		MyNetOwnerActor = GetMyActor();
	if( Level.NetMode!=NM_Client )
	{
		ActualLocation = Location;
		ActualVelocity = Velocity;
		ActualRot = Rotation;
	}
	else // Send stuff for clients
	{
		if( OldChecks[0]!=ActualLocation )
		{
			SetLocation(ActualLocation+(ActualVelocity*0.001*MyNetOwnerActor.PlayerReplicationInfo.Ping));
			OldChecks[0]=ActualLocation; // Calculate the dealey with ping on net!
		}
		if( OldChecks[1]!=ActualVelocity )
		{
			Velocity = ActualVelocity;
			OldChecks[1]=ActualVelocity;
		}
		if( OldRotCheck!=ActualRot )
		{
			SetRotation(ActualRot);
			OldRotCheck=ActualRot;
		}
	}
	if( Level.NetMode!=NM_Client || Driver==MyNetOwnerActor )
		DriverRot = Driver.ViewRotation;
}
simulated function CheckPromixy()
{
	local int i;
	
	CheckReplicationProxy();
	if( Driver!=None )
	{
		Driver.Weapon = None;
		Driver.SetLocation(Location);
	}
	for( i=0; i<10; i++ )
		if( Passengers[i]!=None )
		{
			Passengers[i].Weapon = None;
			Passengers[i].SetLocation(Location);
		}
}
function FireProjectile()
{
	PlayAnim('TThro001');
}
simulated function AnimEnd()
{
	LoopAnim('TBrea001');
}
function SpawnRock()
{
	local rotator DaRot,Temp;
	local vector Start;
	
	Start = Location+(vector(Rotation)*(CollisionRadius+50));
	DaRot = Driver.AdjustAim(1200, Start,100, True, True);
	Spawn(Class'BigRock',Self,, Start,DaRot).Instigator = Driver;
}
simulated function CheckDriverStats( float DeltaTime )
{
	local Pawn P;
	local rotator ActualRot;
	local float DriverYaw;
	local vector mySpeed;
	
	if( Level.NetMode!=NM_Client ) // Clients should'nt handel this!!!
	{
		for( P=Level.PawnList; P!=None; P=P.nextPawn )
		{
			if( PlayerPawn(P)!=None && VSize(P.Location-Location)<CollisionRadius+P.CollisionRadius+100
			 && PlayerPawn(P).bDuck>0 && !bIsAllredyIn(PlayerPawn(P)) && P.Health>0 )
			{
				if( Driver==None )
					SetDriver(PlayerPawn(P));
				else
					AddPass(PlayerPawn(P));
			}
		}
	}
	if( Driver!=None )
	{
		if( Level.NetMode!=NM_Client || (Driver.Player!=None && Driver.Player.Console!=None ))
			bAccelRateing = (Driver.bDuck>0);
		if( Physics!=PHYS_Falling && bAccelRateing )
		{
			ActualRot = Rotation;
			if( Level.NetMode==NM_Client && Driver==MyNetOwnerActor )
				DriverYaw = DriverRot.Yaw;
			else
				DriverYaw = Driver.ViewRotation.Yaw;
			ActualRot.Pitch = 0;
			ActualRot.Roll = 0;
			ActualRot.Yaw = Driver.ViewRotation.Yaw;
			SetRotation(ActualRot);
		}
		if( bAccelRateing && Physics!=PHYS_Falling && AnimSequence!='TThro001' ) // No steering while falling
		{
			if( VehicleSpeed(Velocity)<MaxSpeed )
			{
				mySpeed = vector(ActualRot)*AccelRate;
				Velocity.X = mySpeed.X;
				Velocity.Y = mySpeed.Y;
			}
		}
		else if( (!bAccelRateing || AnimSequence=='TThro001') && Physics!=PHYS_Falling &&
		 VehicleSpeed(Velocity)>0 )
		{
			Velocity.X /= 3;
			Velocity.Y /= 3;
		}
		if( AnimSequence!='TThro001' )
		{
			if( bAccelRateing && AnimSequence!='TWalk001' )
				LoopAnim('TWalk001');
			else if( !bAccelRateing && AnimSequence!='TBrea001' )
				LoopAnim('TBrea001');
		}
	}
}
simulated function float VehicleSpeed( vector Speed )
{
	Speed.Z = 0;
	Return VSize(Speed);
}
simulated function float GMax( float Max, float Value, float Add )
{
	local int i;
	i = Add+Value-Max;
	if( i>0 )
		Return Add-I;
	Return Add;
}
simulated function float GMin( float Min, float Value, float Sub )
{
	local int i;
	i = Sub+Value-Min;
	if( i>0 )
		Return (Sub-I)*-1;
	Return Sub*-1;
}
simulated function CheckAll( float DTime )
{
	local int i;
	
	if( Level.NetMode==NM_Client ) Return;
	for( i=0; i<10; i++ )
		if( Passengers[i]!=None && (Passengers[i].bAltFire!=0 || Passengers[i].Health<=0
		|| Passengers[i].Class==None) )
		{
			Passengers[i].SetLocation(Location+vect(0,0,200));
			ReSetPhysics(Passengers[i]);
			Passengers[i] = None;
			bHidden = False;
		}
	if( Driver!=None )
	{
		if( Driver.bAltFire!=0 || Driver.Health<=0 || Driver.Class==None )
		{
			Driver.SetLocation(Location+vect(0,0,200));
			ReSetPhysics(Driver);
			Driver = None;
			SetOwner(None);
			bHidden = False;
		}
		if( Driver.bFire!=0 && Count>ReFireRate )
		{
			Count = 0;
			FireProjectile();
		}
		if( Count<=ReFireRate )
			Count+=DTime;
	}
}	
function SetDriver( PlayerPawn Other )
{
	Driver = Other;
	Other.ClientSetRotation(Rotation);
	SetOwner(Other);
	Other.ClientMessage("Entered the driver seat on"@VehicleName);
	SePhysicsFor(Other);
	SetTimer(0,false);
}
function AddPass( PlayerPawn Other )
{
	local int i;
	
	for( i=0; i<10; i++ )
	{
		if( Passengers[i]==None || Passengers[i]==Other )
		{
			Other.ClientMessage("Entered the passager seat on"@VehicleName);
			SePhysicsFor(Other);
			Passengers[i]=Other;
			Return;
		}
	}
}
function bool bIsAllredyIn( PlayerPawn Other )
{
	local int i;
	
	if( Driver==Other ) Return True;
	for( i=0; i<MaxPassengers; i++ )
		if( Passengers[i]==Other && i<MaxPassengers )
			Return True;
	if( Driver==None ) Return false;
	for( i=0; i<MaxPassengers; i++ )
		if( Passengers[i]==None )
			Return false;
	Return true;
}
function SePhysicsFor( PlayerPawn Other )
{
	Other.SetPhysics(PHYS_Flying);
	Other.DrawType = DT_None;
	Other.SetCollision(false,false,false);
}
function ReSetPhysics( PlayerPawn Other )
{
	Other.SetPhysics(PHYS_Swimming);
	Other.DrawType = DT_Mesh;
	Other.SetCollision(True,True,True);
	if( Other==Driver )
		SetTimer(LiveT,false);
}
simulated function Tick( float DeltaTime )
{
	local vector HitL,HitN,EndT;
	local Actor HitA;
	local Float DisT;
	local rotator testRot;
	
	CheckPromixy();
	CheckAll(DeltaTime);
	CheckDriverStats(DeltaTime);
	if( Velocity.X>0 )
		Velocity.X -= 20*DeltaTime;
	else if( Velocity.X<0 )
		Velocity.X += 20*DeltaTime;
	if( Velocity.Y>0 )
		Velocity.Y -= 20*DeltaTime;
	else if( Velocity.Y<0 )
		Velocity.Y += 20*DeltaTime;
	if( Velocity!=vect(0,0,0) )
		testRot = Rotator(Velocity);
	else if( Physics==PHYS_Falling )
	{
		testRot = Rotation;
		testRot.Pitch = 0;
	}
	else testRot = Rotation;
	testRot.Yaw = Rotation.Yaw;
	testRot.Roll = Rotation.Roll;
	if( FlipUpDown )
	{
		if( testRot.Pitch>ForthLap )
			testRot.Pitch=ForthLap;
		else if( testRot.Pitch<ForthLap*-1 )
			testRot.Pitch=ForthLap*-1;
	}
	else testRot.Pitch=0;
	if( Rotation!=testRot )
		SetRotation(testRot);
	// Lots of hard traceing to count how its situatation is!
	EndT = Location;
	EndT.Z -= CollisionHeight+GroundHeight;
	HitA = Trace(HitL,HitN,EndT,Location,True);
	if( HitA!=None && Pawn(HitA)!=None ) // Landed on a pawn, kill it!
	{
		HitA.TakeDamage(1000,Driver,HitL,Velocity*1000,'Crushed');
		DisT = Location.Z - (HitL.Z+CollisionHeight+GroundHeight/2); // Count da distance!
		DisT *= -1;
		FoundLanded(DisT,HitA,HitL,HitN);
		Return;
	}
	if( HitA!=None && (HitA==Level || Mover(HitA)!=None || HitA.bStatic) && Velocity.Z<=800 )
	{
		DisT = Location.Z - (HitL.Z+CollisionHeight+GroundHeight/2); // Count da distance!
		DisT *= -1;
		FoundLanded(DisT,HitA,HitL,HitN);
	}
	else
		IsFalling();
	if( (Physics!=PHYS_Falling || Physics!=PHYS_Projectile) && OldPhysic!=PHYS_None )
		SetPhysics(OldPhysic);
	else OldPhysic = Physics;
}
simulated function FoundLanded( float Height, Actor Ground, vector HitL, vector HitN )
{
	local rotator TheRot;
	
	if( Height<-10 )
		Return;
	if( Velocity.Z<-900 && Physics==PHYS_Falling )
	{
		Velocity = MirrorVectorByNormal(Velocity,HitN)*0.7; // Bounch on ground
		Return;
	}
	if( Base!=Ground )
		SetBase(Ground);
	Velocity.Z = Height; // Find how much should move!
	if( Physics==PHYS_Falling )
	{
		SetPhysics(PHYS_Projectile); // Landed!
		OldPhysic = PHYS_Projectile;
		TheRot = Rotation;
		TheRot.Pitch = 0;
		SetRotation(TheRot);
	}
}
simulated function IsFalling()
{
	if( Physics==PHYS_Falling )
		Return;
	OldPhysic = PHYS_Falling;
	SetPhysics(PHYS_Falling); // No ground under, make it fall!
	SetBase(None);
}
simulated function Landed( vector HitNormal )
{
	local vector HitL;
	HitL = Location;
	HitL.Z -= CollisionHeight;
	Velocity.Z = 200;
	SetPhysics(PHYS_Falling);
	FoundLanded(GroundHeight/3,Level,HitL,HitNormal);
}
simulated function HitWall( vector HitNormal, actor HitWall )
{
	local bool bThings1,bThings2;
	local vector TempV;
	if( HitNormal.Z>0.8 )
	{
		TempV = vect(0,0,0);
		TempV.Z += HitNormal.Z*20-20;
		Velocity.Z = HitNormal.Z*100;
		SetLocation(Location+TempV);
		Return;
	}
	else if( (HitNormal.X<0.7 || HitNormal.X>-0.7) && (HitNormal.Y<0.7 || HitNormal.Y>-0.7)
	 && Physics==PHYS_Falling && VSize(Velocity)<400 )
		Velocity = HitNormal*200;
	else Velocity = MirrorVectorByNormal(Velocity,HitNormal)*0.6;
	if( Level.NetMode!=NM_Client )
	{
		bThings1 = (Velocity.X>0);
		bThings2 = (Velocity.Y>0);
	}
	if( Level.NetMode!=NM_Client && VSize(Velocity)>800 )
	{
		if( (bThings1 && Velocity.X<0) || (!bThings2 && Velocity.X>0) )
			TakeDamage(VSize(Velocity)/10,None,Location,vect(0,0,0),'blown');
		else if( (bThings1 && Velocity.Y<0) || (!bThings2 && Velocity.Y>0) )
			TakeDamage(VSize(Velocity)/10,None,Location,vect(0,0,0),'blown');
	}
}
function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
{
	local int i;
	
	PlaySound(HitSound);
	Health-=Damage;
	if( Health<=0 )
	{
		for( i=0; i<10; i++ )
			if( Passengers[i]!=None )
			{
				Passengers[i].SetLocation(Location+VRand()*CollisionRadius);
				ReSetPhysics(Passengers[i]);
				Passengers[i].Health = -999999999;
				Passengers[i].Died(instigatedBy,'exploded',HitLocation);
				Passengers[i] = None;
			}
		if( Driver!=None )
		{
			Driver.SetLocation(Location+VRand()*CollisionRadius);
			ReSetPhysics(Driver);
			Driver.Health = -999999999;
			Driver.Died(instigatedBy,'exploded',HitLocation);
			Driver = None;
		}
		Spawn(class'SpriteBallExplosion',,,Location+VRand()*CollisionRadius);
		Spawn(class'SpriteBallExplosion',,,Location+VRand()*CollisionRadius);
		Spawn(class'SpriteBallExplosion',,,Location+VRand()*CollisionRadius);
		Spawn(class'SpriteBallExplosion',,,Location+VRand()*CollisionRadius);
		Destroy();
	}
	else if( Health<=400 )
	{
		for( i=0; i<10; i++ )
			if( Passengers[i]!=None )
				Passengers[i].ClientMessage("Warning:"@VehicleName@"got only"@Health@"health left");
		if( Driver!=None )
			Driver.ClientMessage("Warning:"@VehicleName@"got only"@Health@"health left");
	}
}
simulated function Bump( Actor Other )
{
	local vector HitN,HitL;
	
	if( (Other.Location.Z-Other.CollisionHeight-Location.Z-CollisionHeight)>-5 && !Other.bStatic )
	{
		if( Velocity.Z>50 )
		{
			HitWall(Normal(Location - Other.Location),Other);
			Return;
		}
		else Return;
	}
	if( Trace(HitL,HitN,Other.Location,Location,True)!=Other )
		HitN = Normal(Other.Location - Location);
	if( Other.bStatic || Other.bNoDelete || !Other.bMovable )
	{
		HitWall(HitN,Other);
		Return;
	}
	if( Level.NetMode!=NM_Client && VSize(Velocity)>100 )
		Other.TakeDamage(VSize(Velocity)/10,Driver,Location,Velocity*1000,'Crushed');
	HitWall(HitN,Other);
}
function Destroyed()
{
	local int i;
	
	for( i=0; i<10; i++ )
		if( Passengers[i]!=None )
		{
			Passengers[i].SetLocation(Location+VRand()*CollisionRadius);
			ReSetPhysics(Passengers[i]);
		}
	if( Driver!=None )
	{
		Driver.SetLocation(Location+VRand()*CollisionRadius);
		ReSetPhysics(Driver);
	}
}
simulated function FootStep()
{
	PlaySound(Step, SLOT_Interact, 0.5, false, 400.0, 1.0);
}
simulated final function bool CloseTo( vector Vect1, vector vect2, float MaxDiff )
{
	local vector Nor1,Nor2;
	
	Nor1 = Normal(Vect1);
	Nor2 = Normal(vect2);
	if( Nor1.X<Nor2.X+MaxDiff || Nor1.X>Nor2.X-MaxDiff )
		if( Nor1.Y<Nor2.Y+MaxDiff || Nor1.Y>Nor2.Y-MaxDiff )
			if( Nor1.Z<Nor2.Z+MaxDiff || Nor1.Z>Nor2.Z-MaxDiff )
				Return true;
	Return false;
}

defaultproperties
{
     FlipUpDown=True
     MaxPassengers=1
     MaxSpeed=1200.000000
     AccelRate=400.000000
     GroundHeight=40.000000
     Steering=100000.000000
     RefireRate=4.000000
     VehicleName="TitaniumTank"
     Health=2500
     Step=Sound'UnrealI.Titan.step1t'
     HitSound=Sound'UnrealI.Titan.injur1t'
     bStatic=False
     bStasis=False
     Physics=PHYS_Falling
     RemoteRole=ROLE_SimulatedProxy
     DrawType=DT_Mesh
     Mesh=LodMesh'UnrealI.Titan1'
     DrawScale=0.500000
     bOwnerNoSee=True
     CollisionRadius=57.500000
     CollisionHeight=40.000000
     bCollideActors=True
     bCollideWorld=True
     bBlockActors=True
     bBlockPlayers=True
     bProjTarget=True
}
