//=============================================================================
// Uzis.
//=============================================================================
class Uzis expands Pack6Weps;

var float AltAccuracy;
var() int hitdamage;

simulated event RenderOverlays( canvas Canvas )
{
	local rotator NewRot;
	local bool bPlayerOwner;
	local int Hand;
	local PlayerPawn PlayerOwner;

	if ( bHideWeapon || (Owner == None) )
		return;

	PlayerOwner = PlayerPawn(Owner);
	if ( PlayerOwner != None )
	{
		bPlayerOwner = true;
		Hand = PlayerOwner.Handedness;
	}

	if (  (Level.NetMode == NM_Client) && bPlayerOwner && (Hand == 2) )
	{
		bHideWeapon = true;
		return;
	}

	if ( !bPlayerOwner || (PlayerOwner.Player == None) )
		Pawn(Owner).WalkBob = vect(0,0,0);

	if ( (bMuzzleFlash > 0) && bDrawMuzzleFlash && Level.bHighDetailMode && (MFTexture != None) )
	{
		MuzzleScale = Default.MuzzleScale * Canvas.ClipX/640.0;
		if ( !bSetFlashTime )
		{
			bSetFlashTime = true;
			FlashTime = Level.TimeSeconds + FlashLength;
		}
		else if ( FlashTime < Level.TimeSeconds )
			bMuzzleFlash = 0;
		if ( bMuzzleFlash > 0 )
		{
			if ( Hand == 0 )
				Canvas.SetPos(Canvas.ClipX/2 - MuzzleScale * FlashS + Canvas.ClipX * (-0.2 * Default.FireOffset.Y * FlashO), Canvas.ClipY/2 - MuzzleScale * FlashS + Canvas.ClipY * (FlashY + FlashC));
			else
				Canvas.SetPos(Canvas.ClipX/2 - MuzzleScale * FlashS + Canvas.ClipX * (Hand * Default.FireOffset.Y * FlashO), Canvas.ClipY/2 - MuzzleScale * FlashS + Canvas.ClipY * FlashY);

			Canvas.Style = 3;
			Canvas.DrawIcon(MFTexture, MuzzleScale);
			Canvas.Style = 1;
		}
	}
	else
		bSetFlashTime = false;

	SetLocation( Owner.Location + CalcDrawOffset() );
	NewRot = Pawn(Owner).ViewRotation;

	if ( Hand == 0 )
		newRot.Roll = -2 * Default.Rotation.Roll;
	else
		newRot.Roll = Default.Rotation.Roll * Hand;

	newRot.Roll += 32732;
	setRotation(newRot);
	Canvas.DrawActor(self, false);
	if(MySecondWeapon != None ) RenderSecondW(Canvas);
}
simulated event RenderSecondW( canvas Canvas )
{
	local rotator NewRot;
	local bool bPlayerOwner;
	local int Hand;
	local PlayerPawn PlayerOwner;

	if ( bHideWeapon || (Owner == None) || mySecondWeapon==None )
		return;

	PlayerOwner = PlayerPawn(Owner);
	if ( PlayerOwner != None )
	{
		bPlayerOwner = true;
		Hand = PlayerOwner.Handedness;
	}

	if (  (Level.NetMode == NM_Client) && bPlayerOwner && (Hand == 2) )
	{
		mySecondWeapon.bHideWeapon = true;
		return;
	}
	mySecondWeapon.SetLocation( Owner.Location + mySecondWeapon.CalcDrawOffset() );
	NewRot = Pawn(Owner).ViewRotation;
	if ( Hand == 0 )
		newRot.Roll = Default.Rotation.Roll * Hand;
	else
		newRot.Roll = -2 * Default.Rotation.Roll;
	newRot.Roll += 32732;
	mySecondWeapon.setRotation(newRot);
	Canvas.DrawActor(mySecondWeapon, false);
}
function PlaySelect()
{
	PlayAnim('Activate',0.5,0.0);
	Owner.PlaySound(SelectSound, SLOT_Misc, Pawn(Owner).SoundDampening);
	if(MySecondWeapon != None )
	{
		MySecondWeapon.PlayAnim('Activate',0.5,0.0);
		Owner.PlaySound(SelectSound, SLOT_Misc, Pawn(Owner).SoundDampening);
	}
}
function TweenSelect()
{
}
function TweenDown()
{
	TweenAnim('Activate',1);
	Owner.PlaySound(SelectSound, SLOT_Misc, Pawn(Owner).SoundDampening);
	if(MySecondWeapon != None )
	{
		MySecondWeapon.TweenAnim('Activate',1);
		Owner.PlaySound(SelectSound, SLOT_Misc, Pawn(Owner).SoundDampening);
	}
}
function PlayIdleAnim()
{
	TweenAnim('Angle0',0.2);
	if(MySecondWeapon != None ) MySecondWeapon.TweenAnim('Angle0',0.2);
}
function PlayFiring()
{
	Owner.PlaySound(FireSound, SLOT_None,2.0*Pawn(Owner).SoundDampening);
	PlayAnim('FAngle0', 0.2);
	if(MySecondWeapon != None && AmmoType.UseAmmo(1) )
	{
		Owner.PlaySound(FireSound, SLOT_None,2.0*Pawn(Owner).SoundDampening);
		MySecondWeapon.PlayAnim('FAngle0', 0.2);
		if (MySecondWeapon != None ) 
			MySecondWeapon.TraceFire(AltAccuracy);
	}
}
function PlayAltFiring()
{
	Owner.PlaySound(AltFireSound, SLOT_None,2.0*Pawn(Owner).SoundDampening);
	PlayAnim('FAngle0', 0.06);
	if(MySecondWeapon != None )
	{
		Owner.PlaySound(AltFireSound, SLOT_None,2.0*Pawn(Owner).SoundDampening);
		MySecondWeapon.PlayAnim('FAngle0', 0.06);
	}
}
function AltFire( float Value )
{
	GoToState('AltFiring');
}
function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local shellcase s;
	local vector realLoc;

	realLoc = Owner.Location + CalcDrawOffset();
	s = Spawn(class'ShellCase',Pawn(Owner), '', realLoc + 20 * X + FireOffset.Y * Y + Z);
	if ( s != None )
		s.Eject(((FRand()*0.3+0.4)*X + (FRand()*0.2+0.2)*Y + (FRand()*0.3+1.0) * Z)*160);              
	if (Other == Level) 
		Spawn(class'WallHitEffect',,, HitLocation+HitNormal*9, Rotator(HitNormal));
	else if ((Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( FRand() < 0.2 )
			X *= 5;
		Other.TakeDamage(HitDamage, Pawn(Owner), HitLocation, 3000.0*X, 'shot');
		if ( !Other.IsA('Pawn') && !Other.IsA('Carcass') )
			spawn(class'SpriteSmokePuff',,,HitLocation+HitNormal*9);
	}		
}
state Firing
{
ignores Fire, AltFire;

Begin:
	FinishAnim();
	PlayFiring();
	if(MySecondWeapon != None ) MySecondWeapon.PlayFiring();
	FinishAnim();
Repeater:	
	if (AmmoType.UseAmmo(1)) 
	{
		if ( PlayerPawn(Owner) != None )
			PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
		TraceFire(AltAccuracy);
		PlayFiring();
		if(MySecondWeapon != None ) MySecondWeapon.PlayFiring();
	}
	FinishAnim();
	if ( AltAccuracy < 3 ) 
		AltAccuracy += 0.5;	
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	else if ( Pawn(Owner).Weapon != Self )
		GotoState('Idle');		
	else if ( /*bAltFireMem ||*/ (Pawn(Owner).bAltFire!=0) 
		&& AmmoType.AmmoAmount>0)
	{
		if ( PlayerPawn(Owner) == None )
			Pawn(Owner).bAltFire = int( FRand() < AltReFireRate );
		//bFireMem = false;
		//bAltFireMem = false;
		Goto('Repeater');	
	}
	FinishAnim();
	PlayAnim('Angle0');
	Finish();
}
state AltFiring
{

	function Timer()
	{
		if (Pawn(Owner).bAltFire == 0)
		{
			if (PlayerPawn(Owner) != None)
				PlayerPawn(Owner).StopZoom();
			SetTimer(0.0,False);
			GoToState('Idle');
		}
	}

Begin:
	if ( Owner.IsA('PlayerPawn') )
	{
		PlayerPawn(Owner).ToggleZoom();
		SetTimer(0.075,True);
	}
	else
	{
		Pawn(Owner).bFire = 1;
		Pawn(Owner).bAltFire = 0;
		Global.Fire(0);
	}
}
function AltTraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z;
	local actor Other;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(PawnOwner.SoundDampening);
	GetAxes(PawnOwner.ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.X * X + (FireOffset.Y * Y * -1) + FireOffset.Z * Z; 
	AdjustedAim = PawnOwner.AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000
		+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	X = vector(AdjustedAim);
	EndTrace += (10000 * X); 
	Other = PawnOwner.TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
}
function Timer()
{
	local actor targ;
	local float bestAim, bestDist;
	local vector FireDir;

	bestAim = 0.95;
	if ( Pawn(Owner) == None )
	{
		GotoState('');
		return;
	}
	FireDir = vector(Pawn(Owner).ViewRotation);
	targ = Pawn(Owner).PickTarget(bestAim, bestDist, FireDir, Owner.Location);
	if ( Pawn(targ) != None )
	{
		SetTimer(1 + 4 * FRand(), false);
		bPointing = true;
		Pawn(targ).WarnTarget(Pawn(Owner), 200, FireDir);
	}
	else 
	{
		SetTimer(0.4 + 1.6 * FRand(), false);
		bPointing = false;
	}
}
function Finish()
{
	//bMuzzleFlash = 0;
	if ( ((Pawn(Owner).bFire!=0) || (Pawn(Owner).bAltFire!=0)) && (FRand() < 0.6) )
		Timer();
	Super.Finish();
}
function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;

	bUseAltMode = 0;
	return AIRating;
}

defaultproperties
{
     hitdamage=15
     bDualWeaponed=True
     SecondWeaponPickup="You found another Uzi!"
     AmmoName=Class'UnrealShare.ShellBox'
     PickupAmmoCount=9999
     bInstantHit=True
     bAltInstantHit=True
     FireOffset=(Y=-10.000000,Z=-4.000000)
     FireSound=Sound'UnrealI.Cannon.CannonShot'
     AltFireSound=Sound'UnrealI.Cannon.CannonShot'
     SelectSound=Sound'UnrealI.Cannon.CannonActivate'
     AutoSwitchPriority=5
     InventoryGroup=5
     PickupMessage="You found a Uzi"
     ItemName="Uzi"
     PlayerViewOffset=(X=4.200000,Y=-3.000000,Z=-7.000000)
     PlayerViewMesh=LodMesh'UnrealI.CannonM'
     PlayerViewScale=0.080000
     PickupViewMesh=LodMesh'UnrealI.CannonM'
     ThirdPersonMesh=LodMesh'UnrealI.CannonM'
     ThirdPersonScale=0.200000
     PickupSound=Sound'UnrealI.Cannon.CannonExplode'
     Mesh=LodMesh'UnrealI.CannonM'
}
