//=============================================================================
// ZapTouch.
//=============================================================================
class ZapTouch expands Pickup;

var ShieldBeltEffect MyEffect;
var() texture FireTexture;

function Destroyed()
{
	if ( MyEffect != None )
		MyEffect.Destroy();
	Super.Destroyed();
}

function PickupFunction(Pawn Other)
{
	MyEffect = Spawn(class'NonEffect', Owner,,Owner.Location, Owner.Rotation); 
	MyEffect.Mesh = Owner.Mesh;
	MyEffect.DrawScale = Owner.Drawscale;
	MyEffect.Texture = FireTexture;
	SetTimer(1,true);
}

function Timer()
{
	local Pawn P;
	local int Counted,C2;
	
	if( Owner==None || Pawn(Owner)==None ) Return;
	if( Charge<=0 )
		WearOff();
	if( Owner.Region.Zone!=None && Owner.Region.Zone.bWaterZone )
	{
		Foreach AllActors(class'Pawn',P)
			if( P!=Pawn(Owner) && P.Region.Zone==Owner.Region.Zone )
				P.TakeDamage(Charge,Pawn(Owner),Owner.Location,Owner.Location-P.Location,'Zapped');
		Pawn(Owner).ClientMessage("Zapped out some fishes!");
		if( Owner.IsA('PlayerPawn') )
			PlayerPawn(Owner).ClientFlash(10,vect(400,400,400));
		Destroy();
	}
	for( P=Level.PawnList; P!=None; P=P.nextPawn )
	{
		if( P!=Pawn(Owner) && P.bBlockActors && VSize(P.Location-Owner.Location)<200 )
		{
			Counted = P.Health;
			if( Counted>50 )
				Counted = 50;
			else if( Counted>Charge )
				Counted = Charge;
			C2 = Level.Game.ReduceDamage(Counted,'Zapped',P,Pawn(Owner));
			Charge -= C2;
			if( C2>0 )
			{
				P.TakeDamage(Counted,Pawn(Owner),Owner.Location,Owner.Location-P.Location,'Zapped');
				Spawn(class'ZapExp',,,(Owner.Location-P.Location)/2+P.Location,rotator(Owner.Location-P.Location));
			}
			if( Charge<=0 )
			{
				WearOff();
				Return;
			}
		}
	}
}
function WearOff()
{
	Pawn(Owner).ClientMessage("Your shocking is gone");
	Destroy();
}
auto state Pickup
{
	function bool ValidTouch( actor Other )
	{
		local Actor A;

		if( Other.bIsPawn && (Pawn(Other).Health > 0) && Level.Game.PickupQuery(Pawn(Other), self) )
		{
			if( Event != '' )
				foreach AllActors( class 'Actor', A, Event )
					A.Trigger( Other, Other.Instigator );
			return true;
		}
		return false;
	}
}

defaultproperties
{
     FireTexture=FireTexture'UnrealShare.Effect3.fireeffect3a'
     bDisplayableInv=True
     bRotatingPickup=True
     PickupMessage="You got electric fingers."
     RespawnTime=20.000000
     PickupViewMesh=Mesh'Pack6.ElectricMesh'
     PickupViewScale=0.400000
     Charge=1000
     bIsAnArmor=True
     PickupSound=Sound'UnrealI.Krall.Krasht2'
     Icon=Texture'Pack6.ZapIcon'
     Texture=Texture'UnrealShare.GoldSkin'
     Mesh=Mesh'Pack6.ElectricMesh'
     DrawScale=0.800000
     MultiSkins(0)=FireTexture'UnrealShare.Belt_fx.ShieldBelt.BlueShield'
     MultiSkins(1)=Texture'UnrealShare.GoldSkin'
     CollisionRadius=10.000000
}
