//=============================================================================
// ASCII.
//=============================================================================
class ASCII expands Pickup;

var() struct Codes_Type
{
	var() string Code,ASCII;
} Codes[74];
var string RecivedMsg;

replication
{
	reliable if( Role < 4 )
		SetText,Encode,Decode,SendText;
}
function string GetDecoded( string Other ) // Decode
{
	local string S,S2,S3;
	local int i,ii;
	
	S = Other;
	While( Len(S)>6 )
	{
		S2 = Left(S,7);
		For(ii=0; ii<74; ii++)
		{
			if( Codes[ii].Code!="" && Codes[ii].ASCII!="" && Codes[ii].Code==S2 )
			{
				S3 = S3$Codes[ii].ASCII;
				S2 = "";
			}
		}
		if( S2!="" )
			S3 = S3$"~";
		S = Mid(S,7);
	}
	Return S3;
}
function string GetEncoded( string Other ) // Encode
{
	local string S,S2,S3;
	local int i,ii;
	
	S = Other;
	While( Len(S)>0 )
	{
		S2 = Left(S,1);
		For(ii=0; ii<74; ii++)
		{
			if( Codes[ii].Code!="" && Codes[ii].ASCII!="" && Codes[ii].ASCII==S2 )
			{
				S3 = S3$Codes[ii].Code;
				S2 = "";
			}
		}
		if( S2!="" )
			S3 = S3$"~";
		S = Mid(S,1);
	}
	Return S3;
}

exec function SetText( string Text )
{
	Pawn(Owner).ClientMessage("Set codable text to:"@Text);
	RecivedMsg = Text;
}
exec function Encode()
{
	local string S;
	local bool bSecond;
	
	S = GetEncoded(RecivedMsg);
	RecivedMsg = S;
	While( Len(S)>100 )
	{
		if( !bSecond )
		{
			Pawn(Owner).ClientMessage("Set codable text to:"@Left(S,100));
			bSecond = True;
		}
		else Pawn(Owner).ClientMessage(Left(S,100));
		S = Mid(S,100);
	}
	if( !bSecond )
		Pawn(Owner).ClientMessage("Set codable text to:"@S);
	else Pawn(Owner).ClientMessage(S);
}
exec function Decode()
{
	RecivedMsg = GetDecoded(RecivedMsg);

	Pawn(Owner).ClientMessage("Decoded text to:"@RecivedMsg);
}
exec function SendText()
{
	local string S;
	
	S = RecivedMsg;
	While( Len(S)>100 )
	{
		SendIt(Left(S,100));
		S = Mid(S,100);
	}
	SendIt(Left(S,100));
	GiveFor();
}
function SendIt( string Msg )
{
	local Pawn P;

	for( P=Level.PawnList; P!=None; P=P.nextPawn )
		if( P.bIsPlayer )
			P.TeamMessage( Pawn(Owner).PlayerReplicationInfo, Msg, 'Say' );
}
function GiveFor()
{
	local Pawn P;
	local Inventory I;

	for( P=Level.PawnList; P!=None; P=P.nextPawn )
	{
		if( P.bIsPlayer && P.Inventory!=None )
		{
			For(I=P.Inventory; I!=None; I=I.Inventory)
			{
				if( ASCII(I)!=None )
				{
					P.ClientMessage("ASCII En-/Decoder is ready to code it!");
					ASCII(I).RecivedMsg = RecivedMsg;
				}
			}
		}
	}
}
			
function Activate()
{
	Pawn(Owner).ClientMessage("TYPE: SetText<Message>, Encode, Decode, SendText");
}

defaultproperties
{
     Codes(0)=(Code="010000",ASCII=" ")
     Codes(1)=(Code="0100001",ASCII="!")
     Codes(2)=(Code="0110000",ASCII="0")
     Codes(3)=(Code="0110001",ASCII="1")
     Codes(4)=(Code="0110010",ASCII="2")
     Codes(5)=(Code="0110011",ASCII="3")
     Codes(6)=(Code="0110100",ASCII="4")
     Codes(7)=(Code="0110101",ASCII="5")
     Codes(8)=(Code="0110110",ASCII="6")
     Codes(9)=(Code="0110111",ASCII="7")
     Codes(10)=(Code="0111000",ASCII="8")
     Codes(11)=(Code="0111001",ASCII="9")
     Codes(12)=(Code="0111010",ASCII=":")
     Codes(13)=(Code="0111100",ASCII="<")
     Codes(14)=(Code="0111101",ASCII="=")
     Codes(15)=(Code="0111110",ASCII=">")
     Codes(16)=(Code="0111111",ASCII="?")
     Codes(17)=(Code="0100100",ASCII="$")
     Codes(18)=(Code="1000000",ASCII="@")
     Codes(19)=(Code="1000001",ASCII="A")
     Codes(20)=(Code="1000010",ASCII="B")
     Codes(21)=(Code="1000011",ASCII="C")
     Codes(22)=(Code="1000100",ASCII="D")
     Codes(23)=(Code="1000101",ASCII="E")
     Codes(24)=(Code="1000110",ASCII="F")
     Codes(25)=(Code="1000111",ASCII="G")
     Codes(26)=(Code="1001000",ASCII="H")
     Codes(27)=(Code="1001001",ASCII="I")
     Codes(28)=(Code="1001010",ASCII="J")
     Codes(29)=(Code="1001011",ASCII="K")
     Codes(30)=(Code="1001100",ASCII="L")
     Codes(31)=(Code="1001101",ASCII="M")
     Codes(32)=(Code="1001110",ASCII="N")
     Codes(33)=(Code="1001111",ASCII="O")
     Codes(34)=(Code="1010000",ASCII="P")
     Codes(35)=(Code="1010001",ASCII="Q")
     Codes(36)=(Code="1010010",ASCII="R")
     Codes(37)=(Code="1010011",ASCII="S")
     Codes(38)=(Code="1010100",ASCII="T")
     Codes(39)=(Code="1010101",ASCII="U")
     Codes(40)=(Code="1010110",ASCII="V")
     Codes(41)=(Code="1010111",ASCII="W")
     Codes(42)=(Code="1011000",ASCII="X")
     Codes(43)=(Code="1011001",ASCII="Y")
     Codes(44)=(Code="1011010",ASCII="Z")
     Codes(45)=(Code="1011111",ASCII="-")
     Codes(46)=(Code="1011110",ASCII="_")
     Codes(47)=(Code="1100000",ASCII="'")
     Codes(48)=(Code="1100001",ASCII="a")
     Codes(49)=(Code="1100010",ASCII="b")
     Codes(50)=(Code="1100011",ASCII="c")
     Codes(51)=(Code="1100100",ASCII="d")
     Codes(52)=(Code="1100101",ASCII="e")
     Codes(53)=(Code="1100110",ASCII="f")
     Codes(54)=(Code="1100111",ASCII="g")
     Codes(55)=(Code="1101000",ASCII="h")
     Codes(56)=(Code="1101001",ASCII="i")
     Codes(57)=(Code="1101010",ASCII="j")
     Codes(58)=(Code="1101011",ASCII="k")
     Codes(59)=(Code="1101100",ASCII="l")
     Codes(60)=(Code="1101101",ASCII="m")
     Codes(61)=(Code="1101110",ASCII="n")
     Codes(62)=(Code="1101111",ASCII="o")
     Codes(63)=(Code="1110000",ASCII="p")
     Codes(64)=(Code="1110001",ASCII="q")
     Codes(65)=(Code="1110010",ASCII="r")
     Codes(66)=(Code="1110011",ASCII="s")
     Codes(67)=(Code="1110100",ASCII="t")
     Codes(68)=(Code="1110101",ASCII="u")
     Codes(69)=(Code="1110110",ASCII="v")
     Codes(70)=(Code="1110111",ASCII="w")
     Codes(71)=(Code="1111000",ASCII="x")
     Codes(72)=(Code="1111000",ASCII="y")
     Codes(73)=(Code="1111010",ASCII="z")
     bActivatable=True
     bDisplayableInv=True
     PickupMessage="You got ASCII device!"
     ItemName="ASCII En-/Decoder"
     RespawnTime=30.000000
     PickupViewScale=0.250000
     PickupSound=Sound'UnrealShare.Pickups.GenPickSnd'
     Icon=Texture'Engine.S_Inventory'
     M_Activated=" chosen!"
     DrawType=DT_Sprite
     Style=STY_Masked
     DrawScale=0.250000
     CollisionRadius=5.000000
     CollisionHeight=5.000000
}
