//=============================================================================
// ASMDSkaarj.
//=============================================================================
class ASMDSkaarj expands SkaarjWarrior;

var() int HitDamage;
var(Sounds) sound TraceShotSound;
var() class<RingExplosion> RingExplosionClass;

function SpawnTwoShots()
{
	local rotator FireRotation;
	local vector X,Y,Z,projStart,HitNormal,HitLocation,EndTrace,StartTrace,NewHitLocation;
	local Actor A;

	PlaySound(TraceShotSound, SLOT_Interact);
	GetAxes(Rotation,X,Y,Z);
	MakeNoise(1.0);
	projStart = Location + 0.9 * CollisionRadius * X + 0.9 * CollisionRadius * Y + 0.4 * CollisionHeight * Z;
	FireRotation = AdjustAim(ProjectileSpeed, projStart, 400, bLeadTarget, bWarnTarget);
	GetAxes(FireRotation,X,Y,Z);
	EndTrace = Location + 10000* Vector(FireRotation);
	A = Trace(HitLocation,HitNormal,EndTrace,projStart, True);
	ProcessTraceHit(A, HitLocation, HitNormal, vector(FireRotation),Y,Z);
		
	projStart = projStart - 1.8 * CollisionRadius * Y;
	FireRotation.Yaw += 400;
	GetAxes(FireRotation,X,Y,Z);
	EndTrace = Location + 10000* Vector(FireRotation);
	A = Trace(HitLocation,HitNormal,EndTrace,projStart, True);
	ProcessTraceHit(A, HitLocation, HitNormal, vector(FireRotation),Y,Z);
}
function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local vector SmokeLocation,DVector;
	local rotator SmokeRotation;
	local float NumPoints;
	local int i;
	local RingExplosion r;

	if (Other==None)
	{
		HitNormal = -X;
		HitLocation = Location + X*10000.0;
	}
	SmokeLocation = Location + X + Y + Z;
	DVector = HitLocation - SmokeLocation;
	NumPoints = VSize(DVector)/70.0;
	SmokeLocation += DVector/NumPoints;
	SmokeRotation = rotator(HitLocation-Location);
	if (NumPoints>15) NumPoints=15;
	if ( NumPoints>1.0 ) SpawnEffect(DVector, NumPoints, SmokeRotation, SmokeLocation);

	if ( TazerProj(Other)!=None )
		TazerProj(Other).SuperExplosion();
	else
	{
		r = Spawn(RingExplosionClass,,, HitLocation+HitNormal*8,rotator(HitNormal));
		if ( r != None )
			r.PlaySound(r.ExploSound,,6);
	}

	if ( (Other != self) && (Other != Owner) && (Other != None) ) 
		Other.TakeDamage(HitDamage, Self, HitLocation, 50000.0*X, 'jolted');
}
function SpawnEffect(Vector DVector, int NumPoints, rotator SmokeRotation, vector SmokeLocation)
{
	local RingExplosion4 Smoke;
	
	Smoke = Spawn(class'RingExplosion4',,,SmokeLocation,SmokeRotation);
	Smoke.MoveAmount = DVector/NumPoints;
	Smoke.NumPuffs = NumPoints;
}
function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
{
	if ( !bIsPlayer && Inventory!=None )
		Super.TakeDamage(Inventory.ReduceDamage(Damage, DamageType, HitLocation),
		instigatedBy,hitlocation,momentum,damageType);
	else Super.TakeDamage(Damage,instigatedBy,hitlocation,momentum,damageType);
}
function bool SetEnemy( Pawn NewEnemy )
{
	Return SetRealEnemy(NewEnemy,Self,'Waiting','Attacking');
}
function bool SetRealEnemy( Pawn NewEnemy, Pawn Hater, name ReadyStates, name AttackState )
{
	local EAttitude Temp;
	
	if( NewEnemy==None || NewEnemy.bDeleteMe || NewEnemy.Health<=0 || NewEnemy==Self ) Return false;
	if( FlockPawn(NewEnemy)!=None || FlockMasterPawn(NewEnemy)!=None ) Return false;
	
	if( !NewEnemy.bIsPlayer )
	{
		if( ScriptedPawn(Hater)!=None )
			Temp = ScriptedPawn(Hater).AttitudeToCreature(NewEnemy);
		else if( NewEnemy.Class==Hater.Class )
			Temp = ATTITUDE_Friendly;
		else Temp = ATTITUDE_Hate;
	}
	else Temp = Hater.AttitudeToPlayer;
	
	if( Temp~=ATTITUDE_Friendly || Temp~=ATTITUDE_Follow || (Temp~=ATTITUDE_Ignore && FRand()<0.6) )
		Return False;
	if( ScriptedPawn(Hater)!=None && ScriptedPawn(Hater).OldEnemy!=NewEnemy )
		ScriptedPawn(Hater).OldEnemy=NewEnemy;
	Hater.Enemy = NewEnemy;
	if( !IsInState('Attacking') && !IsInState('RangedAttack') && !IsInState('MeleeAttack') 
	 && !IsInState('TakeHit') && !IsInState('FallingState') && !IsInState('Hunting')
	 && !IsInState('TacticalMove') )
		Hater.GoToState(AttackState);
	if( NewEnemy.bIsPlayer && ScriptedPawn(Hater)!=None && !ScriptedPawn(Hater).bFirstHatePlayer
	 && (ScriptedPawn(Hater).FirstHatePlayerEvent != '') )
		ScriptedPawn(Hater).TriggerFirstHate();
	Return True;
}

defaultproperties
{
     hitdamage=25
     TraceShotSound=Sound'UnrealShare.ASMD.TazerFire'
     RingExplosionClass=Class'UnrealShare.RingExplosion'
     RangedProjectile=None
}
