//=============================================================================
// AirRifle.
//=============================================================================
class AirRifle expands Pack6Weps;

#exec MESH IMPORT MESH=RifleM ANIVFILE=MODELS\Rifle_a.3D DATAFILE=MODELS\Rifle_d.3D X=0 Y=0 Z=0 unmirror=1
#exec MESH ORIGIN MESH=RifleM X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=0
#exec MESH SEQUENCE MESH=RifleM SEQ=All         STARTFRAME=0   NUMFRAMES=101
#exec MESH SEQUENCE MESH=RifleM SEQ=Select      STARTFRAME=0   NUMFRAMES=20 RATE=27 GROUP=Select
#exec MESH SEQUENCE MESH=RifleM SEQ=Still       STARTFRAME=20  NUMFRAMES=1
#exec MESH SEQUENCE MESH=RifleM SEQ=Fire        STARTFRAME=21  NUMFRAMES=10 RATE=24
#exec MESH SEQUENCE MESH=RifleM SEQ=ScopeFire   STARTFRAME=31  NUMFRAMES=10
#exec MESH SEQUENCE MESH=RifleM SEQ=ScopeUp     STARTFRAME=41  NUMFRAMES=14
#exec MESH SEQUENCE MESH=RifleM SEQ=StillScope  STARTFRAME=55  NUMFRAMES=1
#exec MESH SEQUENCE MESH=RifleM SEQ=DownWScope  STARTFRAME=56  NUMFRAMES=15
#exec MESH SEQUENCE MESH=RifleM SEQ=Down        STARTFRAME=71  NUMFRAMES=15
#exec MESH SEQUENCE MESH=RifleM SEQ=ScopeDown   STARTFRAME=86  NUMFRAMES=15
#exec TEXTURE IMPORT NAME=JRifle1 FILE=MODELS\Rifle.PCX GROUP=Skins
#exec OBJ LOAD FILE=..\UnrealShare\textures\FireEffect18.utx PACKAGE=UNREALSHARE.Effect18
#exec MESHMAP SCALE MESHMAP=RifleM X=0.005 Y=0.004 Z=0.01
#exec MESHMAP SETTEXTURE MESHMAP=RifleM NUM=1 TEXTURE=JRifle1
#exec MESHMAP SETTEXTURE MESHMAP=RifleM NUM=0 TEXTURE=UnrealShare.Effect18.FireEffect18

#exec MESH IMPORT MESH=RiPick ANIVFILE=MODELS\RiPick_a.3D DATAFILE=MODELS\RiPick_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=RiPick X=0 Y=0 Z=0 YAW=-64 
#exec MESH SEQUENCE MESH=RiPick SEQ=All         STARTFRAME=0   NUMFRAMES=1
#exec MESH SEQUENCE MESH=RiPick SEQ=Still       STARTFRAME=0   NUMFRAMES=1
#exec TEXTURE IMPORT NAME=JRifle1 FILE=MODELS\Rifle.PCX GROUP=Skins
#exec MESHMAP SCALE MESHMAP=RiPick X=0.06 Y=0.06 Z=0.12
#exec MESHMAP SETTEXTURE MESHMAP=RiPick NUM=1 TEXTURE=JRifle1

#exec MESH IMPORT MESH=Rifle3rd ANIVFILE=MODELS\Rifle3_a.3D DATAFILE=MODELS\Rifle3_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Rifle3rd X=0 Y=-550 Z=-45 YAW=-64 ROLL=9
#exec MESH SEQUENCE MESH=Rifle3rd SEQ=All  STARTFRAME=0  NUMFRAMES=10
#exec MESH SEQUENCE MESH=Rifle3rd SEQ=Still  STARTFRAME=0  NUMFRAMES=1
#exec MESH SEQUENCE MESH=Rifle3rd SEQ=Fire  STARTFRAME=1  NUMFRAMES=9
#exec MESHMAP SCALE MESHMAP=Rifle3rd X=0.05 Y=0.05 Z=0.1
#exec MESHMAP SETTEXTURE MESHMAP=Rifle3rd NUM=1 TEXTURE=JRifle1
#exec MESHMAP SETTEXTURE MESHMAP=Rifle3rd NUM=0 TEXTURE=UnrealShare.Effect18.FireEffect18

#exec AUDIO IMPORT FILE="Sounds\rifle\RPICKUP1.WAV" NAME="RiflePickup" GROUP="Rifle"
#exec AUDIO IMPORT FILE="Sounds\rifle\RSHOT9.WAV" NAME="RifleShot" GROUP="Rifle"

var int NumFire;
var vector EnemyLoc[20];
var float ReChecking;
var bool bChecked,bIsDM;

replication
{
	// Things the server should send to the client.
	reliable if( Role==ROLE_Authority && bNetOwner && Pawn(Owner)!=None && Pawn(Owner).Weapon==Self )
		EnemyLoc;
}
function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;

	bUseAltMode = 0;
	return AIRating;

}
simulated function PostRender( canvas Canvas )
{
	local Actor A;
	local vector Start,HitLocation,HitNormal,EndTrace,X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	Start = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;
	EndTrace = Start + 10000* Vector(Pawn(Owner).ViewRotation);
	A = Trace(HitLocation,HitNormal,EndTrace,Start,True);
	if( A!=None && A!=Level )
		Canvas.DrawPortal(0,0,Canvas.ClipX/7,Canvas.ClipY/7,A,A.Location,A.Rotation,90);
	Canvas.SetPos(0.5 * Canvas.ClipX - 64, 16);
	Canvas.Style=3;
	Canvas.DrawIcon(texture'Radar',1);
	Canvas.Style=2;
	DrawRadarDots(Canvas,0.5 * Canvas.ClipX - 64, 16);
}
simulated function DrawRadarDots(Canvas canvas, int RadarX, int RadarY)
{
	local pawn blip;
	local int CenterX, CenterY, i;
	local vector RelLoc;
	local float d, x, y, arc;
	local actor Viewer;
	local color ActualC;
	
	CenterX = RadarX + 64;
	CenterY = RadarY + 64;
	Viewer = Owner;
	if (PlayerPawn(Owner).ViewTarget != none)
		Viewer = PlayerPawn(Owner).ViewTarget;
	ActualC = Canvas.DrawColor;
	// mark pawn blips
	while( i<20 && EnemyLoc[i]!=vect(0,0,0) )
	{
		Canvas.DrawColor.R = 200;
		Canvas.DrawColor.B = 0;
		Canvas.DrawColor.G = 50;
		RelLoc = Viewer.Location - EnemyLoc[i];
		arc = (Viewer.Rotation.Yaw - 16384) / 182.04 / 360;
		d = arc * 2 * PI;
		x =  (RelLoc.X*cos(d)+RelLoc.Y*sin(d))/17+CenterX-1;
		y = (-RelLoc.X*sin(d)+RelLoc.Y*cos(d))/17+CenterY-1;
		Canvas.SetPos(x,y);

		Canvas.DrawIcon(texture'WhiteTexture', 0.1);
		i++;
	}
	Canvas.DrawColor = ActualC;
}
simulated function Tick(float DeltaTime)
{
	local Pawn S;
	local int i;
	
	if( Owner==None || !Owner.IsA('PlayerPawn') ) Return;
	ReChecking+=DeltaTime;
	if( ReChecking>0.1 )
	{
		ReChecking=0;
		ForEach RadiusActors(class'Pawn',S,900,Owner.Location)
		{
			if( !bChecked && S.bIsPlayer )
			{
				bIsDM = (Level.Game.ReduceDamage(999,'None',S,Pawn(Owner))>0 );
				bChecked = True;
			}
			if( S!=Pawn(Owner) && ((!S.bIsPlayer && !bIsDM) || bIsDM) &&
			 S.bCollideActors )
			{
				if( i>19 ) Return;
				else EnemyLoc[i]=S.Location;
				i++;
			}
		}
		while( i<20 )
		{
			EnemyLoc[i]=vect(0,0,0);
			i++;
		}
	}
}
function AltFire( float Value )
{
	GoToState('AltFiring');

}

///////////////////////////////////////////////////////
state NormalFire
{
	function Fire(float F) 
	{
	}

	function AltFire(float F) 
	{
	}

Begin:
	FinishAnim();
	Finish();
}

function Timer()
{
	local actor targ;
	local float bestAim, bestDist;
	local vector FireDir;

	bestAim = 0.95;
	if ( Pawn(Owner) == None )
	{
		GotoState('');
		return;
	}
	FireDir = vector(Pawn(Owner).ViewRotation);
	targ = Pawn(Owner).PickTarget(bestAim, bestDist, FireDir, Owner.Location);
	if ( Pawn(targ) != None )
	{
		SetTimer(1 + 4 * FRand(), false);
		bPointing = true;
		Pawn(targ).WarnTarget(Pawn(Owner), 200, FireDir);
	}
	else 
	{
		SetTimer(0.4 + 1.6 * FRand(), false);
		bPointing = false;
	}
}	

function PlayAltFiring()
{
	if ( PlayerPawn(Owner) != None )
		PlayerPawn(Owner).shakeview(ShakeTime, ShakeMag, ShakeVert);
	Owner.PlaySound(FireSound, SLOT_None,Pawn(Owner).SoundDampening*3.0,,,0.9 + 0.2 * FRand());
	PlayAnim('Fire', 2.0,0.05);
}

function PlayFiring()
{
	Owner.PlaySound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim('Fire', 0.5,0.05);
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local vector SmokeLocation,DVector;
	local rotator SmokeRotation;
	local float NumPoints;
	local int i;
	local class<RingExplosion> rc;
	local RingExplosion r;

	if (Other==None)
	{
		HitNormal = -X;
		HitLocation = Owner.Location + X*10000.0;
	}

	SmokeLocation = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * 3.3 * Y + FireOffset.Z * Z * 3.0;
	DVector = HitLocation - SmokeLocation;
	NumPoints = VSize(DVector)/70.0;
	SmokeLocation += DVector/NumPoints;
	SmokeRotation = rotator(HitLocation-Owner.Location);
	if (NumPoints>15) NumPoints=15;
	if ( NumPoints>1.0 ) SpawnEffect(DVector, NumPoints, SmokeRotation, SmokeLocation);

	rc = class'SupaRing';
			 
	r = Spawn(rc,,, HitLocation+HitNormal*8,rotator(HitNormal));
	if ( r != None )
	{
		r.DrawScale=0.5;
		r.PlaySound(r.ExploSound,,6);
	}

	if ( (Other != self) && (Other != Owner) && (Other != None) ) 
		Other.TakeDamage(100, Pawn(Owner), HitLocation, 50000.0*X, 'shot');
}


function SpawnEffect(Vector DVector, int NumPoints, rotator SmokeRotation, vector SmokeLocation)
{
	local RingExplosion4 Smoke;
	
	Smoke = Spawn(class'ElectricBolt',,,SmokeLocation,SmokeRotation);
	Smoke.MoveAmount = DVector/NumPoints;
	Smoke.NumPuffs = NumPoints;
}

function Finish()
{
	//bMuzzleFlash = 0;
	if ( ((Pawn(Owner).bFire!=0) || (Pawn(Owner).bAltFire!=0)) && (FRand() < 0.6) )
		Timer();
	Super.Finish();
}

state Idle
{

	function AltFire( float Value )
	{
		GoToState('AltFiring');
	}

	function Fire( float Value )
	{
		if (AmmoType.UseAmmo(1))
		{
			GotoState('NormalFire');
			if ( PlayerPawn(Owner) != None )
				PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
			bPointing=True;
			TraceFire(0.0);
			PlayFiring();
			CheckVisibility();
		}
	}


	function BeginState()
	{
		if (Pawn(Owner).bFire!=0) Fire(0.0);		
		bPointing = false;
		SetTimer(0.4 + 1.6 * FRand(), false);
		Super.BeginState();
	}

	function EndState()
	{	
		SetTimer(0.0, false);
		Super.EndState();
	}
	
Begin:
	bPointing=False;
	if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0) ) 
		Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
	if ( Pawn(Owner).bFire!=0 ) Fire(0.0);
	Disable('AnimEnd');
	PlayIdleAnim();
}

///////////////////////////////////////////////////////
state AltFiring
{

function Timer()
{
	if (Pawn(Owner).bAltFire == 0)
	{
		if (PlayerPawn(Owner) != None)
			PlayerPawn(Owner).StopZoom();
		SetTimer(0.0,False);
		GoToState('Idle');
	}
}

Begin:
	if ( Owner.IsA('PlayerPawn') )
	{
		PlayerPawn(Owner).ToggleZoom();
		SetTimer(0.075,True);
	}
	else
	{
		Pawn(Owner).bFire = 1;
		Pawn(Owner).bAltFire = 0;
		Global.Fire(0);
	}
}

///////////////////////////////////////////////////////////
function PlayIdleAnim()
{
	PlayAnim('Still',1.0, 0.05);
}

defaultproperties
{
     AmmoName=Class'UnrealI.RifleAmmo'
     PickupAmmoCount=50
     bInstantHit=True
     bAltInstantHit=True
     FireOffset=(Y=-5.000000,Z=-2.000000)
     shakemag=400.000000
     shaketime=0.150000
     FireSound=Sound'UnrealI.Rifle.RifleShot'
     SelectSound=Sound'UnrealI.Rifle.RiflePickup'
     DeathMessage="%k put a bullet through %o's head."
     AutoSwitchPriority=9
     InventoryGroup=9
     PickupMessage="You got the Air-Rifle"
     ItemName="Air Rifle"
     PlayerViewOffset=(X=3.200000,Y=-1.200000,Z=-1.700000)
     PlayerViewMesh=LodMesh'UnrealI.RifleM'
     PickupViewMesh=LodMesh'UnrealI.RiPick'
     ThirdPersonMesh=LodMesh'UnrealI.Rifle3rd'
     PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
     Style=STY_Masked
     Texture=Texture'UnrealShare.BloodyPuff.bp_A01'
     Mesh=LodMesh'UnrealI.RiPick'
     bMeshEnviroMap=True
}
