//=============================================================================
// Alien.
//=============================================================================
class Alien expands Pack6Pawns;

#exec MESH IMPORT MESH=Pupae1 ANIVFILE=MODELS\pupae_a.3D DATAFILE=MODELS\pupae_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Pupae1 X=0 Y=0 Z=-90 YAW=64 PITCH=0 ROLL=-64

#exec MESH SEQUENCE MESH=pupae1 SEQ=All		 STARTFRAME=0	 NUMFRAMES=171
#exec MESH SEQUENCE MESH=pupae1 SEQ=Bite     STARTFRAME=0    NUMFRAMES=15  RATE=15  Group=Attack
#exec MESH SEQUENCE MESH=pupae1 SEQ=Crawl    STARTFRAME=15   NUMFRAMES=20  RATE=20
#exec MESH SEQUENCE MESH=pupae1 SEQ=Dead     STARTFRAME=35   NUMFRAMES=18  RATE=15
#exec MESH SEQUENCE MESH=pupae1 SEQ=TakeHit  STARTFRAME=36   NUMFRAMES=1
#exec MESH SEQUENCE MESH=pupae1 SEQ=Fighter  STARTFRAME=53   NUMFRAMES=6   RATE=6
#exec MESH SEQUENCE MESH=pupae1 SEQ=Lunge    STARTFRAME=59   NUMFRAMES=15  RATE=15  Group=Attack
#exec MESH SEQUENCE MESH=pupae1 SEQ=Munch    STARTFRAME=74   NUMFRAMES=8   RATE=15
#exec MESH SEQUENCE MESH=pupae1 SEQ=Pick     STARTFRAME=82   NUMFRAMES=10  RATE=15
#exec MESH SEQUENCE MESH=pupae1 SEQ=Stab     STARTFRAME=92   NUMFRAMES=10  RATE=15  Group=Attack
#exec MESH SEQUENCE MESH=pupae1 SEQ=Tear     STARTFRAME=102  NUMFRAMES=28  RATE=15
#exec MESH SEQUENCE MESH=pupae1 SEQ=Dead2    STARTFRAME=130  NUMFRAMES=18  RATE=15
#exec MESH SEQUENCE MESH=pupae1 SEQ=Dead3    STARTFRAME=148  NUMFRAMES=23  RATE=15

#exec TEXTURE IMPORT NAME=JPupae1 FILE=MODELS\pupae.PCX GROUP=Skins 
#exec MESHMAP SCALE MESHMAP=pupae1 X=0.05 Y=0.05 Z=0.1
#exec MESHMAP SETTEXTURE MESHMAP=pupae1 NUM=1 TEXTURE=Jpupae1

#exec MESH NOTIFY MESH=Pupae1 SEQ=Dead TIME=0.52 FUNCTION=LandThump

#exec AUDIO IMPORT FILE="Sounds\Pupae\scuttle1.WAV" NAME="scuttle1pp" GROUP="Pupae"
#exec AUDIO IMPORT FILE="Sounds\Pupae\injur1.WAV" NAME="injur1pp" GROUP="Pupae"
#exec AUDIO IMPORT FILE="Sounds\Pupae\injur2.WAV" NAME="injur2pp" GROUP="Pupae"
#exec AUDIO IMPORT FILE="Sounds\Pupae\roam1.WAV" NAME="roam1pp" GROUP="Pupae"
#exec AUDIO IMPORT FILE="Sounds\Pupae\hiss1.WAV" NAME="hiss1pp" GROUP="Pupae"
#exec AUDIO IMPORT FILE="Sounds\Pupae\hiss2.WAV" NAME="hiss2pp" GROUP="Pupae"
#exec AUDIO IMPORT FILE="Sounds\Pupae\hiss3.WAV" NAME="hiss3pp" GROUP="Pupae"
#exec AUDIO IMPORT FILE="Sounds\Pupae\bite1pp.WAV" NAME="bite1pp" GROUP="Pupae"
#exec AUDIO IMPORT FILE="Sounds\Pupae\tear1b.WAV" NAME="tear1pp" GROUP="Pupae"
#exec AUDIO IMPORT FILE="Sounds\Pupae\munch1pp.WAV" NAME="munch1p" GROUP="Pupae"
#exec AUDIO IMPORT FILE="Sounds\Pupae\death1b.WAV" NAME="death1pp" GROUP="Pupae"

//-----------------------------------------------------------------------------
// Pupae variables.

// Attack damage.
var() byte BiteDamage;		// Basic damage done by bite.
var() byte LungeDamage;		// Basic damage done by bite.
var(Sounds) sound bite;
var(Sounds) sound stab;
var(Sounds) sound lunge;
var(Sounds) sound chew;
var(Sounds) sound tear;
var vector MoveVect,OldVect;
var Nest Ohw;
var bool bGuard;
var carcass FoodToEat;
 
//-----------------------------------------------------------------------------
// Pupae functions.

function PostBeginPlay()
{
	Super.PostBeginPlay();
	MaxDesiredSpeed = 0.7 + 0.1 * skill;
}

function JumpOffPawn()
{
	Super.JumpOffPawn();
	PlayAnim('crawl', 1.0, 0.2);
}
function WhatToDoNext(name LikelyState, name LikelyLabel)
{
	bQuiet = false;
	GotoState('IdleMoving');
}
function SetMovementPhysics()
{
	SetPhysics(PHYS_Falling); 
}

function eAttitude AttitudeToCreature(Pawn Other)
{
	if ( Other.IsA('Alien') )
		return ATTITUDE_Friendly;
	else
		return ATTITUDE_Hate;
}

function PlayWaiting()
{
	local float decision;
	local float animspeed;
	animspeed = 0.4 + 0.6 * FRand(); 
	decision = FRand();
	if ( !bool(NextAnim) || (decision < 0.4) ) //pick first waiting animation
	{
		if ( !bQuiet )
			PlaySound(Chew, SLOT_Talk, 0.7,,800);
		NextAnim = 'Munch';
	}
	else if (decision < 0.55)
		NextAnim = 'Pick';
	else if (decision < 0.7)
	{
		if ( !bQuiet )
			PlaySound(Stab, SLOT_Talk, 0.7,,800);
		NextAnim = 'Stab';
	}
	else if (decision < 0.7)
		NextAnim = 'Bite';
	else 
		NextAnim = 'Tear';
		
	LoopAnim(NextAnim, animspeed);
	}

function PlayPatrolStop()
{
	PlayWaiting();
}

function PlayWaitingAmbush()
{
	PlayWaiting();
}

function PlayChallenge()
{
	if ( FRand() < 0.3 )
		PlayWaiting();
	else
		PlayAnim('Fighter');
}

function TweenToFighter(float tweentime)
{
	TweenAnim('Fighter', tweentime);
}

function TweenToRunning(float tweentime)
{
	if (AnimSequence != 'Crawl' || !bAnimLoop)
		TweenAnim('Crawl', tweentime);
}

function TweenToWalking(float tweentime)
{
	TweenAnim('Crawl', tweentime);
}

function TweenToWaiting(float tweentime)
{
	TweenAnim('Munch', tweentime);
}

function TweenToPatrolStop(float tweentime)
{
	TweenAnim('Munch', tweentime);
}

function PlayRunning()
{
	PlaySound(sound'scuttle1pp', SLOT_Interact);
	LoopAnim('Crawl', -4.0/GroundSpeed,,0.4);
}

function PlayWalking()
{
	PlaySound(sound'scuttle1pp', SLOT_Interact);
	LoopAnim('Crawl', -4.0/GroundSpeed,,0.4);
}

function PlayThreatening()
{
	PlayWaiting();
}

function PlayTurning()
{
	TweenAnim('Crawl', 0.3);
}

function PlayDying(name DamageType, vector HitLocation)
{
	local carcass carc;

	PlaySound(Die, SLOT_Talk, 3.5 * TransientSoundVolume);
	if ( FRand() < 0.35 )
		PlayAnim('Dead', 0.7, 0.1);
	else if ( FRand() < 0.5 )
	{
		carc = Spawn(class 'CreatureChunks',,, Location + CollisionHeight * vect(0,0,0.8), Rotation + rot(3000,0,16384) );
		if (carc != None)
		{
			carc.Mesh = mesh'PupaeHead';
			carc.Initfor(self);
			carc.Velocity = Velocity + VSize(Velocity) * VRand();
			carc.Velocity.Z = FMax(carc.Velocity.Z, Velocity.Z);
		}
		PlayAnim('Dead2', 0.7, 0.1);
	}
	else
	{
		carc = Spawn(class 'CreatureChunks',,, Location + CollisionHeight * vect(0,0,0.8), Rotation + rot(3000,0,16384) );
		if (carc != None)
		{
			carc.Mesh = mesh'PupaeBody';
			carc.Initfor(self);
			carc.Velocity = Velocity + VSize(Velocity) * VRand();
			carc.Velocity.Z = FMax(carc.Velocity.Z, Velocity.Z);
		}
		PlayAnim('Dead3', 0.7, 0.1);
	}
}

function PlayTakeHit(float tweentime, vector HitLoc, int damage)
{
	PlayAnim('TakeHit');
}

function PlayVictoryDance()
{
	PlayAnim('Stab', 1.0, 0.1);
}

function PlayMeleeAttack()
{
	local float dist, decision;

	if(  Health<=0 )
	{
		Log(Self@"wanted to attack while dead");
		SpawnGibbedCarcass();
		Destroy();
	}
	decision = FRand();
	dist = VSize(Target.Location - Location);
	if (dist > CollisionRadius + Target.CollisionRadius + 45)
		decision = 0.0;

	if (Physics == PHYS_Falling)
		decision = 1.0;
	if (Target == None)
		decision = 1.0;

	if (decision < 0.15)
	{
		PlaySound(Lunge, SLOT_Interact);
		Enable('Bump');
		PlayAnim('Lunge');
		Velocity = 1250 * Normal(Target.Location + Target.CollisionHeight * vect(0,0,0.75) - Location);
		if (dist > CollisionRadius + Target.CollisionRadius + 35)
			Velocity.Z += 0.3 * dist;
		SetPhysics(PHYS_Falling);
	}
  	else
  	{
  		PlaySound(Stab, SLOT_Interact);
  		PlayAnim('Stab');
		MeleeRange = 50;
		if( MeleeDamageTarget(BiteDamage, vect(0,0,0)) && Target.IsA('Pawn') && Pawn(Target).Health<=0 )
			Target.Spawn(class'Alien');
		MeleeRange = Default.MeleeRange;
	}  		
}

state MeleeAttack
{
ignores SeePlayer, HearNoise;

	singular function Bump(actor Other)
	{
		Disable('Bump');
		if ( (Other == Target) && (AnimSequence == 'Lunge') )
			if (MeleeDamageTarget(LungeDamage, vect(0,0,0)))
			{
				if (FRand() < 0.5)
					PlaySound(Tear, SLOT_Interact);
				else
					PlaySound(Bite, SLOT_Interact);
				if( Target.IsA('Pawn') && Pawn(Target).Health<=0 )
					Target.Spawn(class'Alien');
			}
	}
}		

auto state StartUp
{
	function SetMovementPhysics()
	{
		SetPhysics(PHYS_Spider); // don't fall at start
	}
}
state Hunting
{
	function Landed(vector HitNormal)
	{
		Super.Landed(HitNormal);
		SetPhysics(PHYS_Spider);
	}
	function PickDestination()
	{
		local NavigationPoint path;
		local actor HitActor;
		local vector HitNormal, HitLocation, nextSpot, ViewSpot;
		local float posZ, elapsed;
		local bool bCanSeeLastSeen;

		// If no enemy, or I should see him but don't, then give up		
		if ( (Enemy == None) || (Enemy.Health <= 0) )
		{
			WhatToDoNext('','');
			return;
		}
		bAvoidLedges = false;
		elapsed = Level.TimeSeconds - HuntStartTime;
		if ( (elapsed > 60) && ((intelligence < BRAINS_Human) || (elapsed > 90)) )
		{
				WhatToDoNext('','');
				return;
		}
		if ( JumpZ > 0 )
			bCanJump = true;
		if ( Enemy.Health>0 )
		{
			Destination = Enemy.Location;
			MoveTarget = Enemy;
			numHuntPaths++;
		}
		else
			WhatToDoNext('','');
	}
	function HitWall(vector HitNormal, actor Wall)
	{
		Super(Actor).HitWall(HitNormal,Wall);
	}
AdjustFromWall:
	Sleep(0.1);
}
state TacticalMove
{
	function Landed(vector HitNormal)
	{
		Super.Landed(HitNormal);
		SetPhysics(PHYS_Spider);
	}
	function HitWall(vector HitNormal, actor Wall)
	{
		Super(Actor).HitWall(HitNormal,Wall);
	}
AdjustFromWall:
	Sleep(0.1);
}
state Charging
{
	function Landed(vector HitNormal)
	{
		Super.Landed(HitNormal);
		SetPhysics(PHYS_Spider);
	}
	function HitWall(vector HitNormal, actor Wall)
	{
		Super(Actor).HitWall(HitNormal,Wall);
	}
AdjustFromWall:
	Sleep(0.1);
}
state Attacking
{
	function HitWall(vector HitNormal, actor Wall)
	{
		Super(Actor).HitWall(HitNormal,Wall);
	}
AdjustFromWall:
	Sleep(0.1);
}
function Landed(vector HitNormal)
{
	Super.Landed(HitNormal);
	SetPhysics(PHYS_Spider);
}
State IdleMoving
{
	function CheckEnemys()
	{
		local Carcass FOOD,Closest;
		local float ClosestD,ThisD;
		
		if( CheckVisibleEnemys() )
			Return;
		if( FoodToEat!=None ) Return;
		ClosestD = 1000;
		ForEach VisibleActors(class'Carcass',FOOD,1000)
		{
			if( !FOOD.bNoDelete && !FOOD.bStatic && !FOOD.bHidden )
			{
				ThisD = VSize(FOOD.Location-Location);
				if( ThisD<ClosestD )
				{
					ClosestD = ThisD;
					Closest=FOOD;
				}
			}
		}
		if( Closest!=None )
		{
			FoodToEat=Closest;
			GoToState('IdleMoving','GetFood');
		}
	}
Begin:
	PlayRunning();
FindASpot:
	FoodToEat=none;
	if( bGuard )
		MoveVect = Ohw.Location;
	else MoveVect = Location;
	MoveVect.X += Rand(1000)-500;
	MoveVect.Y += Rand(1000)-500;
	MoveVect.Z += Rand(1000)-500;
DoMove:
	PlayRunning();
	bCanJump=False;
	MoveTo(MoveVect,Groundspeed*7);
	if( OldVect==MoveVect )
		Sleep(0.2);
	else OldVect=MoveVect;
	CheckEnemys();
	GoTo('FindASpot');
GetFood:
	SetPhysics(PHYS_Spider);
	if( FoodToEat==None || FoodToEat.Class==None || FoodToEat.bHidden ) GoTo('FindASpot');
	PlayRunning();
	MoveToward(FoodToEat,Groundspeed);
	if( FoodToEat==None || FoodToEat.Class==None || FoodToEat.bHidden ) GoTo('FindASpot');
Eating:
	if( FoodToEat==None || FoodToEat.Class==None || FoodToEat.bHidden || FoodToEat.bDeleteMe )
	{
		FoodToEat=None;
		CheckEnemys();
		GoTo('FindASpot');
	}
	SetPhysics(PHYS_Walking);
	Acceleration = vect(0,0,0); //stop
	if (NeedToTurn(FoodToEat.Location))
	{	
		PlayTurning();
		TurnToward(FoodToEat);
		FinishAnim();
		NextAnim = '';
	}
	if( FRand()<0.3 )
	{
		PlaySound(Lunge, SLOT_Interact);
		PlayAnim('Lunge',2);
		FoodToEat.TakeDamage(20,Self,(FoodToEat.Location-Location)/2+Location,2 * Velocity,'hacked');
		if( Health<=Default.Health )
			Health+=20;
	}
	else
	{
		PlaySound(Stab, SLOT_Interact);
  		PlayAnim('Stab',4);
  		FoodToEat.TakeDamage(5,Self,(FoodToEat.Location-Location)/2+Location,2 * Velocity,'hacked');
  		if( Health<=Default.Health )
  			Health+=5;
  	}
  	FinishAnim();
  	SetPhysics(PHYS_Spider);
  	GoTo('Eating');
}
state Guarding
{
	Event BeginState()
	{
		GoToState('IdleMoving');
	}
}
state Wandering
{
	Event BeginState()
	{
		GoToState('IdleMoving');
	}
}
state Waiting
{
	Event BeginState()
	{
		GoToState('IdleMoving');
	}
}
event HearNoise( float Loudness, Actor NoiseMaker)
{
	if( NoiseMaker.IsA('Pawn') )
		SetEnemy(Pawn(NoiseMaker));
}
event SeePlayer( actor Seen )
{
	if( Seen.IsA('Pawn') )
		SetEnemy(Pawn(Seen));
}
function bool SetEnemy(Pawn NewEnemy)
{
	if( NewEnemy.Health<=0 ) Return false;
	if( NewEnemy.IsA('Alien') || NewEnemy.IsA('FlockPawn') ) Return false;
	else if( NewEnemy.IsA('ScriptedPawn') )
	{
		if( Enemy!=None && Enemy!=NewEnemy )
			OldEnemy=Enemy;
		Enemy=NewEnemy;
		Target=NewEnemy;
	}
	else
	{
		if( Enemy!=None && Enemy!=NewEnemy )
			OldEnemy=Enemy;
		Enemy=NewEnemy;
		Target=NewEnemy;
	}
	if( IsInState('IdleMoving') ) GoToState('Attacking');
	Return true;
}
Event Destroyed()
{
	if( Ohw!=None )
	{
		if( bGuard )
			Ohw.NrGuards--;
		else
			Ohw.NrAlins--;
	}
	Super.Destroyed();
}

defaultproperties
{
     BiteDamage=204
     LungeDamage=255
     Bite=Sound'UnrealI.Pupae.bite1pp'
     Stab=Sound'UnrealI.Pupae.hiss1pp'
     lunge=Sound'UnrealI.Pupae.hiss2pp'
     Chew=Sound'UnrealI.Pupae.munch1p'
     Tear=Sound'UnrealI.Pupae.tear1pp'
     CarcassType=Class'UnrealI.PupaeCarcass'
     Aggressiveness=10.000000
     Acquire=Sound'UnrealI.Pupae.hiss2pp'
     Fear=Sound'UnrealI.Pupae.hiss1pp'
     Roam=Sound'UnrealI.Pupae.roam1pp'
     Threaten=Sound'UnrealI.Pupae.hiss3pp'
     bCanStrafe=True
     MeleeRange=280.000000
     GroundSpeed=850.000000
     AccelRate=2800.000000
     JumpZ=540.000000
     SightRadius=50000.000000
     PeripheralVision=5.100000
     HearingThreshold=0.010000
     Health=40
     Intelligence=BRAINS_REPTILE
     Skill=9.000000
     HitSound1=Sound'UnrealI.Pupae.injur1pp'
     HitSound2=Sound'UnrealI.Pupae.injur2pp'
     Die=Sound'UnrealI.Pupae.death1pp'
     Physics=PHYS_Spider
     DrawType=DT_Mesh
     Mesh=LodMesh'UnrealI.Pupae1'
     Fatness=179
     CollisionRadius=28.000000
     CollisionHeight=9.000000
     Mass=80.000000
}
