//=============================================================================
// AllWeaponP.
//=============================================================================
class AllWeaponP expands Pack6Weps;

function PlayIdleAnim()
{
	PlayAnim('Idle',1.0,0.0);
}
function Projectile ProjectileFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
	local Vector Start, X,Y,Z;
	local Rotator ARot;
	local Pawn PawnOwner;
	local Weapon W;
	local int i;
	local class<weapon> we;

	PawnOwner = Pawn(Owner);
	Owner.MakeNoise(PawnOwner.SoundDampening);
	GetAxes(PawnOwner.ViewRotation,X,Y,Z);
	Start = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = PawnOwner.AdjustAim(ProjSpeed, Start, AimError, True, bWarn);
	while( i<10 )
	{
		if( i== 0 ) we=class'Automag';
		else if( i== 1 ) we=class'Stinger';
		else if( i== 2 ) we=class'ASMD';
		else if( i== 3 ) we=class'Eightball';
		else if( i== 4 ) we=class'FlakCannon';
		else if( i== 5 ) we=class'Razorjack';
		else if( i== 6 ) we=class'GESBioRifle';
		else if( i== 7 ) we=class'Rifle';
		else if( i== 8 ) we=class'Minigun';
		else we=class'DispersionPistol';
		W = Spawn(we,,, Start,AdjustedAim);
		W.PickupAmmoCount=9999;
		ARot = AdjustedAim;
		ARot.Roll += Rand(1000)-500;
		ARot.Yaw += Rand(1000)-500;
		ARot.Pitch += Rand(1000)-500;
		W.Velocity = Vector(ARot)*(Rand(500)+700);
		W.RemoteRole = ROLE_DumbProxy;
		W.SetPhysics(PHYS_Falling);
		W.bCollideWorld = true;
		W.GotoState('Pickup', 'Dropped');
		W.RespawnTime=0;
		i++;
	}
	return None;	
}
function PlayFiring()
{
	PlayAnim('Fire',1.0,0.0);
	AmmoType.AmmoAmount=0;
}

function PlayAltFiring()
{
	PlayAnim('Fire',1.0,0.0);
	AmmoType.AmmoAmount=0;
}

defaultproperties
{
     AmmoName=Class'Pack6.RocketCan2'
     PickupAmmoCount=1
     shakemag=350.000000
     FireSound=Sound'UnrealShare.Eightball.Ignite'
     AltFireSound=Sound'UnrealShare.Eightball.Ignite'
     SelectSound=Sound'UnrealShare.Eightball.Selecting'
     AutoSwitchPriority=5
     InventoryGroup=5
     PickupMessage="You got the Eightball gun"
     ItemName="Eightball"
     RespawnTime=0.000000
     PlayerViewOffset=(X=1.900000,Z=-1.890000)
     PlayerViewMesh=LodMesh'UnrealShare.EightB'
     PickupViewMesh=LodMesh'UnrealShare.EightPick'
     ThirdPersonMesh=LodMesh'UnrealShare.8Ball3rd'
     PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
     Mesh=LodMesh'UnrealShare.EightPick'
     CollisionHeight=10.000000
}
