//=============================================================================
// BannQuery.
//=============================================================================
class BannQuery expands UdpServerQuery;

var UdpServerQuery Orginal;
var AdminMut AM;

event ReceivedText( IpAddr Addr, string Text )
{
	if( !bIsBanned(Addr) )
	{
		if( Orginal!=None && Orginal!=Self ) Orginal.ReceivedText(Addr,Text);
		else Super.ReceivedText(Addr,Text);
	}
}
function string ParseQuery( IpAddr Addr, coerce string Query, int QueryNum, out int PacketNum )
{
	if( !bIsBanned(Addr) )
	{
		if( Orginal!=None && Orginal!=Self ) Return Orginal.ParseQuery(Addr,Query,QueryNum,PacketNum);
		else Return Super.ParseQuery(Addr,Query,QueryNum,PacketNum);
	}
	else Return "";
}
function bool SendQueryPacket(IpAddr Addr, coerce string SendString, int QueryNum, int PacketNum, string FinalPacket)
{
	if( !bIsBanned(Addr) )
	{
		if( Orginal!=None && Orginal!=Self ) Return Orginal.SendQueryPacket(Addr,SendString,QueryNum,PacketNum,FinalPacket);
		else Return Super.SendQueryPacket(Addr,SendString,QueryNum,PacketNum,FinalPacket);
	}
	else Return False;
}
function bool SendPlayers(IpAddr Addr, int QueryNum, out int PacketNum, string FinalPacket)
{
	if( !bIsBanned(Addr) )
	{
		if( Orginal!=None && Orginal!=Self ) Return Orginal.SendPlayers(Addr,QueryNum,PacketNum,FinalPacket);
		else Return Super.SendPlayers(Addr,QueryNum,PacketNum,FinalPacket);
	}
	else Return False;
}
function bool bIsBanned(IpAddr Addr)
{
	local string S;
	local int i;
	
	S = IpAddrToString(Addr);
	if( InStr(S, ":") >= 0 )
		S = Left(S,InStr(S, ":"));
	for (i = 0; i< 30; i++)
		if( S==AM.GetIPOf(i) )
			Return False;
	Return True;
}

defaultproperties
{
}
