//=============================================================================
// Barnacle.
//=============================================================================
class Barnacle expands Pack6Pawns;

var ToungeTarget TT;
var(Sounds) sound mebax;
var bool bEating;
var() int BiteDamage;
var EPhysics OldPhy;
var weapon OldWeapon;

function PreBeginPlay()
{
	local vector HitLocation,HitNormal;
	local int NrTounghtShit,i;
	local Tounge T;
	
	Super.PreBeginPlay();
	
	if( Trace(HitLocation,HitNormal,Location+vect(0,0,100),Location,false)!=None )
	{
		SetLocation((HitLocation+HitNormal*8)-vect(0,0,30));
		SetRotation(rotator(HitNormal)+rot(16384,0,0));
	}
	TT = Spawn(class'ToungeTarget');
	TT.SetOwner(Self);
	for (i = 0; i< 11; i++)
	{
		T = Spawn(class'Tounge');
		T.SetOwner(Self);
		T.MoveVect = i+1/10;
		T.Target = TT;
	}
}
function Tick(float DeltaTime)
{
	if( !IsInState('Dead') )
	{
		if( Health>0 )
			GoToState('Lick');
		else GoToState('Dead');
	}
}
Auto state Lick
{
ignores HitWall,SeePlayer,SetEnemy;
	Event HearNoise( float Loudness, Actor NoiseMaker);
	simulated function Tick(float DeltaTime)
	{
		local vector HitLocation,HitNormal,Loc;
		
		if( Target==None )
		{
			Target=Trace(HitLocation,HitNormal,TT.Location,Location,true);
			if( Target==None ) Return;
			if( Target.IsA('Pawn') && Pawn(Target).Health>0 && !Target.IsA('LickerTentacle') )
			{
				TT.SetLocation(Target.Location);
				OldPhy = Target.Physics;
				OldWeapon = Pawn(Target).Weapon;
				Target.SetPhysics(PHYS_Projectile);
				GoToState('Lick','GotEnemy');
			}
			else Target=None;
		}
		else
		{
			Target.SetPhysics(PHYS_Projectile);
			Target.SetLocation(TT.Location);
			Target.Velocity = TT.Velocity;
			Pawn(Target).Weapon=None;
			if( TT.Location.Z>=Location.Z && !bEating )
			{
				GoToState('Lick','EatEnemy');
				bEating = True;
			}
		}
	}
Begin:
	PlayAnim('Curl');
	bEating = False;
	PlaySound(Sound'curltn', SLOT_Interact);
	TT.SetPhysics(PHYS_Projectile);
	TT.Velocity.Z=-300;
	Stop;
GotEnemy:
	bEating = False;
	PlaySound(Sound'yell1tn', SLOT_Interact);
Redo:
	Target.SetLocation(TT.Location);
	Pawn(Target).Weapon=None;
	TT.SetRotation(rotator(Location - Target.Location));
	TT.Velocity=vector(TT.Rotation)*200;
	PlayAnim('Uncurl');
	FinishAnim();
	LoopAnim('Move2');
	Stop;
EatEnemy:
	TT.Velocity=vect(0,0,0);
	TT.SetLocation(Location);;
	PlaySound(Sound'injured1tn', SLOT_Interact);
	PlayAnim('Smack',2,0.1);
	FinishAnim();
	PlaySound(Sound'splat2tn', SLOT_Interact);
	Target.TakeDamage(BiteDamage,Self,Location,vect(0,0,0), 'hacked');
	if( Pawn(Target).Health<=0 )
	{
		if( Target.Class!=None )
			Target.SetPhysics(OldPhy);
		Target=None;
		GoTo('Begin');
	}
	Sleep(0.2);
	GoTo('EatEnemy');
}
function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
{
	local int actualDamage;

	actualDamage = Level.Game.ReduceDamage(Damage, DamageType, self, instigatedBy);
	if ( (InstigatedBy != None) &&
				(InstigatedBy.IsA(Class.Name) || self.IsA(InstigatedBy.Class.Name)) )
		ActualDamage = ActualDamage * FMin(1 - ReducedDamagePct, 0.35); 
	else if ( (ReducedDamageType == 'All') || 
		((ReducedDamageType != '') && (ReducedDamageType == damageType)) )
		actualDamage = float(actualDamage) * (1 - ReducedDamagePct);
	
	Health -= actualDamage;
	if (CarriedDecoration != None)
		DropDecoration();
	if ( HitLocation == vect(0,0,0) )
	{
		//FIXEM@ log("Zero hit loc instigated by"@Instigator@"with weapon"@Instigator.weapon); //FIXME remove
		HitLocation = Location;
	}
	if (Health > 0)
	{
		if (instigatedBy != None)
			damageAttitudeTo(instigatedBy);
		PlaySound(Sound'injured2tn', SLOT_Interact);
		PlayAnim('TakeHit',,0.2);
	}
	else
	{
	//log(self$" died");
		NextState = '';
		PlayDeathHit(actualDamage, hitLocation, damageType);
		if ( actualDamage > mass )
			Health = -1 * actualDamage;
		Enemy = instigatedBy;
		if( Target!=None && Target.Class!=None )
		{
			Pawn(Target).Weapon = OldWeapon;
			Target.SetPhysics(OldPhy);
		}
		Died(instigatedBy, damageType, HitLocation);
		MakeNoise(1.0);
	}
}
function PlayDying(name DamageType, vector HitLocation)
{
	PlaySound(Die, SLOT_Talk, 3 * TransientSoundVolume);
}
Event KillTounge()
{
	local Tounge T;
	
	ForEach AllActors(class'Tounge',T)
		if( T.Owner==Self )
			T.Destroy();
	Super.Destroyed();
}
function Died(pawn Killer, name damageType, vector HitLocation)
{
	local pawn OtherPawn;
	local actor A;

	if ( bDeleteMe )
		return; //already destroyed
	Health = Min(0, Health);
	for ( OtherPawn=Level.PawnList; OtherPawn!=None; OtherPawn=OtherPawn.nextPawn )
		OtherPawn.Killed(Killer, self, damageType);
	if ( CarriedDecoration != None )
		DropDecoration();
	level.game.Killed(Killer, self, damageType);
	//log(class$" dying");
	if( Event != '' )
		foreach AllActors( class 'Actor', A, Event )
			A.Trigger( Self, Killer );
	Level.Game.DiscardInventory(self);
	PlayDying(DamageType, HitLocation);
	if ( Level.Game.bGameEnded )
		return;
	GoToState('Dead');
}
state Dead
{
Ignores TakeDamage,SetEnemy,Tick;
	event HearNoise( float Loudness, Actor NoiseMaker);
	event SeePlayer( actor Seen );
Begin:
	KillTounge();
	TweenAnim('Move2',0.4);
	Sleep(0.4);
	LoopAnim('Move2');
	SpawnGibbedCarcass();
	Sleep(0.1);
	SpawnGibbedCarcass();
	Sleep(0.1);
	SpawnGibbedCarcass();
	Sleep(2);
	PlayAnim('Dead1',1,0.2);
	FinishAnim();
	Sleep(5);
	SpawnCarcass();
	Destroy();
}

defaultproperties
{
     BiteDamage=60
     CarcassType=Class'UnrealShare.TentacleCarcass'
     Health=150
     Die=Sound'UnrealShare.Tentacle.death2tn'
     DrawType=DT_Mesh
     Mesh=LodMesh'UnrealShare.Tentacle1'
     bBlockActors=False
     bBlockPlayers=False
}
