//=============================================================================
// BattleBup.
//=============================================================================
class BattleBup expands Actor;

var Pawn BattlePawns[5];

function Tick(float DeltaTime)
{
	if( DrawScale<100 )
		DrawScale+=(DeltaTime*15);
	
	HurtRadius2(2,(DrawScale*4),10000,Location);
}
function HurtRadius2( float DamageAmount, float DamageRadius, float Momentum, vector HitLocation )
{
	local Pawn Victims;
	local float damageScale, dist;
	local vector dir;
	local bool bBool;
	local int i;
	
	if( bHurtEntry )
		return;

	bHurtEntry = true;
	foreach VisibleCollidingActors( class 'Pawn', Victims, DamageRadius, HitLocation )
	{
		bBool=false;
		for (i = 0; i< 5; i++)
			if( BattlePawns[i]==Victims )
				bBool=true;
		if( Victims != self && Victims != Owner && !bBool )
		{
			dir = Victims.Location - HitLocation;
			dist = FMax(1,VSize(dir));
			dir = dir/dist; 
			damageScale = 1 - FMax(0,(dist - Victims.CollisionRadius)/DamageRadius);
			if( Victims.Physics!=PHYS_None && Victims.Physics!=PHYS_Trailer && Victims.Physics!=PHYS_Projectile )
				Victims.SetPhysics(PHYS_Falling);
			Victims.Velocity = dir*120;
		}
	}
	bHurtEntry = false;
}

defaultproperties
{
     DrawType=DT_Mesh
     Style=STY_Modulated
     Texture=FireTexture'UnrealShare.Belt_fx.Damage.Damage'
     Mesh=LodMesh'UnrealShare.flameballM'
     DrawScale=2.000000
     bMeshEnviroMap=True
     bBlockActors=True
     bBlockPlayers=True
}
