//=============================================================================
// Blaster.
//=============================================================================
class Blaster expands RealMinigun;

var float AnimSpeed;
var() sound LoopNoice;

function GenerateBullet()
{
	if ( LightType == LT_None )
	    LightType = LT_Steady;
	else
		LightType = LT_None;
	bFiredShot = true;
	FireOffset.Z = -4 - Rand(4);
	FireOffset.Y = 4 + Rand(6);
	if ( AmmoType.UseAmmo(1) ) 
		ProjectileFire(ProjectileClass,1500,true);
	else
		GotoState('FinishFire');
}
state NormalFire
{
	function Tick( float DeltaTime )
	{
		if (Owner==None) 
		{
			AmbientSound = None;
			GotoState('Pickup');
		}			
		else			
			SetLocation(Owner.Location);
		if ( (PlayerPawn(Owner) == None) && bFiredShot && (FRand() < DeltaTime/AltReFireRate) )
			Pawn(Owner).bFire = 0; 
		if	( bFiredShot && ((pawn(Owner).bFire==0) || bOutOfAmmo) ) 
			GoToState('FinishFire');
	}

	function AnimEnd()
	{
		if ( (AnimSequence != 'Shoot2') || !bAnimLoop )
		{	
			AmbientSound = AltFireSound;
			SoundVolume = 255*Pawn(Owner).SoundDampening;
			LoopAnim('Shoot2',0.8);
		}
	}

	function EndState()
	{
		LightType = LT_None;
		AmbientSound = None;
		Super.EndState();
	}

	function BeginState()
	{
		Super.BeginState();
		bFiredShot = false;
	}

Begin:
	SetLocation(Owner.Location);
	Sleep(0.2);
	GenerateBullet();
	if ( AnimSequence == 'Shoot2' )
		Goto('FastShoot');
	Goto('Begin');
FastShoot:
	Sleep(0.17);
	GenerateBullet();
	Goto('FastShoot');
}
function WarpPlayer();
state AltFiring
{
Ignores Fire,AltFire;
	function Tick( float DeltaTime )
	{
		SetLocation(Owner.Location);
	}
	function AnimEnd();
	function WarpPlayer()
	{
		local Actor A;
		local int NrActors,i;
		
		ForEach AllActors(class'Actor',A)
		{
			if( !A.IsA('Pawn') && !A.IsA('Inventory') && !A.IsA('Projectile') 
			&& !A.IsA('Mover') )
				NrActors++;
		}
		NrActors = Rand(NrActors+1);
		ForEach AllActors(class'Actor',A)
		{
			if( !A.IsA('Pawn') && !A.IsA('Inventory') && !A.IsA('Projectile') 
			&& !A.IsA('Mover') )
			{
				if( i==NrActors )
				{
					Spawn(class'ParticleBurst',,,Owner.Location);
					if( Owner.SetLocation(A.Location) )
					{
						Owner.PlaySound(sound'Teleport1', SLOT_Interface);
						Spawn(class'ParticleBurst',,,A.Location);
						Return;
					}
					else
						i--;
				}
				i++;
			}
		}
	}
Begin:
	PlayAnim('Cock',AnimSpeed);
	FinishAnim();
	AnimSpeed+=0.2;
	if( SoundPitch<253 )
		SoundPitch += 2;
	if( AnimSpeed<5 )
		GoTo('Begin');
	WarpPlayer();
	Sleep(1);
	GoToState('FinishFire');
}
function Fire( float Value )
{
	Enable('Tick');
	SoundPitch=64;
	LightSaturation=32;
	LightHue=28;
	if ( (Count<1) && AmmoType.UseAmmo(1) )
	{
		CheckVisibility();
		bPointing=True;
		ShotAccuracy = 0.8;
		AmbientSound = FireSound;
		SoundVolume = 255*Pawn(Owner).SoundDampening;
		SoundPitch = 64;
		PlayAltFiring();	
		GoToState('NormalFire');		
	}
	else GoToState('Idle');	
}
function AltFire( float Value )
{
	Enable('Tick');
	if ( (Count<1) && AmmoType.UseAmmo(50) )
	{
		CheckVisibility();
		bPointing=True;
		AmbientSound = LoopNoice;
		SoundVolume = 255*Pawn(Owner).SoundDampening;	
		SoundPitch = 64;
		AnimSpeed=0.5;
		GoToState('AltFiring');		
	}
	else
	{
		Pawn(Owner).ClientMessage("Need at least 50 ammo");
		Return;
	}
}
function float RateSelf( out int bUseAltMode )
{
	if( Pawn(Owner).Health<Pawn(Owner).Default.Health/3 )
	{
		bUseAltMode = 2;
		return 0;
	}
	bUseAltMode = 0;
	return 2;
}

defaultproperties
{
     LoopNoice=Sound'Ambancient.Looping.achant3'
     FireOffset=(Y=-8.000000,Z=-6.000000)
     ProjectileClass=Class'Pack6.DBolt'
     PickupMessage="You got the Blaster"
     ItemName="Blaster"
     MultiSkins(1)=Texture'UnrealI.Skins.AToxSuit1'
}
