//=============================================================================
// BlueProjectile.
//=============================================================================
class BlueProjectile expands SkaarjProjectile;

auto state Flying
{
	simulated function Timer();
	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
		local vector momentum;
	
		if ( !Other.IsA('GhostStalker') )
		{
			if ( Role == ROLE_Authority )
			{
				momentum = 10000.0 * Normal(Velocity);
				Other.TakeDamage(Damage, instigator, HitLocation, momentum, 'zapped');
			}
			Destroy();
		}
	}

	function MakeSound()
	{
		PlaySound(ImpactSound);
		MakeNoise(1.0);
	}
			
	simulated function Explode(vector HitLocation, vector HitNormal)
	{
		local SpriteExplosion e;

		MakeSound();
		if ( Level.NetMode != NM_DedicatedServer )
		{
			e = spawn(class 'SpriteExplosion',,,HitLocation+HitNormal*9);
			e.RemoteRole = ROLE_None;
			e.Style = STY_Translucent;
		}
		destroy();
	}
}

defaultproperties
{
     Damage=65.000000
     Texture=FireTexture'UnrealShare.Effect1.FireEffect1u'
     DrawScale=1.000000
}
