//=============================================================================
// BounchBall.
//=============================================================================
class BounchBall expands Grenade;

var int HutNum;
simulated function PostBeginPlay()
{
	local vector X,Y,Z;
	local rotator RandRot;

	Super(Projectile).PostBeginPlay();

	if ( Role == ROLE_Authority )
	{
		MaxSpeed = 1000;
		Velocity = VRand()*200;
		bCanHitOwner = False;
	}	
}
simulated function Explosion(vector HitLocation)
{
	local SpriteExplosion s;

	BlowUp(HitLocation);
  	s = spawn(class'SpriteExplosion',,,HitLocation);
	s.RemoteRole = ROLE_None;
	s.Style = STY_Translucent;
 	Destroy();
}
simulated function ProcessTouch( actor Other, vector HitLocation )
{
	local vector momentum;
	
	if ( GhostStalker(Other)==None )
	{
		momentum = 10000.0 * Normal(Velocity);
		Other.TakeDamage(Damage/1.5, instigator, HitLocation, momentum, 'zapped');
		Explosion(HitLocation);
	}
}
simulated function HitWall( vector HitNormal, actor Wall )
{
	bCanHitOwner = True;
	Velocity = (( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
	if( HutNum>1 )
		SetTimer(0.1,false);
	else HutNum++;
	RandSpin(100000);
	speed = VSize(Velocity);
	if ( Level.NetMode != NM_DedicatedServer )
		PlaySound(ImpactSound, SLOT_Misc, FMax(0.5, speed/800) );
	if ( Velocity.Z > 400 )
		Velocity.Z = 0.5 * (400 + Velocity.Z);	
	else if ( speed < 20 ) 
	{
		bBounce = False;
		SetPhysics(PHYS_None);
	}
}
simulated function Tick(float DeltaTime);

defaultproperties
{
     Damage=65.000000
     ImpactSound=Sound'UnrealShare.Skaarj.SkrjImp'
     AnimSequence=None
     DrawType=DT_Sprite
     Style=STY_Translucent
     Texture=FireTexture'UnrealShare.Effect1.FireEffect1u'
     Mesh=None
     DrawScale=3.000000
     CollisionRadius=70.000000
     CollisionHeight=70.000000
}
