//=============================================================================
// Cannons.											All scripts here by me, NOT
//                                          from UT that many cannon makers do!
// RepairedTimes: 0 = Break when health goes to 0
// 1 or more = Go down for to repair
// -1 = Never break
// RepairTime: Amount of time it takes for it to repair
// bTraceHit: if shoot instant hit bullets
// bDrawTraceEffect: if bTraceHit, it shows ASMD likely shots
// TraceHitDamage: Damage per bullet hit
// ShootingMissAmount: How much it can miss the target
//=============================================================================
class Cannons expands Pack6Pawns
	abstract;

var() int RepairedTimes,TraceHitDamage;
var() float RepairTime;
var() bool bTraceHit,bDrawTraceEffect;
var() rotator ShootingMissAmount;
var(sounds) sound ExplodeSound,FireSound,ActivateSound;
var bool bShoot,bReady;
var vector Loc;
var sound theSound;
var float TheThing;

function PreBeginPlay()
{
	bReady = true;
	theSound = AmbientSound;
	AmbientSound=None;
	Super.PreBeginPlay();
}
function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, 
					Vector momentum, name damageType)
{
	if (Health<0 && IsInState('Repair') ) Return;
	MakeNoise(1.0);
	Health -= NDamage;
	if (Health <0)
	{
		PlaySound(ExplodeSound, SLOT_None,5.0);	
		skinnedFrag(class'Fragment1',texture'JCannon1', Momentum,1.0,17);
		if( Default.RepairedTimes!=-1 && RepairedTimes<=0 )
		{
			Spawn(class'RingExplosion2');
			Spawn(class'BallExplosion');
			Destroy();
		}
		RepairedTimes--;
		GoToState('Repair');
		return;
	}
	SetEnemy(instigatedBy);
}
function bool SetEnemy(Pawn NewEnemy)
{
	if( NewEnemy.Health>0 && AttitudeToCreature(NewEnemy)==Attitude_HATE && !IsInState('Repair') )
	{
		Enemy=NewEnemy;
		if( bReady && !IsInState('ActivateCannon') )
			GotoState( 'ActivateCannon');
		Return true;
	}
	return false;
}
function eAttitude AttitudeToCreature(Pawn Other)
{
	if ( Other.Class==Class )
		return ATTITUDE_Friendly;
	else
		return ATTITUDE_Hate;
}
simulated function skinnedFrag(class<fragment> FragType, texture FragSkin, vector Momentum, float DSize, int NumFrags) 
{
	local int i;
	local actor A, Toucher;
	local Fragment s;

	if (Event!='')
		foreach AllActors( class 'Actor', A, Event )
			A.Trigger( Toucher, pawn(Toucher) );
	if ( Region.Zone.bDestructive )
	{
		Destroy();
		return;
	}
	for (i=0 ; i<NumFrags ; i++) 
	{
		s = Spawn( FragType, Owner);
		s.CalcVelocity(Momentum/100,0);
		s.Skin = FragSkin;
		s.DrawScale = DSize*0.5+0.7*DSize*FRand();
	}
}
event HearNoise( float Loudness, Actor NoiseMaker)
{
	if( NoiseMaker.IsA('Pawn') )
		SetEnemy(Pawn(NoiseMaker));
}
event SeePlayer( actor Seen )
{
	if( Seen.IsA('Pawn') )
		SetEnemy(Pawn(Seen));
}
function Trigger( actor Other, pawn EventInstigator )
{
	SetEnemy(EventInstigator);
}
simulated function Tick(float DeltaTime)
{
	if( !IsInState('Repair') && !IsInState('ActivateCannon') && !IsInState('DeActivate') )
		GoToState('DeActivate');
}
function Shoot();
state Repair
{
ignores Trigger,SeePlayer,HearNoise,SetEnemy,TakeDamage;
	simulated function Tick(float DeltaTime)
	{
		TheThing-=DeltaTime;
		if( TheThing<=0 )
		{
			TheThing=0.4;
			Spawn(class'BigBlackSmoke');
		}
	}
	function BeginState()
	{
		AmbientSound = None;
	}
Begin:
	TweenAnim('Activate',3.0);
	PlaySound(ActivateSound, SLOT_None, 2.0);
	if( Default.RepairedTimes!=-1 && RepairedTimes<=0 )
	{
		skinnedFrag(class'Fragment1',texture'JCannon1', vect(0,0,1000),1.0,17);
		Spawn(class'RingExplosion2');
		Spawn(class'BallExplosion');
		Destroy();
	}
	Sleep(RepairTime);
	Health=Default.Health;
	GoToState('Deactivate');
}
function BeginFire();

state ActivateCannon
{
	function Trigger( actor Other, pawn EventInstigator ) {}

	function BeginFire()
	{
		local pawn p;
		local bool bCan;
		bCan=False;
		ForEach VisibleActors(class'pawn',p)
			if( p==Enemy ) bCan=True;
		if( !CanSee(Enemy) || !bCan ) GoToState('Deactivate');
		if (Enemy.Health<=0 || Enemy==None) GoToState('Deactivate');
		if (DesiredRotation.Pitch < -6000 ) TweenAnim('Angle4', 0.25);
		else if (DesiredRotation.Pitch < -4000 ) TweenAnim('Angle3', 0.25);
		else if (DesiredRotation.Pitch < -2000 ) TweenAnim('Angle2', 0.25);
		else if (DesiredRotation.Pitch < -500 ) TweenAnim('Angle1', 0.25);
		else TweenAnim('Angle0', 0.25);		
		bRotateToDesired = True;
		Shoot();
	}
	function EnemyNotVisible()
	{
		GoToState('DeActivate');
	}
	function Shoot()
	{
		local vector HitNormal,HitLocation,EndTrace;
		local Actor a;
		local rotator ShootRot;
		if (DesiredRotation.Pitch < -10000) Return;
		PlaySound(FireSound, SLOT_None,5.0);
		if (DesiredRotation.Pitch < -6000 ) PlayAnim('FAngle4',5.0);
		else if (DesiredRotation.Pitch < -4000 ) PlayAnim('FAngle3',5.0);
		else if (DesiredRotation.Pitch < -2000 ) PlayAnim('FAngle2',5.0);
		else if (DesiredRotation.Pitch < -500 ) PlayAnim('FAngle1',5.0);
		else PlayAnim('FAngle0',5.0);
		Instigator=Self;
		ShootRot = RRRand(DesiredRotation,ShootingMissAmount);
		if( theSound!=None && AmbientSound==None )
			AmbientSound=theSound;
		
		if( !bTraceHit )
			Spawn (RangedProjectile,Self,,Location+Vector(DesiredRotation)*100 - Vect(0,0,1)*60,ShootRot);
		else
		{
			EndTrace = Location + 10000* Vector(ShootRot);
			a = Trace(HitLocation,HitNormal,EndTrace,Location+Vector(DesiredRotation)*100 - Vect(0,0,1)*60, True);
			if( bDrawTraceEffect )
				DrawEffect(HitLocation,HitNormal,Location+Vector(DesiredRotation)*100 - Vect(0,0,1)*60);
			if( a!=None ) a.TakeDamage(TraceHitDamage,Self,HitLocation,HitNormal, 'shot');
			if (a == Level && !bDrawTraceEffect) 
				Spawn(class'LightWallHitEffect',,, HitLocation+HitNormal*9, Rotator(HitNormal));
		}
		if (Enemy.Health<=0 || Enemy==None) GoToState('Deactivate');
	}
	function Killed(pawn Killer, pawn Other, name damageType)
	{
		if( Other==Enemy ) GoToState('DeActivate');
	}
	simulated function Tick(float DeltaTime)
	{
		TheThing-=DeltaTime;
		if( TheThing<=0 )
		{
			TheThing=0.2;
			BeginFire();
		}
	}
Begin:
	Disable('Tick');
	PlayAnim('Activate',0.5);
	PlaySound(ActivateSound, SLOT_None, 2.0);
	FinishAnim();
	BeginFire();
	Enable('Tick');
	RotationRate.Yaw = 60000;
	SetPhysics(PHYS_Rotating);
TryAgain:
	Loc = Enemy.Location;
	Loc.Z+=70;
	TurnTo(Loc);
	ViewRotation = Rotation;
	Sleep(0.1);
	GoTo('TryAgain');
}
auto state DeActivate
{
	simulated function Tick(float DeltaTime)
	{
		TheThing-=DeltaTime;
		if( TheThing<=0 )
		{
			TheThing=2;
			CheckVisibleEnemys();
		}
	}
	function BeginState()
	{
		AmbientSound = None;
	}
Begin:
	bReady = False;
	TweenAnim('Activate',1.0);
	PlaySound(ActivateSound, SLOT_None, 2.0);
	Sleep(1);
	bReady = True;
}

defaultproperties
{
     ExplodeSound=Sound'UnrealI.Cannon.CannonExplode'
     FireSound=Sound'UnrealI.Cannon.CannonShot'
     ActivateSound=Sound'UnrealI.Cannon.CannonActivate'
     RangedProjectile=Class'UnrealI.CannonBolt'
     Physics=PHYS_Rotating
     DrawType=DT_Mesh
     Mesh=LodMesh'UnrealI.CannonM'
     CollisionRadius=44.000000
     CollisionHeight=44.000000
}
