//=============================================================================
// CloakDrink.
//=============================================================================
class CloakDrink expands CoffeCup;

var bool bEnabled,bStarting;

auto state Pickup
{
	function bool ValidTouch( actor Other )
	{
		local Actor A;

		if( Other.bIsPawn && (Pawn(Other).Health > 0) && Level.Game.PickupQuery(Pawn(Other), self) )
		{
			if( Event != '' )
				foreach AllActors( class 'Actor', A, Event )
					A.Trigger( Other, Other.Instigator );
			return true;
		}
		return false;
	}
}
function PickupFunction(Pawn Other)
{
	if( PlayerPawn(Other)==None )
		SetTimer(1,false);
}
function Timer()
{
	Activate();
}
state Activated
{
	function Activate()
	{
		if( bEnabled )
			GoToState('Activated','BackToNormal');
	}
	function Tick(float DeltaTime)
	{
		if( bStarting )
		{
			if( FRand()<0.4 )
			{
				Pawn(Owner).Fatness = Rand(100)+150;
				Pawn(Owner).Texture = Texture'CloakTexture';
				Pawn(Owner).bMeshEnviroMap = True;
				Pawn(Owner).Style = STY_Translucent;
				Pawn(Owner).ScaleGlow = FRand();
				if( Pawn(Owner).Weapon!=None )
				{
					Pawn(Owner).Weapon.Style = STY_Translucent;
					Pawn(Owner).Weapon.Texture = Texture'CloakTexture';
					Pawn(Owner).Weapon.bMeshEnviroMap = True;
					Pawn(Owner).Weapon.ScaleGlow = Pawn(Owner).ScaleGlow;
				}
			}
			else
			{
				Pawn(Owner).Fatness = Pawn(Owner).Default.Fatness;
				Pawn(Owner).bMeshEnviroMap = Pawn(Owner).Default.bMeshEnviroMap;
				Pawn(Owner).Style = Pawn(Owner).Default.Style;
				Pawn(Owner).ScaleGlow = Pawn(Owner).Default.ScaleGlow;
				if( Pawn(Owner).Weapon!=None )
				{
					Pawn(Owner).Weapon.Style = Pawn(Owner).Weapon.Default.Style;
					Pawn(Owner).Weapon.Texture = Pawn(Owner).Weapon.Default.Texture;
					Pawn(Owner).Weapon.bMeshEnviroMap = Pawn(Owner).Weapon.Default.bMeshEnviroMap;
					Pawn(Owner).Weapon.ScaleGlow = Pawn(Owner).Weapon.Default.ScaleGlow;
				}
			}
		}
		else if( bEnabled )
		{
			if( Pawn(Owner).Weapon!=None )
			{
				Pawn(Owner).Weapon.Style = STY_Translucent;
				Pawn(Owner).Weapon.Texture = Texture'CloakTexture';
				Pawn(Owner).Weapon.bMeshEnviroMap = True;
				Pawn(Owner).Weapon.ScaleGlow = Pawn(Owner).ScaleGlow;
			}
			if( Pawn(Owner).Velocity==vect(0,0,0) && Pawn(Owner).ScaleGlow>0.08 )
			{
				Pawn(Owner).ScaleGlow-=DeltaTime/2;
				if( Pawn(Owner).Weapon!=None )
				{
					Pawn(Owner).Weapon.Style = Pawn(Owner).Weapon.Default.Style;
					Pawn(Owner).Weapon.Texture = Pawn(Owner).Weapon.Default.Texture;
					Pawn(Owner).Weapon.bMeshEnviroMap = Pawn(Owner).Weapon.Default.bMeshEnviroMap;
					Pawn(Owner).Weapon.ScaleGlow = Pawn(Owner).Weapon.Default.ScaleGlow;
				}
			}
			else if( Pawn(Owner).Velocity!=vect(0,0,0) && Pawn(Owner).ScaleGlow<0.6 )
				Pawn(Owner).ScaleGlow+=DeltaTime/3;
			Pawn(Owner).Visibility = (Pawn(Owner).ScaleGlow*Pawn(Owner).Default.Visibility)-0.08;
		}
	}
	function BeginState();
	function Timer()
	{
		local Pawn P;
		
		Charge--;
		if( Charge<=0 )
		{
			Pawn(Owner).ClientMessage("Youre out of drink and starting to feel normal again.");
			Activate();
			Return;
		}
		for( P=Level.PawnList; P!=None; P=P.nextPawn )
			if( P.Enemy==Pawn(Owner) || (ScriptedPawn(P)!=None && ScriptedPawn(P).OldEnemy==Pawn(Owner)) || Pawn(Owner).Target==Pawn(Owner))
				P.Killed(None,Pawn(Owner),'');
	}
	Event EndState()
	{
		if( Pawn(Owner)!=None )
		{
			Pawn(Owner).Fatness = Pawn(Owner).Default.Fatness;
			Pawn(Owner).bMeshEnviroMap = Pawn(Owner).Default.bMeshEnviroMap;
			Pawn(Owner).Style = Pawn(Owner).Default.Style;
			Pawn(Owner).ScaleGlow = Pawn(Owner).Default.ScaleGlow;
			Pawn(Owner).Visibility = Pawn(Owner).Default.Visibility;
			Pawn(Owner).Texture = Pawn(Owner).Default.Texture;
			if( Pawn(Owner).Weapon!=None )
			{
				Pawn(Owner).Weapon.Style = Pawn(Owner).Weapon.Default.Style;
				Pawn(Owner).Weapon.Texture = Pawn(Owner).Weapon.Default.Texture;
				Pawn(Owner).Weapon.bMeshEnviroMap = Pawn(Owner).Weapon.Default.bMeshEnviroMap;
				Pawn(Owner).Weapon.ScaleGlow = Pawn(Owner).Weapon.Default.ScaleGlow;
			}
		}
	}
Begin:
	bStarting = True;
	PlaySound(Sound'scaryN4');
	Sleep(3*FRand()+1);
	bStarting = False;
	SetTimer(1,true);
	bEnabled = True;
	Pawn(Owner).Texture = Texture'CloakTexture';
	Pawn(Owner).bMeshEnviroMap = True;
	Pawn(Owner).Style = STY_Translucent;
	Pawn(Owner).ScaleGlow = 0.5;
	Pawn(Owner).Fatness = Pawn(Owner).Default.Fatness;
	Stop;
BackToNormal:
	bEnabled = False;
	SetTimer(0,false);
	PlaySound(Sound'scaryN5');
	bStarting = True;
	Sleep(3*FRand()+1);
	bStarting = False;
	Fatness = Default.Fatness;
	if( Charge<=0 )
		Destroy();
	GoToState('');
}
function Destroyed()
{
	Super(Pickup).Destroyed();
}

defaultproperties
{
     PickupMessage="You found some cloak drink!"
     ItemName="- "
     Charge=60
     Icon=Texture'Pack6.jCloakIcon'
     M_Activated="Drinking some Cloak drink"
     M_Deactivated="Ur out of Cloak-drink"
     Texture=FireTexture'UnrealShare.Belt_fx.Invis.Invis'
     Skin=FireTexture'UnrealShare.Belt_fx.Invis.Invis'
     MultiSkins(0)=Texture'UnrealShare.Belt_fx.ShieldBelt.newgold'
     MultiSkins(1)=Texture'UnrealShare.Belt_fx.ShieldBelt.newred'
     MultiSkins(2)=FireTexture'UnrealShare.Belt_fx.Invis.Invis'
}
