//=============================================================================
// CoffeCup.
// Special thanks to Tentacle-Hunter for the idea!
//=============================================================================
class CoffeCup expands Pickup;

var bool bWasActivated;

auto state Pickup
{
	function bool ValidTouch( actor Other )
	{
		local Actor A;

		if( Other.bIsPawn && (Pawn(Other).Health > 0) && Level.Game.PickupQuery(Pawn(Other), self) )
		{
			if( Event != '' )
				foreach AllActors( class 'Actor', A, Event )
					A.Trigger( Other, Other.Instigator );
			return true;
		}
		return false;
	}
}
function PickupFunction(Pawn Other)
{
	if( PlayerPawn(Other)==None )
		SetTimer(1,false);
}
function Timer()
{
	Activate();
}
state Activated
{
	function Activate()
	{
		Pawn(Owner).ClientMessage("Your having too good feeling with coffee and cant stop drinking it.");
	}
	function BeginState()
	{
		Pawn(Owner).GroundSpeed *= 3;
		Pawn(Owner).JumpZ *= 3;
		Pawn(Owner).AirSpeed *= 3;
		Pawn(Owner).AccelRate *= 3;
		SetTimer(1,true);
		bWasActivated = True;
	}
	function Timer()
	{
		Charge--;
		if( Charge<=0 )
		{
			Pawn(Owner).ClientMessage("Youre out of coffee and feeling normal again.");
			Destroy();
			Return;
		}
		Spawn(class'SpriteSmokePuff',,,Owner.Location+VRand()*Owner.CollisionHeight);
	}
}
function Destroyed()
{
	if( Owner!=None && Pawn(Owner)!=None && !Owner.bDeleteMe && bWasActivated )
	{
		Pawn(Owner).GroundSpeed /= 3;
		Pawn(Owner).JumpZ /= 3;
		Pawn(Owner).AirSpeed /= 3;
		Pawn(Owner).AccelRate /= 3;
	}
	Super.Destroyed();
}

defaultproperties
{
     bActivatable=True
     bDisplayableInv=True
     bRotatingPickup=True
     PickupMessage="Take a sirp with cup of coffee"
     RespawnTime=25.000000
     PickupViewMesh=Mesh'Pack6.CoffeMesh'
     Charge=20
     PickupSound=Sound'UnrealShare.Generic.LavaEx'
     ActivateSound=Sound'UnrealShare.Generic.LavaEn'
     Icon=Texture'Pack6.CofIcon'
     M_Activated="Dinking some coffee..."
     M_Selected="Drink it!"
     M_Deactivated="Ur out of coffee."
     Texture=Texture'UWindow.Icons.Background'
     Skin=Texture'UWindow.Icons.Background'
     Mesh=Mesh'Pack6.CoffeMesh'
     MultiSkins(0)=Texture'UWindow.WhiteTexture'
     MultiSkins(1)=Texture'UWindow.BlackTexture'
     MultiSkins(2)=Texture'UWindow.Icons.Background'
     CollisionRadius=18.600000
     CollisionHeight=11.400000
}
