//=============================================================================
// CoopBot.
//=============================================================================
class CoopBot expands HumanPawn;

var vector MoveVect,OldVect;
var float Count,Count2,IdleTime;
var class<Inventory> LastTriedClass;
var() string AName[10],FName[10];
var() sound JumpSound;
var BotNode LastPoint[9],SearchingPoint;
var int CurrentNr,NrTimes;
var Actor NodeSpot,TempMove,OldNode;
var Pawn ToFollow;
var int DaOrder;
var bool bFemale;

function PreBeginPlay()
{
	local float Dec;
	
	Dec = FRand();
	if( FRand()<=0.5 )
	{
		if( Dec<0.3 )
			Mesh = LodMesh'Male1';
		else if( Dec<0.6 )
			Mesh = LodMesh'Male3';
	}
	else
	{
		if( Dec<0.5 )
			Mesh = LodMesh'Female1';
		else
			Mesh = LodMesh'Female2';
		Die = Sound'UnrealShare.Female.death1dfem';
		Die2 = Sound'UnrealShare.Female.death3cfem';
		Die3 = Sound'UnrealShare.Female.death2afem';
		Die4 = Sound'UnrealShare.Female.death4cfem';
		HitSound1 = Sound'UnrealShare.Female.linjur1fem';
		HitSound2 = Sound'UnrealShare.Female.linjur2fem';
		JumpSound = Sound'UnrealShare.Female.jump1fem';
		bFemale = True;
	}
	Super.PreBeginPlay();
}
auto state Startup
{
	function BeginState()
	{
		Super.BeginState();
		Level.Game.AddDefaultInventory(Self);
		if( FRand()<0.3 )
			SayAMessage("Hello everybody");
		else if( FRand()<0.3 )
			SayAMessage("Hi");
		else SayAMessage("Hi :)");
	}
}
function InitPlayerReplicationInfo()
{
	if( bFemale ) PlayerReplicationInfo.PlayerName = FName[Rand(10)];
	else PlayerReplicationInfo.PlayerName = AName[Rand(10)];
	PlayerReplicationInfo.bIsFemale = True;
	PlayerReplicationInfo.bIsABot = True;
	PlayerReplicationInfo.PlayerID = level.game.CurrentID++;
	MenuName = PlayerReplicationInfo.PlayerName;
	NameArticle = "";
}
function SayAMessage(string MSG)
{
	local Pawn P;
	
	if ( Level.Game.AllowsBroadcast(self, Len(MSG)) )
		for( P=Level.PawnList; P!=None; P=P.nextPawn )
			if( P.bIsPlayer )
				P.TeamMessage( PlayerReplicationInfo,MSG, 'Say' );
}
function TeamMessage( PlayerReplicationInfo PRI, coerce string S, name Type )
{
	if( Health>0 && PRI.Owner!=Self && LineOfSightTo(PRI.Owner) )
	{
		if( S~="Follow" || S~="Follow me" || S~="Followme" )
		{
			SayAMessage("I follow you,"@PRI.PlayerName);
			DaOrder=1;
			ToFollow = Pawn(PRI.Owner);
			WhatToDoNext('','');
		}
		else if( S~="Attack" || S~="normal" || S~="be normal" )
		{
			SayAMessage("Ok! I'll be normal!");
			DaOrder=0;
			ToFollow = None;
			WhatToDoNext('','');
		}
		else if( S~="Guard" )
		{
			SayAMessage("Ok! I'll stay in this area!");
			DaOrder=2;
			ToFollow = None;
			WhatToDoNext('','');
		}
	}
}
function ChangedWeapon()
{
	Super(ScriptedPawn).ChangedWeapon();
	bMovingRangedAttack = true;
	bHasRangedAttack = true;
	Weapon.AimError = 0;
	Weapon.SetHand(0);
}
function TossWeapon()
{
	if ( Weapon == None )
		return;
	Weapon.FireOffset = Weapon.Default.FireOffset;
	Weapon.PlayerViewOffset = Weapon.Default.PlayerViewOffset; 
	Super(ScriptedPawn).TossWeapon();
}
function Died(pawn Killer, name damageType, vector HitLocation)
{
	local Pawn aPawn;
	local int i;

	aPawn = Level.PawnList;
	while ( aPawn != None )
	{
		if ( aPawn.IsA('HumanPawn') && aPawn.Class == Class )
			if ( HumanPawn(aPawn).SetEnemy(Killer) )
				aPawn.GotoState('Attacking');
		aPawn = aPawn.nextPawn;
	}
	for (i = 0; i< 9; i++)
		if( LastPoint[i]!=None )
			LastPoint[i]=None; // Forget all last points
	Super(ScriptedPawn).Died(Killer,damageType,HitLocation);
	SayAMessage("I died :(");
}
state Guarding
{
	Event BeginState()
	{
		WhatToDoNext('','');
	}
}
state Wandering
{
	Event BeginState()
	{
		WhatToDoNext('','');
	}
}
state Waiting
{
	Event BeginState()
	{
		WhatToDoNext('','');
	}
}
state Dying
{
ignores SeePlayer, EnemyNotVisible, HearNoise, Died, Bump, Trigger, HitWall, HeadZoneChange, FootZoneChange, ZoneChange, Falling, WarnTarget, LongFall, SetFall, PainTimer;

	function ReStartPlayer()
	{
		if( bHidden && Level.Game.RestartPlayer(self) )
		{
			Velocity = vect(0,0,0);
			Acceleration = vect(0,0,0);
			ViewRotation = Rotation;
			SetPhysics(PHYS_Falling);
			GotoState('Roaming');
		}
		else
			GotoState('Dying', 'TryAgain');
	}
	
	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
							Vector momentum, name damageType)
	{
		if ( !bHidden )
			Super.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);
	}
	
	function BeginState()
	{
		SetTimer(0, false);
		Enemy = None;
		bFire = 0;
		bAltFire = 0;
	}

	function EndState()
	{
		if ( Health <= 0 )
			log(self$" health still <0");
	}

Begin:
	Sleep(0.2);
	if ( !bHidden )
	{
		SpawnCarcass();
		HidePlayer();
	}
TryAgain:
	Sleep(0.25);
	ReStartPlayer();
	Goto('TryAgain');
WaitingForStart:
	bHidden = true;
}
function bool SetEnemy( Pawn NewEnemy )
{
	local Pawn P;
	
	if( NewEnemy==None || NewEnemy.IsA('PlayerPawn') || NewEnemy.IsA('CoopBot') || NewEnemy.IsA('GoodBoy')
	 || NewEnemy.IsA('Boy') ) Return false;
	else if( !NewEnemy.IsA('FlockMasterPawn') && NewEnemy.bCollideActors && !NewEnemy.IsA('Bird1') && !NewEnemy.IsA('NaliRabbit') && NewEnemy.Health>0 )
	{
		Enemy = NewEnemy;
		if( DaOrder==0 )
		{
			For( P=Level.PawnList; P!=None; P=P.NextPawn )
			{
				if( P.IsA('CoopBot') && CoopBot(P).DaOrder==0 && VSize(P.Location-Location)<2000 && LineOfSightTo(P) && P.Health>0 &&
				 (P.Enemy==None || P.Enemy!=NewEnemy) )
				{
					SayAMessage("Follow me");
					Break;
				}
			}
		}
		GoToState('Attacking');
		Return True;
	}
	Return False;
}
function WhatToDoNext(name LikelyState, name LikelyLabel)
{
	if( DaOrder==1 )
		GotoState('IdleMoving','Following');
	else if( DaOrder==2 )
		GotoState('IdleMoving','Guard');
	else GotoState('IdleMoving','Begin');
}
simulated function Tick(float DeltaTime)
{
	ViewRotation = DesiredRotation;
	if( Health<=0 && !IsInState('Dying') )
		GoToState('Dying');
	if( !bIsPlayer )
		bIsPlayer=True;
}
State NoMoving
{
	function DoJump();
Begin:
	PlayWaiting();
	Sleep(IdleTime);
	WhatToDoNext('','');
}
	
State IdleMoving
{
	function Tick(float DeltaTime)
	{
		local Inventory I,inv2;
		local bool bHave;
		local int ii;
		local BotNode B;
		Count += DeltaTime;
		Count2 += DeltaTime*FRand();
		if( Count>=1 )
		{
			if( DaOrder==0 )
			{
				ForEach VisibleActors(class'BotNode',B,10000)
				{
					bHave=False;
					for (ii = 0; ii< 9; ii++)
					{
						if( LastPoint[ii]!=None && LastPoint[ii]==B )
							bHave=True;
					}
					if( !bHave )
					{
						MoveVect = B.Location;
						GoToState('IdleMoving','DoMove');
						if( VSize(B.Location - Location) < 70 )
							AddPointToLast(B);
						Break;
					}
				}
			}
			CheckVisibleEnemys();
			ForEach VisibleActors(class'Inventory',I,300)
			{
				bHave = False;
				if( I.IsInState('Pickup') && I.Class!=LastTriedClass )
				{
					for( Inv2=Inventory; Inv2!=None; Inv2=Inv2.Inventory ) 
						if( Inv2.Class==I.Class )
							bHave = True;
					if( !bHave && FRand()<0.2 )
					{
						MoveVect = I.Location;
						LastTriedClass = I.Class;
						GoToState('IdleMoving','DoMove');
					}
				}
			}
			for( Inv2=Inventory; Inv2!=None; Inv2=Inv2.Inventory ) 
				if( Inv2.IsA('Pickup') && !Inv2.IsInState('Activated') )
					Inv2.Activate();
			Count = 0;
			SwitchNewWeapon();
		}
		if( Count2>1.5 && FRand()<0.5 )
		{
			DoJump();
			Count2=0;
		}
		else if( Count2>1.5 )
			Count2=0;
		ViewRotation = DesiredRotation;
	}
	function FindDestination()
	{
		local Actor A;
		local int i,ii;
		
		if( DaOrder!=0 ) Return;
		ForEach AllActors(class'Actor',A)
		{
			if( A.IsA('ScriptedPawn') && !A.IsA('CoopBot') && !A.IsA('GoodBoy') )
			{
				if( FindPathToward(A)!=None )
				{
					MoveVect = A.Location;
					GoToState('IdleMoving','FindPath');
					Return;
				}
				i++;
			}
			else if( A.IsA('Inventory') && A.IsInState('Pickup') )
				i++;
		}
		i = Rand(i+1);
		ForEach AllActors(class'Actor',A)
		{
			if( A.IsA('ScriptedPawn') && !A.IsA('CoopBot') && !A.IsA('GoodBoy') )
			{
				if( i==ii )
				{
					MoveVect = A.Location;
					GoToState('IdleMoving','FindPath');
					Return;
				}
				ii++;
			}
			else if( A.IsA('Inventory') && A.IsInState('Pickup') )
			{
				if( i==ii )
				{
					MoveVect = A.Location;
					GoToState('IdleMoving','FindPath');
					Return;
				}
				ii++;
			}
		}
		NrTimes=2;
	}
	function AddPointToLast( BotNode BN )
	{
		if( LastPoint[0]!=BN )
		{
			LastPoint[8]=LastPoint[7];
			LastPoint[7]=LastPoint[6];
			LastPoint[6]=LastPoint[5];
			LastPoint[5]=LastPoint[4];
			LastPoint[4]=LastPoint[3];
			LastPoint[3]=LastPoint[2];
			LastPoint[2]=LastPoint[1];
			LastPoint[1]=LastPoint[0];
			LastPoint[0]=BN;
		}
	}
Begin:
	PlayRunning();
FindASpot:
	MoveVect = Location;
	MoveVect.Y += (Rand(100)-50)*1000;
	MoveVect.X += (Rand(100)-50)*1000;
	MoveVect.Z += (Rand(100)-50)*100;
	if( NrTimes<=0 )
		FindDestination();
	else NrTimes--;
DoMove:
	PlayRunning();
	if( SearchingPoint!=None )
		MoveTo(SearchingPoint.Location,Groundspeed);
	else MoveTo(MoveVect,Groundspeed);
	Sleep(0.01);
	WhatToDoNext('','');
FindPath:
	PlayRunning();
	if( PointReachable(MoveVect) )
	{
		MoveTo(MoveVect,GroundSpeed);
		Acceleration = vect(0,0,0); //stop
		PlayWaiting();
		Sleep(0.6);
		WhatToDoNext('','');
	}
	OldNode = NodeSpot;
	NodeSpot = FindPathTo(MoveVect);
	if( NodeSpot==None )
	{
		NrTimes=2;
		MoveTo(MoveVect,GroundSpeed);
		Acceleration = vect(0,0,0); //stop
		PlayWaiting();
		Sleep(1);
		if( DaOrder==1 && !LineOfSightTo(ToFollow) )
		{
			if( FRand()<0.3 )
				SayAMessage("Arrgh, I can't find"@ToFollow.GetHumanName());
			else if( FRand()<0.5 )
				SayAMessage("Hey"@ToFollow.GetHumanName()$", if you dont show up in 5 seconds I'll leave you!");
			else SayAMessage("Help"@ToFollow.GetHumanName()$", where are you?");
			Sleep(5);
			if( !LineOfSightTo(ToFollow) )
			{
				if( FRand()<0.3 )
					SayAMessage("I'm sorry, but I'll have to leave you now!");
				else if( FRand()<0.5 )
					SayAMessage("Hey"@ToFollow.GetHumanName()$", since I can't find you, I'll have to leave you now.");
				else SayAMessage("I leave you for self now,"@ToFollow.GetHumanName());
				ToFollow = None;
				DaOrder = 0;
			}
			else
			{
				if( FRand()<0.3 )
					SayAMessage("Ah, there you are"@ToFollow.GetHumanName());
				else if( FRand()<0.5 )
					SayAMessage("Hey, there you are"@ToFollow.GetHumanName());
				else SayAMessage("There you are"@ToFollow.GetHumanName());
			}
		}
		WhatToDoNext('','');
	}
	if( OldNode!=None && OldNode.IsA('LiftExit') && NodeSpot.IsA('LiftCenter') &&
	 LiftExit(OldNode).LiftTag==LiftCenter(NodeSpot).LiftTag)
	{
ReCheck:
		if( Location.Z>(NodeSpot.Location.Z-LiftCenter(NodeSpot).MaxZDiffAdd-40) &&
		 Location.Z<(NodeSpot.Location.Z+LiftCenter(NodeSpot).MaxZDiffAdd+40) )
			GoTo 'Skip';
		else
		{
			Acceleration = vect(0,0,0);
			PlayWaiting();
			Sleep(1);
			GoTo 'ReCheck';
		}
	}
Skip:
	MoveToward(NodeSpot,GroundSpeed);
	if( OldVect==NodeSpot.Location ) Sleep(0.5);
	OldVect=NodeSpot.Location;
	NrTimes = 0;
	GoTo 'FindPath';
Following:
	if( ToFollow==None || ToFollow.Class==None || ToFollow.bDeleteMe || ToFollow.Health<=0 )
	{
		if( ToFollow!=None && ToFollow.Class!=None && !ToFollow.bDeleteMe )
			SayAMessage(ToFollow.GetHumanName()$", I failed you :(");
		ToFollow = None;
		DaOrder = 0;
		WhatToDoNext('','');
	}
	if( actorReachable(ToFollow) )
	{
		PlayRunning();
		MoveVect = VRand()*100+ToFollow.Location;
		MoveTo(MoveVect,GroundSpeed);
		Acceleration = vect(0,0,0); //stop
		PlayWaiting();
		Sleep(2);
		GoTo 'Following';
	}
	else
	{
		MoveVect = ToFollow.Location;
		GoTo 'FindPath';
	}
Guard:
	Acceleration = vect(0,0,0); //stop
	PlayWaiting();
	Sleep(2);
	GoTo 'Guard';
}
function SwitchNewWeapon()
{
	if( FRand()<0.2 )
		SwitchWeapon(Rand(11));
}
function DoJump()
{
	if ( Physics == PHYS_Walking )
	{
		if ( Role == ROLE_Authority )
			PlaySound(JumpSound, SLOT_Talk, 1.5, true, 1200, 1.0 );
		if ( (Level.Game != None) && (Level.Game.Difficulty > 0) )
			MakeNoise(0.1 * Level.Game.Difficulty);
		PlayInAir();
		if ( bCountJumps && (Role == ROLE_Authority) )
			Inventory.OwnerJumped();
		Velocity.Z = JumpZ;
		if ( Base != Level )
			Velocity.Z += Base.Velocity.Z; 
		SetPhysics(PHYS_Falling);
	}
}
function SwitchWeapon (byte F )
{
	local weapon newWeapon;

	if ( Inventory == None )
		return;
	if ( (Weapon != None) && (Weapon.Inventory != None) )
		newWeapon = Weapon.Inventory.WeaponChange(F);
	else
		newWeapon = None;	
	if ( newWeapon == None )
		newWeapon = Inventory.WeaponChange(F);
	if ( newWeapon == None )
		return;

	if ( Weapon == None )
	{
		PendingWeapon = newWeapon;
		ChangedWeapon();
	}
	else if ( (Weapon != newWeapon) && Weapon.PutDown() )
		PendingWeapon = newWeapon;
}
function PlayVictoryDance()
{
	if( FRand()<0.5 )
		SayAMessage("Yeah, I killed a enemy");
	else SayAMessage("Yay, I got one!");
	Super.PlayVictoryDance();
}
state Roaming
{
	function BeginState()
	{
		SpecialGoal = None;
		bSpecialGoal = false;
		SpecialPause = 0.0;
		Enemy = None;
		SetAlertness(0.2);
		bReadyToAttack = false;
		WhatToDoNext('','');
	}
}
state StakeOut
{
ignores EnemyNotVisible; 
		
	function BeginState()
	{
		Acceleration = vect(0,0,0);
		bCanJump = true;
		bClearShot = true;
		bReadyToAttack = true;
		SetAlertness(0.5);
	}

Begin:
	Acceleration = vect(0,0,0);
	PlayChallenge();
	TurnTo(LastSeenPos);
	if ( bHasRangedAttack && bClearShot && (FRand() < 0.5) && (VSize(Enemy.Location - LastSeenPos) < 150) && CanStakeOut() )
		PlayRangedAttack();
	FinishAnim();
Nodeing:
	if( pointReachable(LastSeenPos) )
	{
		PlayRunning();
		MoveTo(LastSeenPos,GroundSpeed);
	}
	else
	{
		NodeSpot = FindPathTo(LastSeenPos);
		PlayRunning();
		if( NodeSpot==None )
		{
			MoveTo(LastSeenPos,GroundSpeed);
			Acceleration = vect(0,0,0);
			PlayChallenge();
			FinishAnim();
			GoToState('Attacking');
		}
		else
		{
			MoveToward(NodeSpot,GroundSpeed);
			Acceleration = vect(0,0,0);
			PlayWaiting();
			Sleep(0.5);
			GoTo 'Nodeing';
		}
	}
}
function damageAttitudeTo(pawn Other)
{
	if( Enemy!=Other && OldEnemy!=Other )
		SetEnemy(Other);
}

defaultproperties
{
     AName(0)="Dante"
     AName(1)="Ash"
     AName(2)="Kurgan"
     AName(3)="Avatar"
     AName(4)="Dominator"
     AName(5)="Cholerae"
     AName(6)="Bane"
     AName(7)="Eradicator"
     AName(8)="Arcturus"
     AName(9)="Vindicator"
     FName(0)="Sonja"
     FName(1)="Rhiannon"
     FName(2)="Apocalypse"
     FName(3)="Hippolyta"
     FName(4)="Nikita"
     FName(5)="Shiva"
     FName(6)="Raquel"
     FName(7)="Gina"
     FName(8)="Tamaika"
     FName(9)="Drace"
     JumpSound=Sound'UnrealShare.Male.MJump1'
     TimeBetweenAttacks=0.010000
     RefireRate=0.010000
     Fear=None
     Threaten=None
     bIsPlayer=True
     MeleeRange=-1.000000
     BaseEyeHeight=23.000000
     Skin=None
}
