//=============================================================================
// Cracker.
//=============================================================================
class Cracker expands Pack6Weps;


var() sound IdleSounds[5];
var float Decesion;

function TweenSelect()
{
	TweenAnim('LeglessDeath',0.001);
}
function TweenDown()
{
	PlayAnim('LegLoss', 1.0, 0.05);
}
function PlaySelect()
{
	PlayAnim('Breath',1.0,1.0);
	Owner.PlaySound(SelectSound, SLOT_Misc, Pawn(Owner).SoundDampening);	
}
state Idle
{
Begin:
	bPointing=False;
	if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0) ) 
		Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
	if ( Pawn(Owner).bFire!=0 ) Fire(0.0);
	if ( Pawn(Owner).bAltFire!=0 ) AltFire(0.0);	
	Disable('AnimEnd');
	Decesion = FRand();
	if( Decesion<0.2 )
	{
		Owner.PlaySound(IdleSounds[0], SLOT_None,2.0*Pawn(Owner).SoundDampening);
		PlayAnim('Hit');
	}
	else if( Decesion<0.4 )
	{
		Owner.PlaySound(IdleSounds[1], SLOT_None,2.0*Pawn(Owner).SoundDampening);
		PlayAnim('Look');
	}
	else if( Decesion<0.6 )
	{
		Owner.PlaySound(IdleSounds[2], SLOT_None,2.0*Pawn(Owner).SoundDampening);
		LoopAnim('Run');
		Sleep(1);
		PlayAnim('Throw');
	}
	else
	{
		Owner.PlaySound(IdleSounds[3], SLOT_None,2.0*Pawn(Owner).SoundDampening);
		PlayAnim('Twirl');
		FinishAnim();
	}
	FinishAnim();
	GoTo('Begin');
}
function Fire( float Value )
{
	if (AmmoType.UseAmmo(1))
	{
		GotoState('NormalFire');
		if ( PlayerPawn(Owner) != None )
			PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
		bPointing=True;
		if ( Owner.bHidden )
			CheckVisibility();
	}
	else
		Pawn(Owner).ClientMessage("You didn't have any more ammo :(");
}

function AltFire( float Value )
{
	if (AmmoType.UseAmmo(1))
	{
		GotoState('AltFiring');
		if ( PlayerPawn(Owner) != None )
			PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
		bPointing=True;
		if ( Owner.bHidden )
			CheckVisibility();
	}
	else
		Pawn(Owner).ClientMessage("You didn't have any more ammo :(");
}
function SpawnShot();
///////////////////////////////////////////////////////
state NormalFire
{
	function SpawnShot()
	{
		DoProjectileFire(AltProjectileClass,1300,true,0);
	}
Begin:
	FinishAnim();
	PlayAnim('Shoot1',2);
	FinishAnim();
	Finish();
}

////////////////////////////////////////////////////////
state AltFiring
{
	function SpawnShot()
	{
		local int i;
		
		DoProjectileFire(ProjectileClass,1000,true,0);
		for (i = 0; i< 4; i++)
		{
			if (AmmoType.UseAmmo(1))
				DoProjectileFire(ProjectileClass,1000,true,3000);
			else
				Pawn(Owner).ClientMessage("You didn't have any more ammo :(");
		}
	}
Begin:
	FinishAnim();
	PlayAnim('Shoot2',0.8);
	FinishAnim();
	Finish();
}
function DoProjectileFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn, float missing)
{
	local Vector Start, X,Y,Z;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);
	Owner.MakeNoise(PawnOwner.SoundDampening);
	GetAxes(PawnOwner.ViewRotation,X,Y,Z);
	Start = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = PawnOwner.AdjustAim(ProjSpeed, Start, missing, True, bWarn);
	AdjustedAim.Roll+=Rand(missing)-missing/2;
	AdjustedAim.Yaw+=Rand(missing)-missing/2;
	AdjustedAim.Pitch+=Rand(missing)-missing/2;
	Spawn(ProjClass,,, Start,AdjustedAim);	
}

defaultproperties
{
     IdleSounds(0)=Sound'UnrealI.Krall.syl4kr'
     IdleSounds(1)=Sound'UnrealI.Krall.syl3kr'
     IdleSounds(2)=Sound'UnrealI.Krall.staflp4k'
     IdleSounds(3)=Sound'UnrealI.Krall.syl5kr'
     AmmoName=Class'UnrealI.RazorAmmo'
     PickupAmmoCount=70
     FireOffset=(X=12.000000,Y=-10.000000,Z=-15.000000)
     ProjectileClass=Class'Pack6.CrackerBlade'
     AltProjectileClass=Class'Pack6.CrackerBlade'
     FireSound=Sound'UnrealI.Krall.Krasht2'
     AltFireSound=Sound'UnrealI.Krall.throw1k'
     DeathMessage="%o was turned into a pice of shit by %k's %w."
     AutoSwitchPriority=7
     InventoryGroup=7
     PickupMessage="You got the Cracker Krall"
     ItemName="Cracker Krall"
     PlayerViewOffset=(X=4.200000,Y=-3.000000,Z=-3.000000)
     PlayerViewMesh=LodMesh'UnrealI.KrallM'
     PlayerViewScale=0.020000
     PickupViewMesh=LodMesh'UnrealI.KrallM'
     PickupViewScale=0.200000
     ThirdPersonMesh=LodMesh'UnrealI.KrallM'
     ThirdPersonScale=0.200000
     PickupSound=Sound'UnrealI.Krall.chlng1k'
     Mesh=LodMesh'UnrealI.KrallM'
     DrawScale=0.200000
}
