//=============================================================================
// DeadlyMan.
//=============================================================================
class DeadlyMan expands HumanPawn;

var bool bFirstDeath;
var EsFireball TempObj;

function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
{
	local int actualDamage;

	if (Physics == PHYS_None)
		SetMovementPhysics();
	if (Physics == PHYS_Walking)
		momentum.Z = FMax(momentum.Z, 0.4 * VSize(momentum));
	if ( instigatedBy == self )
		momentum *= 0.6;
	momentum = momentum/Mass;
	AddVelocity( momentum ); 

	actualDamage = Level.Game.ReduceDamage(Damage, DamageType, self, instigatedBy);

	if (Inventory != None) //then check if carrying armor
			actualDamage = Inventory.ReduceDamage(actualDamage, DamageType, HitLocation);
	if ( (InstigatedBy != None) &&
				(InstigatedBy.IsA(Class.Name) || self.IsA(InstigatedBy.Class.Name)) )
		ActualDamage = ActualDamage * FMin(1 - ReducedDamagePct, 0.35); 
	else if ( (ReducedDamageType == 'All') || 
		((ReducedDamageType != '') && (ReducedDamageType == damageType)) )
		actualDamage = float(actualDamage) * (1 - ReducedDamagePct);
	
	Health -= actualDamage;
	if (CarriedDecoration != None)
		DropDecoration();
	if ( HitLocation == vect(0,0,0) )
		HitLocation = Location;
	if (Health > 0)
	{
		if (instigatedBy != None)
			damageAttitudeTo(instigatedBy);
		PlayHit(actualDamage, hitLocation, damageType, Momentum.Z);
		Enemy = instigatedBy;
		MakeNoise(1.0);
		Return;
	}
	NextState = '';
	PlayDeathHit(actualDamage, hitLocation, damageType);
	if ( actualDamage > mass )
		Health = -1 * actualDamage;
	Enemy = instigatedBy;
	Died(instigatedBy, damageType, HitLocation);
	MakeNoise(1.0); 
}
function Died(pawn Killer, name damageType, vector HitLocation)
{
	local pawn OtherPawn;
	local actor A;

	if ( bDeleteMe )
		return; //already destroyed
	for ( OtherPawn=Level.PawnList; OtherPawn!=None; OtherPawn=OtherPawn.nextPawn )
	{
		OtherPawn.Killed(Killer, self, damageType);
		if ( OtherPawn.IsA('HumanPawn') && OtherPawn.Class == Class )
			if ( HumanPawn(OtherPawn).SetEnemy(Killer) )
				OtherPawn.GotoState('Attacking');
	}
	if ( CarriedDecoration != None )
		DropDecoration();
	//log(class$" dying");
	if( Event != '' && !bFirstDeath )
		foreach AllActors( class 'Actor', A, Event )
			A.Trigger( Self, Killer );
	bFirstDeath = True;
	Velocity.Z *= 1.3;
	PlayDying(DamageType, HitLocation);
	if ( Level.Game.bGameEnded )
		return;
	if ( RemoteRole == ROLE_AutonomousProxy )
		ClientDying(DamageType, HitLocation);
	GotoState('Dying');
}
function ActualDeath( pawn Killer, name damageType )
{
	level.game.Killed(Killer, self, damageType);
	Level.Game.DiscardInventory(self);
	Spawn(class'SpriteBallExplosion');
	SpawnGibbedCarcass();
	Destroy();
}
State Dying
{
ignores SeePlayer, EnemyNotVisible, HearNoise, KilledBy, Trigger, Bump, HitWall, 
HeadZoneChange, FootZoneChange, ZoneChange, Falling, WarnTarget, Died, LongFall, 
PainTimer,BeginState,Timer;

	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
							Vector momentum, name damageType)
	{
		if( damageType!='Burned' )
			Global.TakeDamage(0,instigatedBy,hitlocation,momentum,damageType);
		else ActualDeath(instigatedBy,damageType);
	}

	event Landed(vector HitNormal)
	{
		SetPhysics(PHYS_None);
	}
	Event EndState()
	{
		if( TempObj!=None && !TempObj.bDeleteMe && TempObj.IsInState('Pickup') )
		{
			Spawn(class'SpriteExplosion',,,TempObj.Location).Style = STY_Translucent;
			TempObj.Destroy();
		}
		TempObj = None;
	}
Begin:
	TempObj = Spawn(class'EsFireball');
	TempObj.RespawnTime = 0;
	Sleep(10);
	Health = Default.Health;
	TweenAnim('Breath2',2);
	Velocity.Z = JumpZ;
	SetPhysics(PHYS_Falling);
	PlayInAir();
	GoToState('Wandering');
}
function Destroyed()
{
	if( TempObj!=None && !TempObj.bDeleteMe && TempObj.IsInState('Pickup') )
	{
		Spawn(class'SpriteExplosion',,,TempObj.Location).Style = STY_Translucent;
		TempObj.Destroy();
	}
	TempObj = None;
	Super.Destroyed();
}

defaultproperties
{
     hitdamage=204
     TimeBetweenAttacks=0.100000
     RefireRate=0.100000
     RangedProjectile=Class'Pack6.BloodSlime'
     ProjectileSpeed=1200.000000
     Health=200
     CombatStyle=10.300000
     Skin=Texture'UnrealShare.Skins.Jmta2'
     Mesh=LodMesh'UnrealShare.Male3'
}
