//=============================================================================
// DeathEye.
//=============================================================================
class DeathEye expands GhostStalker;

var bool GotYa;

Auto state Idle
{
Ignores Tick;

	function BeginState()
	{
		bCanFly = True;
		bCanSwim = True;
		SetPhysics(PHYS_Flying);
	}
	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
	{
		if( instigatedBy!=None && instigatedBy.Health>0 && GhostStalker(instigatedBy)==None )
		{
			Spawn(class'ParticleBurst');
			SetLocation(VRand()*1000+instigatedBy.Location);
			bHidden = True;
			SetEnemy(instigatedBy);
		}
		else
			if( SetLocation(VRand()*2000+Location) )
				Spawn(class'ParticleBurst');
	}
Begin:
	GotYa = False;
	SetCollision(true,false,false);
	bMeshEnviroMap = True;
	Style = STY_Translucent;
	bHidden = false;
	ScaleGlow = 0.3;
BeingIdle:
	MoveV = VRand()*1000+Location;
	MoveTo(MoveV,AirSpeed);
	CheckVisibleEnemys();
	Sleep(1);
	GoTo('BeingIdle');
}

State AttackStatics
{
	function Tick( float DeltaTime )
	{
		if( Enemy==None || Enemy.Class==None || Enemy.bDeleteMe || Enemy.Health<=0 )
		{
			Enemy = None;
			GoToState('Idle');
		}
		if( ScaleGlow<2 )
			ScaleGlow+=DeltaTime/3;
		else if( Style!=STY_Normal )
			Style=STY_Normal;
		if( GotYa )
			Enemy.ClientSetRotation(rotator(Location-Enemy.Location));
	}
	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
	{
		if( Style==STY_Normal )
			Global.TakeDamage(Damage,instigatedBy,hitlocation,momentum,damageType);
	}
	function BeginState()
	{
		SetPhysics(PHYS_Flying);
		ScaleGlow = 0;
		SetCollision(true,false,false);
		bMeshEnviroMap = False;
		Style = STY_Translucent;
		bHidden = false;
		SetTimer(1,true);
	}
	function EnemyNotVisible()
	{
		Enemy = None;
		GoToState('Idle');
	}
	function Timer()
	{
		local RingExplosion4 R;
		
		if( Enemy==None || Enemy.Health<=0 || Enemy.bDeleteMe )
		{
			Enemy=None;
			GoToState('Idle');
		}
		if( CheckIfEnemyCanSee(Enemy) )
		{
			GotYa = True;
			DrawEffect(Location,Normal(Enemy.Location-Location),Enemy.Location);
			Enemy.TakeDamage(30,Self,location,vect(0,0,0),'hacked');
			PlaySound(Sound'PSbelta2',SLOT_Pain,255,,,100);
			Enemy.PlaySound(Sound'PSbelta2',SLOT_Pain,255,,,0.5);
			GoToState('AttackStatics','StopIt');
		}
	}
Begin:
	MoveV = VRand()*1000+Location;
	StrafeFacing(MoveV,Enemy);
	GoTo('Begin');
StopIt:
	TurnToward(Enemy);
	DesiredSpeed = 0;
	Sleep(1);
	GoTo('StopIt');
}
function bool CheckIfEnemyCanSee( Pawn Other )
{
	local vector Dah;
	
	if( Other.bIsPlayer )
		Dah = vector(Other.ViewRotation)*VSize(Other.Location-Location);
	else Dah = vector(Other.Rotation)*VSize(Other.Location-Location);
	Dah += Other.Location;
	Return ( VSize(Other.Location-Location)>=VSize(Dah-Location) );
}
function Killed(pawn Killer, pawn Other, name damageType)
{
	Enemy = None;
	GoToState('Idle');
}

defaultproperties
{
     TraceEffect=Class'UnrealShare.RingExplosion4'
     bCanStrafe=True
     DrawScale=0.200000
     MultiSkins(0)=Texture'UnrealI.Skins.GasBag2'
     MultiSkins(2)=Texture'UnrealShare.Belt_fx.ShieldBelt.newred'
     MultiSkins(3)=Texture'UnrealShare.Belt_fx.ShieldBelt.newgold'
     CollisionRadius=55.000000
     CollisionHeight=80.000000
}
