//=============================================================================
// DropSkaarj.
//=============================================================================
class DropSkaarj expands Effects;

var bool bSecondHit;

simulated function PostBeginPlay()
{
	local rotator TmpRot;
	
	Super.PostBeginPlay();
	PlayAnim('Duck');
	TmpRot = RotRand(True);
	TmpRot.Pitch = 0;
	TmpRot.Roll = 0;
	SetRotation(TmpRot);
}
simulated function HitWall( vector HitNormal, actor HitWall )
{
	if( bSecondHit )
	{
		Destroy();
		Return;
	}
	else
	{
		if( HitWall==Level && HitNormal.Z<0.6 )
		{
			Velocity = MirrorVectorByNormal(Velocity,HitNormal);
			Return;
		}
	}
	bSecondHit = True;
	Velocity.Z = 400;
	SetPhysics(PHYS_Projectile);
	PlayAnim('InAir');
}
simulated function Landed( vector HitNormal )
{
	HitWall(HitNormal,Level);
}
simulated function Bump( Actor Other )
{
	if( Other.Class==Class'DropSkaarj' )
		Return;
	if( Level.NetMode!=NM_Client )
		Other.TakeDamage(160,Instigator,Other.Location,Velocity*100,'Crushed');
	HitWall(vect(0,0,0),Other);
}
simulated function BaseChange()
{
	if( Level.NetMode!=NM_Client && Base!=None && Base!=Level )
		Base.TakeDamage(160,Instigator,Base.Location,Velocity*100,'Crushed');
	HitWall(vect(0,0,0),Base);
}

defaultproperties
{
     bNetTemporary=False
     Physics=PHYS_Falling
     RemoteRole=ROLE_SimulatedProxy
     LifeSpan=5.000000
     DrawType=DT_Mesh
     Skin=Texture'UnrealI.Skins.Skaarjw3'
     Mesh=LodMesh'UnrealShare.Skaarjw'
     DrawScale=0.250000
     Fatness=153
     CollisionRadius=8.750000
     CollisionHeight=6.500000
     bCollideActors=True
     bCollideWorld=True
     bBlockActors=True
     bBlockPlayers=True
     bProjTarget=True
     bBounce=True
     Buoyancy=1.000000
}
