//=============================================================================
// EFlashGren.
//=============================================================================
class EFlashGren expands FlashGrenade;

function BurnRadius( float DamageAmount, float DamageRadius, name DamageName, float Momentum, vector HitLocation )
{
	local Pawn Victims;
	local float damageScale, dist;
	local vector dir;
	local Inventory I;
	
	if( bHurtEntry )
		return;

	bHurtEntry = true;
	foreach VisibleCollidingActors( class 'Pawn', Victims, DamageRadius, HitLocation )
	{
		if( Victims.Inventory!=None )
			For( I=Victims.Inventory; I!=None; I=I.Inventory )
				if( ShadowSuit(I)!=None )
					GoTo 'SkipHim';
		if( PlayerPawn(Victims)!=None )
		{
			PlayerPawn(Victims).ClientFlash(1000000,vect(1000000,1000000,1000000)*VRand());
			PlayerPawn(Victims).ClientMessage("You got strange by a glorious flash");
		}
		AddFireFor(Victims);
		SkipHim:
	}
	bHurtEntry = false;
}
function AddFireFor( Actor Other )
{
	local ParalyseThing bt;
	local float DaDec;
	local BurningThing B;
	
	if ( !Other.bIsPawn ) Return;
	DaDec = FRand();
	if( DaDec<0.3 )
	{
		ForEach AllActors(class'ParalyseThing',bt)
		{
			if( bt.Burner==Pawn(Other) )
			{
				bt.Heat+=3;
				bt.SetOwner(Instigator);
				Return;
			}
		}
		bt = Spawn(class'ParalyseThing',Instigator);
		bt.Heat = 10;
		bt.Burner = Pawn(Other);
	}
	else if( DaDec<0.4 )
	{
		ForEach AllActors(class'ParalyseThing',bt)
		{
			if( bt.Burner==Pawn(Other) )
			{
				bt.Heat+=10;
				bt.SetOwner(Instigator);
				Return;
			}
		}
		bt = Spawn(class'SleepyTime',Instigator);
		bt.Heat = 30;
		bt.Burner = Pawn(Other);
	}
	else if( DaDec<0.8 )
	{
		ForEach AllActors(class'BurningThing',b)
		{
			if( b.Owner==Other )
			{
				b.Heat+=2;
				b.Burner = Instigator;
				Return;
			}
		}
		
		b = Spawn(class'BurningThing',Other);
		b.Heat = 20;
		b.Burner = Instigator;
	}
	else
	{
		Spawn(Class 'BiggerMercFlare',,,Other.Location);
		Pawn(Other).Health = -99999999;
		Pawn(Other).Died(Instigator,'flashed',Other.Location);
	}
}

defaultproperties
{
     PickupMessage="You got a Glorious Flash bang"
     ItemName="Glorious Flash bang"
     RespawnTime=35.000000
     Texture=FireTexture'UnrealShare.Belt_fx.Testing.Effect_1'
     Skin=FireTexture'UnrealShare.Belt_fx.Testing.Effect_1'
     MultiSkins(1)=FireTexture'UnrealShare.Belt_fx.Testing.Effect_1'
}
