//=============================================================================
// FaworPlant.
//=============================================================================
class FaworPlant expands Pack6Pawns;

var bool bReadyToAttack,bIsOnRoot;

function PostBeginPlay()
{
	local vector HitLocation,HitNormal;
	Super.PostBeginPlay();
	
	if( Trace(HitLocation,HitNormal,Location+vect(0,0,-500),Location,True)!=None )
	{
		SetLocation(HitLocation+HitNormal*2);
		SetRotation(rotator(HitNormal));
	}
	SetPhysics(PHYS_Rotating);
}
function Tick( float DeltaTime )
{
	GoToState('Flowering');
}
Auto state Flowering
{
Ignores Tick;
	function bool SetEnemy( Pawn NewEnemy )
	{
		if( NewEnemy==None || NewEnemy.IsA('FaworPlant') ) Return False;
		Enemy = NewEnemy;
		if( bIsOnRoot && bReadyToAttack )
			GoToState('Flowering','UnRoot');
	}
	event EnemyNotVisible()
	{
		Enemy=None;
		GoToState('Flowering','DoRoot');
	}
	event SeePlayer( actor Seen )
	{
		if( Seen.IsA('Pawn') )
			SetEnemy(Pawn(Seen));
	}
	event HearNoise( float Loudness, Actor NoiseMaker)
	{
		if( NoiseMaker.IsA('Pawn') )
			SetEnemy(Pawn(NoiseMaker));
		else if( NoiseMaker.Owner!=None && NoiseMaker.Owner.IsA('Pawn') )
			SetEnemy(Pawn(NoiseMaker.Owner));
	}
	function Killed(pawn Killer, pawn Other, name damageType)
	{
		if( Other==Enemy ) EnemyNotVisible();
	}
	Event TakeDamage( int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
	{
		local int RealDamage;
		local pawn OtherPawn;
		local actor A;
		
		if( DamageType=='Corroded' ) Return;
		RealDamage = Level.Game.ReduceDamage(Damage,DamageType,Self,EventInstigator);
		Health-=RealDamage;
		if( Health>0 )
		{
			SetEnemy(EventInstigator);
			for ( OtherPawn=Level.PawnList; OtherPawn!=None; OtherPawn=OtherPawn.nextPawn )
				if( OtherPawn.IsA('FaworPlant') )
					FaworPlant(OtherPawn).SetEnemy(EventInstigator);
		}
		else
		{
			Level.Game.Killed(EventInstigator,Self,DamageType);
			if( Event != '' )
				foreach AllActors( class 'Actor', A, Event )
					A.Trigger(Self,EventInstigator);
			for ( OtherPawn=Level.PawnList; OtherPawn!=None; OtherPawn=OtherPawn.nextPawn )
				OtherPawn.Killed(EventInstigator,self,damageType);
			spawn( class'GreenGelPuff'); 
			spawn( class'EnergyBurst');
			Spawn( class 'BigBioGel',,,,RotRand(true));
			Spawn( class 'BigBioGel',,,,RotRand(true));
			Spawn( class 'BigBioGel',,,,RotRand(true));
			Spawn( class 'BigBioGel',,,,RotRand(true));
			Spawn( class 'BigBioGel',,,,RotRand(true));
			Destroy();
		}
	}
Begin:
	Style = STY_Translucent;
	bIsOnRoot=true;
	SetPhysics(PHYS_Rotating);
	bReadyToAttack = True;
	PlayAnim('Root');
	if( Enemy!=None ) GoTo('UnRoot');
	Stop;
DoRoot:
	SetPhysics(PHYS_Rotating);
	bIsOnRoot=true;
	bReadyToAttack=False;
	TweenAnim('Root',2.2);
	Sleep(2.2);
	GoTo('Begin');
UnRoot:
	bIsOnRoot=false;
	PlayAnim('Grow',0.2);
	FinishAnim();
	Style = STY_Normal;
Fighter:
	if( Enemy==None || Enemy.Health<=0 || Enemy.Class==None )
	{
		Enemy=None;
		GoTo('DoRoot');
	}
	if( NeedToTurn(Enemy.Location) ) TurnToward(Enemy);
	PlayAnim('Waver',1.5);
	ThrowProjAt(Enemy);
	Sleep(1);
	GoTo('Fighter');
}
function ThrowProjAt( Actor Other )
{
	local Actor P;
	local rotator FireRot;

	FireRot = Rotator(Other.Location-Location);
	P = Spawn(RangedProjectile);
	P.Velocity = vector(FireRot)*500;
	P.Velocity.Z = VSize(Other.Location-Location);
}

defaultproperties
{
     RangedProjectile=Class'Pack6.SlimeBall'
     DrawType=DT_Mesh
     Texture=FireTexture'UnrealShare.Effect22.fireeffect22'
     Mesh=LodMesh'UnrealShare.NaliFruitMesh'
     bMeshEnviroMap=True
     CollisionHeight=21.000000
}
