//=============================================================================
// FireTail.
//=============================================================================
class FireTail expands Effects;

var int NrFireT;
var FireTail Child;
var Actor OwnerActor;

replication
{
	// Things the server should send to the client.
	unreliable if( Role==ROLE_Authority )
		OwnerActor;
}

function PreBeginPlay()
{
	SetTimer(0.5,false);
	if( Owner.IsA('FireDragon') ) NrFireT=14;
}
function Timer()
{
	if( NrFireT>0 )
	{
		Child = Spawn(class'FireTail',Self);
		NrFireT--;
		Child.NrFireT=NrFireT;
		Child.DrawScale = DrawScale-0.1;
		OwnerActor = Owner;
	}
}
function Destroyed()
{
	if( Child!=None )
		Child.Destroy();
	Spawn(class'SpriteBallExplosion');
	Super.Destroyed();
}
simulated function Tick(float DeltaTime)
{
	if( Level.NetMode==NM_Client && OwnerActor!=None )
		Velocity = OwnerActor.Location - Location;
	else Velocity = Owner.Location - Location;
	Velocity*=2;
	if( Level.NetMode!=NM_Client )
		HurtRadius(200,200,'Burned',1000,Location);
}

defaultproperties
{
     bNetTemporary=False
     Physics=PHYS_Projectile
     RemoteRole=ROLE_SimulatedProxy
     DrawType=DT_Sprite
     Style=STY_Translucent
     Texture=FireTexture'UnrealShare.Effect28.FireEffect28a'
     DrawScale=2.000000
     bGameRelevant=False
     bCollideWorld=True
}
