//=============================================================================
// GhostStalker.
// Hard warping enemy,  inspered by Nintendo's Super Metroid game, Phantom
// in Zebes inside wrecked ship.									-.:..:
//=============================================================================
class GhostStalker expands Pack6Pawns;

var vector MoveV;

function eAttitude AttitudeToCreature(Pawn Other)
{
	if ( Other.IsA('GhostStalker') )
		return ATTITUDE_Friendly;
	else
		return ATTITUDE_Hate;
}
function Tick( float DeltaTime )
{
	GoToState('Idle');
}
Auto state Idle
{
Ignores Tick;

	function BeginState()
	{
		bCanFly = True;
		bCanSwim = True;
		SetPhysics(PHYS_Flying);
	}
	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
	{
		if( instigatedBy!=None && instigatedBy.Health>0 && GhostStalker(instigatedBy)==None )
		{
			Spawn(class'ParticleBurst');
			SetLocation(VRand()*1000+instigatedBy.Location);
			bHidden = True;
			SetEnemy(instigatedBy);
		}
		else
			if( SetLocation(VRand()*2000+Location) )
				Spawn(class'ParticleBurst');
	}
Begin:
	SetCollision(true,false,false);
	bMeshEnviroMap = True;
	Style = STY_Translucent;
	bHidden = false;
	ScaleGlow = 0.3;
BeingIdle:
	MoveV = VRand()*1000+Location;
	MoveTo(MoveV,AirSpeed);
	CheckVisibleEnemys();
	Sleep(1);
	GoTo('BeingIdle');
}
function bool SetEnemy( Pawn NewEnemy )
{
	if( NewEnemy==None || GhostStalker(NewEnemy)!=None || NewEnemy.Health<=0 ) Return false;
	if( FlockPawn(NewEnemy)!=None || FlockMasterPawn(NewEnemy)!=None ) Return false;
	
	if( Enemy!=None && Enemy!=NewEnemy )
		OldEnemy = Enemy;
	Enemy = NewEnemy;
	if( IsInState('Idle') )
		GoToState('AttackStatics');
	Return true;
}
State AttackStatics
{
	function Tick( float DeltaTime )
	{
		if( Enemy==None || Enemy.Class==None || Enemy.bDeleteMe || Enemy.Health<=0 )
		{
			Enemy = None;
			GoToState('Idle');
		}
		if( ScaleGlow<2 )
			ScaleGlow+=DeltaTime/3;
		else NextAttackState();
	}
	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
	{
		if( SetLocation(VRand()*200+Location) )
			Spawn(class'ParticleBurst');
		if( Damage>100 )
			NextAttackState();
		Global.TakeDamage(Damage,instigatedBy,hitlocation,momentum,damageType);
	}
	function BeginState()
	{
		SetPhysics(PHYS_Flying);
		ScaleGlow = 0;
		SetCollision(true,false,false);
		bMeshEnviroMap = False;
		Style = STY_Translucent;
		bHidden = false;
	}
	function NextAttackState()
	{
		local Float Dec;
		
		Dec = FRand();
		if( Dec<0.3 )
			GoToState('BallsAround');
		else if( Dec<0.8 )
			GoToState('BounchyBalls');
		else
			GoToState('MultiBallZ');
	}
Begin:
	MoveV = VRand()*1000+Location;
	MoveTo(MoveV,AirSpeed);
	GoTo('Begin');
}
State BallsAround
{
Ignores Tick;

	function BeginState()
	{
		local int i;
		local vector SpawnVect;
		
		SetLocation(Enemy.Location+VRand()*1000);
		SetPhysics(PHYS_Flying);
		ScaleGlow = 1;
		DesiredSpeed = 0;
		SetCollision(true,false,false);
		bMeshEnviroMap = False;
		Style = STY_Normal;
		bHidden = false;
		SetRotation(rotator(Enemy.Location-Location));
		For( i=0; i<10; i++ )
		{
			SpawnVect = VRand()*200+Location;
			Spawn(class'BlueProjectile',,,SpawnVect,rotator(Enemy.Location-SpawnVect));
		}
	}
Begin:
	TurnToward(Enemy);
	Sleep(3);
	Spawn(Class'ParticleBurst');
	SetLocation(Enemy.Location+VRand()*1000);
	GoToState('AttackStatics');
}
State BounchyBalls
{
	function BeginState()
	{
		SetLocation(Enemy.Location+VRand()*1000);
		SetPhysics(PHYS_Flying);
		ScaleGlow = 1;
		SetCollision(False,false,false);
		bMeshEnviroMap = True;
		Style = STY_Translucent;
		bHidden = true;
		SetTimer(0.4,true);
	}
	function Tick( float DeltaTime )
	{
		if( Enemy==None || Enemy.Class==None || Enemy.bDeleteMe || Enemy.Health<=0 )
		{
			Enemy = None;
			GoToState('Idle');
		}
		if( bHidden )
		{
			ScaleGlow-=DeltaTime/5;
			if( ScaleGlow<=0 )
				bHidden = false;
		}
		else
		{
			ScaleGlow+=DeltaTime/10;
			if( ScaleGlow>=2 )
				GoToState('AttackStatics');
		}
	}
	function Timer()
	{
		Spawn(class'BounchBall');
	}
Begin:
	MoveV = VRand()*300+Enemy.Location+vect(0,0,600);
	MoveTo(MoveV,AirSpeed);
	GoTo('Begin');
}
State MultiBallZ
{
Ignores Tick;

	function BeginState()
	{
		local int i;
		local vector SpawnVect;
		local Projectile P;
		
		DesiredSpeed = 0;
		SetLocation(Enemy.Location+VRand()*400+vect(0,0,300));
		SetPhysics(PHYS_Flying);
		ScaleGlow = 1;
		SetCollision(true,false,false);
		bMeshEnviroMap = false;
		Style = STY_Normal;
		bHidden = false;
		For( i=0; i<20; i++ )
		{
			SpawnVect = VRand()*700;
			SpawnVect.Z = 0;
			SpawnVect += Enemy.Location+vect(0,0,1000);
			P = Spawn(class'BounchBall',,,SpawnVect);
			if( P!=None ) P.Velocity = vect(0,0,0);
		}
	}
Begin:
	Sleep(2);
	GoToState('AttackStatics');
}
function Killed(pawn Killer, pawn Other, name damageType)
{
	if( Health<=0 ) Return;
	if( Other==OldEnemy )
		OldEnemy = None;
	if( Other==Enemy )
		if( OldEnemy!=None )
			Enemy = OldEnemy;
	if( Enemy==None && !IsInState('Idle') )
		GoToState('Idle');
}
State Dying
{
ignores SeePlayer, EnemyNotVisible, HearNoise, KilledBy, Trigger, Bump, HitWall, HeadZoneChange, FootZoneChange, 
ZoneChange, Falling, WarnTarget, Died, LongFall, PainTimer;

	function BeginState()
	{
		PlaySound(Sound'UnrealI.injur2t',SLOT_Talk,255,,,0.4);
		PlaySound(Sound'UnrealI.injur2t',SLOT_None,255,,,0.4);
		PlaySound(Sound'UnrealI.injur2t',SLOT_None,255,,,0.4);
		PlaySound(Sound'UnrealI.injur2t',SLOT_None,255,,,0.4);
		DesiredSpeed = 0;
		SetPhysics(PHYS_Flying);
		ScaleGlow = 0.1;
		SetCollision(false,false,false);
		bMeshEnviroMap = true;
		Style = STY_Translucent;
		bHidden = false;
	}
	function Tick( float DeltaTime )
	{
		if( DrawScale<30 )
			DrawScale+=DeltaTime*5;
		else Destroy();
	}
	function Timer();
	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
							Vector momentum, name damageType);
}
function Died(pawn Killer, name damageType, vector HitLocation)
{
	local pawn OtherPawn;
	local actor A;

	if ( bDeleteMe )
		return; //already destroyed
	Health = -1;
	for ( OtherPawn=Level.PawnList; OtherPawn!=None; OtherPawn=OtherPawn.nextPawn )
		OtherPawn.Killed(Killer, self, damageType);
	if ( CarriedDecoration != None )
		DropDecoration();
	level.game.Killed(Killer, self, damageType);
	//log(class$" dying");
	if( Event != '' )
		foreach AllActors( class 'Actor', A, Event )
			A.Trigger( Self, Killer );
	Level.Game.DiscardInventory(self);
	if ( Level.Game.bGameEnded )
		return;
	if ( RemoteRole == ROLE_AutonomousProxy )
		ClientDying(DamageType, HitLocation);
	GotoState('Dying');
}
function PlayGutHit(float tweentime);
function PlayHeadHit(float tweentime);
function PlayLeftHit(float tweentime);
function PlayRightHit(float tweentime);
function bool AdjustHitLocation(out vector HitLocation, vector TraceDir)
{
	return true;
}
function PlayHit(float Damage, vector HitLocation, name damageType, float MomentumZ)
{
	local float rnd;
	local Bubble1 bub;
	local bool bOptionalTakeHit;
	local vector BloodOffset;
	local blood2 b;

	if (Damage > 1) //spawn some blood
	{
		if (damageType == 'Drowned')
		{
			bub = spawn(class 'Bubble1',,, Location 
				+ 0.7 * CollisionRadius * vector(ViewRotation) + 0.3 * EyeHeight * vect(0,0,1));
			if (bub != None)
				bub.DrawScale = FRand()*0.06+0.04; 
		}
		else if ( damageType != 'Corroded' )
		{
			BloodOffset = 0.2 * CollisionRadius * Normal(HitLocation - Location);
			BloodOffset.Z = BloodOffset.Z * 0.5;
			b = spawn(class 'BloodBurst',,,hitLocation + BloodOffset, rotator(BloodOffset));
			if ( bGreenBlood && (b != None) ) b.GreenBlood();
			if ( Level.bHighDetailMode )
			{
				if ( bGreenBlood )
					spawn(class'GreenBloodPuff',,, hitLocation + BloodOffset);
				else
					spawn(class'BloodPuff',,, hitLocation + BloodOffset);
			}
		}
	}	

	if ( (Weapon != None) && Weapon.bPointing && !bIsPlayer )
	{
		bFire = 0;
		bAltFire = 0;
	}
	
	bOptionalTakeHit = bIsWuss || ( (Level.TimeSeconds - LastPainTime > 0.3 + 0.25 * skill)
						&& (Damage * FRand() > 0.08 * Health) && (Skill < 3) ); 
	if ( (!bIsPlayer || (Weapon == None) || !Weapon.bPointing) 
		&& (bOptionalTakeHit || (MomentumZ > 140) || (bFirstShot && (Damage > 0.015 * (skill + 6) * Health)) 
			 || (Damage * FRand() > (0.17 + 0.04 * skill) * Health)) ) 
	{
		PlayTakeHitSound(Damage, damageType, 3);
		PlayHitAnim(HitLocation, Damage);
	}
	else if (NextState == 'TakeHit')
	{
		PlayTakeHitSound(Damage, damageType, 2);
		NextState = '';
	}
}

defaultproperties
{
     AirSpeed=2000.000000
     AccelRate=1500.000000
     BaseEyeHeight=50.000000
     Health=800
     DrawType=DT_Mesh
     Texture=Texture'Pack6.CloakTexture'
     Mesh=Mesh'Pack6.BIGeyeMesh'
     DrawScale=0.700000
     MultiSkins(0)=Texture'UnrealI.Skins.JGas1'
     MultiSkins(1)=FireTexture'UnrealShare.Effect25.fireeffect25'
     MultiSkins(2)=Texture'UWindow.WhiteTexture'
     MultiSkins(3)=Texture'UWindow.Icons.Background'
     CollisionRadius=150.000000
     CollisionHeight=200.000000
     bBlockActors=False
     bBlockPlayers=False
}
