//=============================================================================
// GlunkBall.
//=============================================================================
class GlunkBall expands Plasma;

var() int NrTime;

function PostBeginPlay()
{
	Super(Projectile).PostBeginPlay();
	RandSpin(50000);
	PlaySound(SpawnSound);
	Velocity = vector(Rotation)*Speed;
}
function ProcessTouch (Actor Other, vector HitLocation)
{
	local CrazyGrav CG;
	local bool bFound;
	
	if( Other.bIsPawn && Pawn(Other).FindInventoryType(class'ParalSuit')!=None )
		Return;
	If ( (Other!=Instigator) && !Other.IsA('GlunkBall') )
	{
		Other.TakeDamage(Damage, instigator,HitLocation,
		(MomentumTransfer * Velocity/speed), 'Glounked' );
		if (Role == ROLE_Authority)
		{
			ForEach AllActors(class'CrazyGrav',CG)
			{
				if( CG.Owner==Other )
				{
					bFound=true;
					Break;
				}
			}
			if( !bFound )
				CG = Spawn(class'CrazyGrav',Other);
			if( CG.Heat>600 )
				CG.Heat+=NrTime;
			else CG.Heat+=NrTime/5;
		}
	}
}

defaultproperties
{
     NrTime=500
     speed=1000.000000
     Damage=25.000000
     RemoteRole=ROLE_SimulatedProxy
     DrawType=DT_Sprite
     Style=STY_Translucent
     Texture=Texture'UnrealShare.S_bubble1'
     Mesh=None
     DrawScale=0.200000
     CollisionRadius=1.000000
     CollisionHeight=1.000000
}
