//=============================================================================
// GoodBoy.
//=============================================================================
class GoodBoy expands HumanPawn;

var Pawn ParentOwner;
var Actor WayNode,OldNode;
var vector MoveVect,OldVect;
var float HuntingTime;
var GoodBoy Friend;
var(Sounds) sound Speak[5];
var bool bImTheBoss;

function PreBeginPlay()
{
	local float TR;
	Super.PreBeginPlay();
	
	TR = FRand();
	if( TR<0.2 )
		Mesh = Mesh'Male1';
	else if( TR<0.4 )
		Mesh = Mesh'Male3';
	else if( TR<0.6 )
		Mesh = Mesh'FeMale1';
	else if( TR<0.8 )
		Mesh = Mesh'FeMale2';
}
function WhatToDoNext(name LikelyState, name LikelyLabel)
{
	bQuiet = false;
	GotoState('IdleMoving');
}
state Guarding
{
	Event BeginState()
	{
		GoToState('IdleMoving');
	}
}
state Wandering
{
	Event BeginState()
	{
		GoToState('IdleMoving');
	}
}
state Waiting
{
	Event BeginState()
	{
		GoToState('IdleMoving');
	}
}
function FindEnemys();
function PreSetMovement()
{
	bCanJump = true;
	bCanWalk = true;
	bCanSwim = true;
	bCanFly = false;
	MinHitWall = -0.6;
	bCanOpenDoors = true;
	bCanDoSpecial = true;
}
function GoTalkTo( GoodBoy Other );
State IdleMoving
{
	function FindEnemys()
	{
		local Pawn P;
		local GoodBoy GB;
		
		CheckVisibleEnemys();
		if( FRand()<0.1 )
			ForEach VisibleActors(class'GoodBoy',GB,600)
				if( FRand()<0.05 && GB.Friend==None && GB!=Self )
					GoTalkTo(GB);
	}
	function GoTalkTo( GoodBoy Other )
	{
		Friend = Other;
		Other.Friend = Self;
		GoToState('IdleMoving','GoTalk');
		Other.GoToState('IdleMoving','GoTalk');
		HuntingTime = 10;
		Other.HuntingTime = 10;
	}
	function bool FindDestination()
	{
		local Pawn P;
		local int i,ii;
		
		ForEach AllActors(class'Pawn',P)
			if( !P.IsA('GoodBoy') && !P.IsA('CoopBot') && !P.IsA('PlayerPawn') )
				i++;
		i = Rand(i+1);
		ForEach AllActors(class'Pawn',P)
		{
			if( !P.IsA('GoodBoy') && !P.IsA('CoopBot') && !P.IsA('PlayerPawn') )
			{
				if( i==ii )
				{
					if( FindPathTo(P.Location)==None )
						Return false;
					MoveVect = P.Location;
					HuntingTime = 30;
					Return true;
				}
				ii++;
			}
		}
		Return false;
	}
	function Tick( float DeltaTime )
	{
		if( HuntingTime>=0 ) HuntingTime-=DeltaTime;
	}
	Event BeginState()
	{
		PreSetMovement();
	}
	function Bump( Actor Other )
	{
		if( Other.IsA('GoodBoy') && Friend!=None )
		{
			if( Friend==Other )
			{
				Disable('Bump');
				bImTheBoss = True;
				GoodBoy(Other).bImTheBoss=False;
				GoToState('IdleMoving','Talking');
				Other.GoToState('IdleMoving','Talking');
			}
		}
	}
	function SpeakToFriend()
	{
		local float Decesion;
		
		Decesion = FRand();
		if( Decesion<0.2 )
		{
			PlayAnim('Taunt1');
			PlaySound(Speak[0]);
		}
		else if( Decesion<0.4 )
		{
			PlayAnim('Victory1');
			PlaySound(Speak[1]);
		}
		else if( Decesion<0.6 )
		{
			PlayAnim('Wave',0.5);
			PlaySound(Speak[2]);
		}
		else if( Decesion<0.8 )
		{
			PlayAnim('LookL');
			PlaySound(Speak[3]);
		}
		else
		{
			PlayAnim('Dead6');
			PlaySound(Speak[4]);
		}
	}
	function bool RedyToMove( GoodBoy Other )
	{
		if( Other.bImTheBoss ) Return False;
		else if( FRand()<0.6 ) Return true;
		Return False;
	}
Begin:
	PlayRunning();
	FindEnemys();
	if( ParentOwner==None || ParentOwner.Health<=0 || ParentOwner.Class==None )
	{
		if( ParentOwner!=None && (ParentOwner.Health<=0 && !ParentOwner.bIsPlayer) || ParentOwner.Class==None )
			ParentOwner=None;
		GoTo('Selfish');
	}
	if( actorReachable(ParentOwner) )
	{
		MoveVect = ParentOwner.Location;
		MoveVect.Y += Rand(200)-100;
		MoveVect.X += Rand(200)-100;
		MoveVect.Z += Rand(200)-100;
	}
	else
	{
		WayNode = FindPathTo(ParentOwner.Location);
		if( WayNode==None )
			GoTo('Selfish');
		MoveVect = WayNode.Location;
	}
	MoveTo(MoveVect,GroundSpeed);
	if( OldVect==MoveVect ) Sleep(1);
	else OldVect=MoveVect;
	GoTo('Begin');
Selfish:
	if( !FindDestination() )
	{
		MoveVect = Location;
		MoveVect.Y += Rand(1000)-500;
		MoveVect.X += Rand(1000)-500;
		MoveVect.Z += Rand(1000)-500;
		MoveTo(MoveVect,GroundSpeed);
		if( OldVect==MoveVect ) Sleep(1);
		else OldVect=MoveVect;
	}
	else
	{
ReWalk:
		if( HuntingTime<=0 ) GoTo('Begin');
		OldNode = WayNode;
		WayNode = FindPathTo(MoveVect);
		if( WayNode==None )
		{
			MoveTo(MoveVect,GroundSpeed);
			PlayWaiting();
			Sleep(1);
		}
		else
		{
			if( OldNode!=None && OldNode.IsA('LiftExit') && WayNode.IsA('LiftCenter') &&
			 LiftExit(OldNode).LiftTag==LiftCenter(WayNode).LiftTag)
			{
ReCheck:
				if( Location.Z>(WayNode.Location.Z-LiftCenter(WayNode).MaxZDiffAdd-40) &&
				 Location.Z<(WayNode.Location.Z+LiftCenter(WayNode).MaxZDiffAdd+40) )
					GoTo 'Skip';
				else
				{
					Acceleration = vect(0,0,0);
					PlayWaiting();
					Sleep(1);
					GoTo 'ReCheck';
				}
			}
Skip:
			MoveToward(WayNode,GroundSpeed);
			if( OldVect==WayNode.Location ) Sleep(1);
			else OldVect=WayNode.Location;
			if( pointReachable(MoveVect) ) GoTo('Begin');
			PlayRunning();
			FindEnemys();
			GoTo 'ReWalk';
		}
	}
	GoTo 'Begin';
GoTalk:
	if( Friend==None ) GoTo('Begin');
	Enable('Bump');
	PlayWalking();
	MoveToward(Friend,GroundSpeed/2);
	Sleep(0.1);
	if( HuntingTime<=0 )
	{
		Disable('Bump');
		Friend=None;
		GoTo('Begin');
	}
	GoTo('GoTalk');
Talking:
	if( Friend==None ) GoTo('Begin');
	PlayWalking();
	MoveTo(Location,GroundSpeed/3);
	PlayWaiting();
	FinishAnim();
	Acceleration = vect(0,0,0);
	if (NeedToTurn(Friend.Location))
	{	
		PlayTurning();
		TurnToward(Friend);
		TweenToPatrolStop(0.2);
		FinishAnim();
		NextAnim = '';
	}
Speak:
	SpeakToFriend();
	FinishAnim();
	PlayWaiting();
	Sleep(1);
	if( RedyToMove(Friend) )
	{
		Friend.Friend=None;
		Friend.GoToState('IdleMoving','Begin');
		Friend=None;
		GoTo('Begin');
	}
	else GoTo('Speak');
}
function bool MayHate( Pawn NewEnemy )
{
	if( NewEnemy.Health<=0 ) return false;
	if( NewEnemy.IsA('ScriptedPawn') )
	{
		if( NewEnemy.IsA('CoopBot') ) Return false;
		else if( NewEnemy.IsA('GoodBoy') ) Return false;
		else if( NewEnemy.IsA('Boy') ) Return false;
		else Return true;
	}
	else if( NewEnemy.IsA('FlockPawn') ) Return false;
	else if( NewEnemy.IsA('PlayerPawn') ) Return false;
	else Return true;
}
function bool SetEnemy( Pawn NewEnemy )
{
	if( NewEnemy==None ) Return False;
	if( !MayHate(NewEnemy) ) Return false;
	if( OldEnemy==None || OldEnemy!=Enemy )
		OldEnemy=Enemy;
	if( Friend!=None )
	{
		Friend.Friend=None;
		Friend.SetEnemy(NewEnemy);
		Friend = None;
	}
	Enemy = NewEnemy;
	if( IsInState('IdleMoving') ) GoToState('Attacking');
	if ( !bFirstHatePlayer && Enemy.bIsPlayer && (FirstHatePlayerEvent != '') )
		TriggerFirstHate();
	return true;
}
event HearNoise( float Loudness, Actor NoiseMaker)
{
	if( NoiseMaker.IsA('Pawn') )
		SetEnemy(Pawn(NoiseMaker));
	else if( NoiseMaker.Owner!=None && NoiseMaker.Owner.IsA('Pawn') )
		SetEnemy(Pawn(NoiseMaker.Owner));
}
event SeePlayer( actor Seen )
{
	if( Seen.IsA('Pawn') )
		SetEnemy(Pawn(Seen));
}
function Tick(float DeltaTime)
{
	if ( (Weapon != None) && (Weapon.AmmoType != None) )
		Weapon.AmmoType.AmmoAmount = Weapon.AmmoType.Default.AmmoAmount;
}
function bool RedyToMove( GoodBoy Other );
function PlayHit(float Damage, vector HitLocation, name damageType, float MomentumZ)
{
	local float rnd;
	local Bubble1 bub;
	local bool bOptionalTakeHit;
	local vector BloodOffset;
	local blood2 b;

	if (Damage > 1) //spawn some blood
	{
		if (damageType == 'Drowned')
		{
			bub = spawn(class 'Bubble1',,, Location 
				+ 0.7 * CollisionRadius * vector(ViewRotation) + 0.3 * EyeHeight * vect(0,0,1));
			if (bub != None)
				bub.DrawScale = FRand()*0.06+0.04; 
		}
		else if ( damageType != 'Corroded' )
			skinnedFrag(class'Fragment1',texture'JCannon1', vect(0,0,1000),0.3,6);	
	}	

	if ( (Weapon != None) && Weapon.bPointing && !bIsPlayer )
	{
		bFire = 0;
		bAltFire = 0;
	}
	
	bOptionalTakeHit = bIsWuss || ( (Level.TimeSeconds - LastPainTime > 0.3 + 0.25 * skill)
						&& (Damage * FRand() > 0.08 * Health) && (Skill < 3)
						&& (GetAnimGroup(AnimSequence) != 'MovingAttack') 
						&& (GetAnimGroup(AnimSequence) != 'Attack') ); 
	if ( (!bIsPlayer || (Weapon == None) || !Weapon.bPointing) 
		&& (bOptionalTakeHit || (MomentumZ > 140) || (bFirstShot && (Damage > 0.015 * (skill + 6) * Health)) 
			 || (Damage * FRand() > (0.17 + 0.04 * skill) * Health)) ) 
	{
		PlayTakeHitSound(Damage, damageType, 3);
		PlayHitAnim(HitLocation, Damage);
	}
	else if (NextState == 'TakeHit')
	{
		PlayTakeHitSound(Damage, damageType, 2);
		NextState = '';
	}
}
simulated function skinnedFrag(class<fragment> FragType, texture FragSkin, vector Momentum, float DSize, int NumFrags) 
{
	local int i;
	local Fragment s;

	if ( Region.Zone.bDestructive )
		return;
	for (i=0 ; i<NumFrags ; i++) 
	{
		s = Spawn( FragType, Owner);
		s.CalcVelocity(Momentum/100,0);
		s.Skin = FragSkin;
		s.DrawScale = DSize*0.5+0.7*DSize*FRand();
	}
}
function bool CheckVisibleEnemys()
{
	local Pawn P;
	local vector HitL,HitN;
	local Actor TraceActor;
	
	For( P=Level.PawnList; P!=None; P=P.NextPawn )
	{
		if( VSize(P.Location-Location)<3000 && FlockPawn(P)==None &&
		 FlockMasterPawn(P)==None && P.Health>0 && !P.bHidden )
		{
			TraceActor = Trace(HitL,HitN,P.Location,Location);
			if( (TraceActor==P || TraceActor==None) && SetEnemy(P) )
				Return True;
		}
	}
	Return false;
}
state Roaming
{
	function BeginState()
	{
		SpecialGoal = None;
		bSpecialGoal = false;
		SpecialPause = 0.0;
		Enemy = None;
		SetAlertness(0.2);
		bReadyToAttack = false;
		GoToState('IdleMoving');
	}
}
state StakeOut
{
ignores EnemyNotVisible; 
		
	function BeginState()
	{
		Acceleration = vect(0,0,0);
		bCanJump = true;
		bClearShot = true;
		bReadyToAttack = true;
		SetAlertness(0.5);
	}

Begin:
	Acceleration = vect(0,0,0);
	PlayChallenge();
	TurnTo(LastSeenPos);
	if ( bHasRangedAttack && bClearShot && (FRand() < 0.5) && (VSize(Enemy.Location - LastSeenPos) < 150) && CanStakeOut() )
		PlayRangedAttack();
	FinishAnim();
Nodeing:
	if( pointReachable(LastSeenPos) )
	{
		PlayRunning();
		MoveTo(LastSeenPos,GroundSpeed);
	}
	else
	{
		WayNode = FindPathTo(LastSeenPos);
		PlayRunning();
		if( WayNode==None )
		{
			MoveTo(LastSeenPos,GroundSpeed);
			Acceleration = vect(0,0,0);
			PlayChallenge();
			FinishAnim();
			GoToState('Attacking');
		}
		else
		{
			MoveToward(WayNode,GroundSpeed);
			Acceleration = vect(0,0,0);
			PlayWaiting();
			Sleep(0.5);
			GoTo 'Nodeing';
		}
	}
}

defaultproperties
{
     Speak(0)=Sound'UnrealI.Mercenary.chlng3mr'
     Speak(1)=Sound'UnrealI.Mercenary.syl2mr'
     Speak(2)=Sound'UnrealI.Mercenary.syl3mr'
     Speak(3)=Sound'UnrealI.Mercenary.syl4mr'
     Speak(4)=Sound'UnrealI.Mercenary.syl5mr'
     WeaponType=Class'Pack6.Uzis'
     MeleeRange=-1.000000
     Health=400
     AttitudeToPlayer=ATTITUDE_Friendly
     Intelligence=BRAINS_REPTILE
     Skin=Texture'UnrealShare.Skins.ASC1'
     DrawScale=0.750000
     CollisionRadius=12.750000
     CollisionHeight=29.250000
}
