//=============================================================================
// GoodMen.
//=============================================================================
class GoodMen expands Pickup;

#exec AUDIO IMPORT FILE="..\UnrealShare\Sounds\Pickups\FFIELDA3.WAV" NAME="FieldSnd" GROUP="Pickups"
#exec AUDIO IMPORT FILE="..\UnrealShare\Sounds\Pickups\FFIELDh2.WAV" NAME="fFieldh2" GROUP="Pickups"

#exec TEXTURE IMPORT NAME=I_ForceField FILE=TEXTURES\HUD\i_force.PCX GROUP="Icons" MIPS=OFF

#exec MESH IMPORT MESH=ForceFieldPick ANIVFILE=MODELS\force2_a.3D DATAFILE=MODELS\force2_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=ForceFieldPick X=0 Y=0 Z=0 YAW=64
#exec MESH SEQUENCE MESH=ForceFieldPick SEQ=All STARTFRAME=0  NUMFRAMES=1
#exec TEXTURE IMPORT NAME=aforce1 FILE=MODELS\force2.PCX GROUP="Skins"
#exec OBJ LOAD FILE=..\UnrealShare\Textures\fireeffect27.utx  PACKAGE=UNREALI.Effect27
#exec MESHMAP SCALE MESHMAP=ForceFieldPick X=0.07 Y=0.07 Z=0.14
#exec MESHMAP SETTEXTURE MESHMAP=ForceFieldPick NUM=1 TEXTURE=aforce1
#exec MESHMAP SETTEXTURE MESHMAP=ForceFieldPick NUM=0 TEXTURE=Unreali.Effect27.FireEffect27

var vector X,Y,Z;	
var() String M_NoRoom;

state Activated
{
	function BeginState()
	{
		local GoodBoy GB;
		bStasis = false;
		GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
		GB = Spawn(class'GoodBoy', Owner, '', Pawn(Owner).Location + 90.0 * X - 0 * Y - 0 * Z );
		if (GB == None)
		{
			Owner.PlaySound(DeActivateSound);
			Pawn(Owner).ClientMessage(M_NoRoom);
			GoToState('DeActivated');
		}
		else
		{
			GB.ParentOwner = Pawn(Owner);
			Owner.PlaySound(ActivateSound);	
			if (NumCopies>0)
				NumCopies--;
			else
			{
				Pawn(Owner).NextItem();
				if (Pawn(Owner).SelectedItem == Self) Pawn(Owner).SelectedItem=None;	
				Pawn(Owner).DeleteInventory(Self);
			}
		}
	}
}

state DeActivated
{
Begin:
}
auto state Pickup
{	
	function Touch( actor Other )
	{
		local Inventory Copy;
		if ( ValidTouch(Other) ) 
		{
			Copy = SpawnCopy(Pawn(Other));
			if (Level.Game.LocalLog != None)
				Level.Game.LocalLog.LogPickup(Self, Pawn(Other));
			if (Level.Game.WorldLog != None)
				Level.Game.WorldLog.LogPickup(Self, Pawn(Other));
			if (bActivatable && Pawn(Other).SelectedItem==None) 
				Pawn(Other).SelectedItem=Copy;
			if (bActivatable && bAutoActivate && Pawn(Other).bAutoActivate) Copy.Activate();
			Pawn(Other).ClientMessage(PickupMessage, 'Pickup');	// add to inventory and run pickupfunction	
			PlaySound (PickupSound,,2.0);	
			Pickup(Copy).PickupFunction(Pawn(Other));
		}
	}
	function Landed( vector HitNormal )
	{
		GoToState('Pickup','HasLanded');
		PlaySound(Sound'UnrealI.Male.MLand2');
	}
Begin:
	BecomePickup();
	PlayAnim('JumpSmFr');
	SetPhysics(PHYS_Falling);
	Stop;
	
HasLanded:
	TweenAnim('LandSmFr',0.3);
	Sleep(0.3);
	if ( bRotatingPickup && (Physics != PHYS_Falling) )
		SetPhysics(PHYS_Rotating);
ReAnim:
	if( FRand()<0.2 )
		PlayAnim('Look');
	else if( FRand()<0.2 )
		PlayAnim('Wave');
	else if( FRand()<0.2 )
		PlayAnim('CockGunL');
	else if( FRand()<0.2 )
		PlayAnim('Victory1');
	else
		PlayAnim('Taunt1');
	FinishAnim();
	GoTo 'ReAnim';

Dropped:
	GoTo 'Begin';
}

defaultproperties
{
     M_NoRoom="That dude need more space..."
     bActivatable=True
     bDisplayableInv=True
     PickupMessage="You found some kind of robot..."
     ItemName="Robot man"
     PickupViewMesh=LodMesh'UnrealI.Male2'
     PickupViewScale=0.300000
     PickupSound=Sound'UnrealShare.Male.MJump1'
     DeActivateSound=Sound'UnrealShare.Male.MDeath4'
     Icon=Texture'UnrealShare.Icons.GreenSkull'
     Skin=Texture'UnrealShare.Skins.ASC1'
     Mesh=LodMesh'UnrealI.Male2'
     DrawScale=0.300000
     CollisionRadius=5.250000
     CollisionHeight=10.750000
}
