//=============================================================================
// GrenTent.
//=============================================================================
class GrenTent expands Pack6Weps;

var() sound IdleSounds[5];
var float Decesion;

function TweenSelect()
{
	TweenAnim('Uncurl',0.001);
	if( MySecondWeapon!=None )
		MySecondWeapon.TweenAnim('Uncurl',0.001);
}
function TweenDown()
{
	PlayAnim('Curl', 1.0, 0.2);
	if( MySecondWeapon!=None )
		MySecondWeapon.PlayAnim('Curl', 1.0, 0.2);
}
function PlaySelect()
{
	PlayAnim('Uncurl',1.0,0.0);
	Owner.PlaySound(SelectSound, SLOT_Misc, Pawn(Owner).SoundDampening);
	if( MySecondWeapon!=None )
		MySecondWeapon.PlayAnim('Uncurl',1.0,0.0);
}
state Idle
{
Begin:
	bPointing=False;
	if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0) ) 
		Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
	if ( Pawn(Owner).bFire!=0 ) Fire(0.0);
	if ( Pawn(Owner).bAltFire!=0 ) AltFire(0.0);	
	Disable('AnimEnd');
	Decesion = FRand();
	if( Decesion<0.2 )
	{
		Owner.PlaySound(IdleSounds[0], SLOT_Misc, Pawn(Owner).SoundDampening);
		TweenAnim('Move2',1);
		Sleep(1);
		TweenAnim('Move1',0.2);
		Sleep(0.2);
		TweenAnim('Move2',0.2);
		Sleep(0.2);
		TweenAnim('Move1',0.2);
		Sleep(0.2);
		PlayAnim('Move2',,0.6);
	}
	else if( Decesion<0.4 )
	{
		PlayAnim('Curl',,0.2);
		FinishAnim();
		Sleep(2);
		PlayAnim('Uncurl');
		Owner.PlaySound(SelectSound, SLOT_Misc, Pawn(Owner).SoundDampening);
	}
	else if( Decesion<0.7 )
	{
		Owner.PlaySound(IdleSounds[1], SLOT_Misc, Pawn(Owner).SoundDampening);
		PlayAnim('Dead1',,0.2);
		FinishAnim();
		Sleep(0.5);
		PlayAnim('Dead1Land',,0.1);
		FinishAnim();
		Sleep(1);
		TweenAnim('Move2',0.2);
		Sleep(0.2);
	}
	else PlayAnim('Waver',,0.5);
	FinishAnim();
	GoTo('Begin');
}
simulated event RenderOverlays( canvas Canvas )
{
	local rotator NewRot;
	local bool bPlayerOwner;
	local int Hand;
	local PlayerPawn PlayerOwner;

	if ( bHideWeapon || (Owner == None) )
		return;

	PlayerOwner = PlayerPawn(Owner);
	if ( PlayerOwner != None )
	{
		bPlayerOwner = true;
		Hand = PlayerOwner.Handedness;
	}

	if (  (Level.NetMode == NM_Client) && bPlayerOwner && (Hand == 2) )
	{
		bHideWeapon = true;
		return;
	}

	if ( !bPlayerOwner || (PlayerOwner.Player == None) )
		Pawn(Owner).WalkBob = vect(0,0,0);

	if ( (bMuzzleFlash > 0) && bDrawMuzzleFlash && Level.bHighDetailMode && (MFTexture != None) )
	{
		MuzzleScale = Default.MuzzleScale * Canvas.ClipX/640.0;
		if ( !bSetFlashTime )
		{
			bSetFlashTime = true;
			FlashTime = Level.TimeSeconds + FlashLength;
		}
		else if ( FlashTime < Level.TimeSeconds )
			bMuzzleFlash = 0;
		if ( bMuzzleFlash > 0 )
		{
			if ( Hand == 0 )
				Canvas.SetPos(Canvas.ClipX/2 - MuzzleScale * FlashS + Canvas.ClipX * (-0.2 * Default.FireOffset.Y * FlashO), Canvas.ClipY/2 - MuzzleScale * FlashS + Canvas.ClipY * (FlashY + FlashC));
			else
				Canvas.SetPos(Canvas.ClipX/2 - MuzzleScale * FlashS + Canvas.ClipX * (Hand * Default.FireOffset.Y * FlashO), Canvas.ClipY/2 - MuzzleScale * FlashS + Canvas.ClipY * FlashY);

			Canvas.Style = 3;
			Canvas.DrawIcon(MFTexture, MuzzleScale);
			Canvas.Style = 1;
		}
	}
	else
		bSetFlashTime = false;

	SetLocation( Owner.Location + CalcDrawOffset() );
	NewRot = Pawn(Owner).ViewRotation;

	if ( Hand == 0 )
		newRot.Roll = -2 * Default.Rotation.Roll;
	else
		newRot.Roll = Default.Rotation.Roll * Hand;

	newRot.Roll += 32732;
	setRotation(newRot);
	Canvas.DrawActor(self, false);
	if( mySecondWeapon!=None )
		RenderSecondW(Canvas);
}
simulated event RenderSecondW( canvas Canvas )
{
	local rotator NewRot;
	local bool bPlayerOwner;
	local int Hand;
	local PlayerPawn PlayerOwner;

	if ( bHideWeapon || (Owner == None) || mySecondWeapon==None )
		return;

	PlayerOwner = PlayerPawn(Owner);
	if ( PlayerOwner != None )
	{
		bPlayerOwner = true;
		Hand = PlayerOwner.Handedness;
	}

	if (  (Level.NetMode == NM_Client) && bPlayerOwner && (Hand == 2) )
	{
		mySecondWeapon.bHideWeapon = true;
		return;
	}
	mySecondWeapon.SetLocation( Owner.Location + mySecondWeapon.CalcDrawOffset() );
	NewRot = Pawn(Owner).ViewRotation;
	if ( Hand == 0 )
		newRot.Roll = Default.Rotation.Roll * Hand;
	else
		newRot.Roll = -2 * Default.Rotation.Roll;
	newRot.Roll += 32732;
	mySecondWeapon.setRotation(newRot);
	Canvas.DrawActor(mySecondWeapon, false);
}
function Fire( float Value )
{
	if (AmmoType.UseAmmo(1))
	{
		GotoState('NormalFire');
		bPointing=True;
		if ( Owner.bHidden )
			CheckVisibility();
	}
}

function AltFire( float Value )
{
	if (AmmoType.UseAmmo(1))
	{
		GotoState('AltFiring');
		bPointing=True;
		if ( Owner.bHidden )
			CheckVisibility();
	}
}
///////////////////////////////////////////////////////
state NormalFire
{
Begin:
	TweenAnim('Shoot',0.2);
	Sleep(0.2);
	if ( PlayerPawn(Owner) != None )
		PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
	ProjectileFire(ProjectileClass,1000,true);
	Owner.PlaySound(FireSound, SLOT_Misc, Pawn(Owner).SoundDampening);
	if( MySecondWeapon!=None )
		MySecondWeapon.Fire(1);
	PlayAnim('Shoot',3);
	FinishAnim();
	Finish();
}

////////////////////////////////////////////////////////
state AltFiring
{
Begin:
	TweenAnim('Shoot',0.6);
	Sleep(0.6);
	if ( PlayerPawn(Owner) != None )
		PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
	ProjectileFire(AltProjectileClass,1000,true);
	Owner.PlaySound(FireSound, SLOT_Misc, Pawn(Owner).SoundDampening);
	PlayAnim('Shoot',0.8);
	Sleep(0.3);
	if( MySecondWeapon!=None )
		MySecondWeapon.AltFire(1);
	FinishAnim();
	Finish();
}
auto state Pickup
{
Begin:
	Disable('Tick');
	BecomePickup();
	Decesion = FRand();
	if( Decesion<0.2 )
	{
		PlaySound(IdleSounds[0], SLOT_Misc);
		TweenAnim('Move2',1);
		Sleep(1);
		TweenAnim('Move1',0.2);
		Sleep(0.2);
		TweenAnim('Move2',0.2);
		Sleep(0.2);
		TweenAnim('Move1',0.2);
		Sleep(0.2);
		PlayAnim('Move2',,0.6);
	}
	else if( Decesion<0.4 )
	{
		PlayAnim('Curl',,0.2);
		FinishAnim();
		Sleep(2);
		PlayAnim('Uncurl');
		PlaySound(SelectSound, SLOT_Misc);
	}
	else if( Decesion<0.7 )
	{
		PlaySound(IdleSounds[1], SLOT_Misc);
		PlayAnim('Dead1',,0.2);
		FinishAnim();
		Sleep(0.5);
		PlayAnim('Dead1Land',,0.1);
		FinishAnim();
		Sleep(1);
		TweenAnim('Move2',0.2);
		Sleep(0.2);
	}
	else PlayAnim('Waver',,0.5);
	FinishAnim();
	GoTo('Begin');
Dropped:
	Disable('Tick');
	if( bAmbientGlow )
		AmbientGlow=255;
	if( bSleepTouch )
		CheckTouching();
	GoTo('Begin');
}

defaultproperties
{
     IdleSounds(0)=Sound'UnrealShare.Tentacle.injured2tn'
     IdleSounds(1)=Sound'UnrealShare.Tentacle.death2tn'
     IdleSounds(2)=Sound'UnrealShare.Tentacle.splat2tn'
     bDualWeaponed=True
     SecondWeaponPickup="You found another tentacle!"
     AmmoName=Class'UnrealShare.RocketCan'
     PickupAmmoCount=60
     FireOffset=(X=12.000000,Y=-10.000000,Z=-7.000000)
     ProjectileClass=Class'UnrealShare.Grenade'
     AltProjectileClass=Class'Pack6.SeekerGrenade'
     FireSound=Sound'UnrealShare.Tentacle.TentSpawn'
     AutoSwitchPriority=7
     InventoryGroup=7
     PickupMessage="You got the GrenadeTentacle."
     ItemName="GrenadeTentacle"
     PlayerViewOffset=(X=4.200000,Y=-3.000000,Z=-2.000000)
     PlayerViewMesh=LodMesh'UnrealShare.Tentacle1'
     PlayerViewScale=0.020000
     PickupViewMesh=LodMesh'UnrealShare.Tentacle1'
     PickupViewScale=0.500000
     ThirdPersonMesh=LodMesh'UnrealShare.Tentacle1'
     ThirdPersonScale=0.300000
     PickupSound=Sound'UnrealShare.Tentacle.yell1tn'
     Mesh=LodMesh'UnrealShare.Tentacle1'
     DrawScale=0.500000
}
