//=============================================================================
// HeGrenade.
//=============================================================================
class HeGrenade expands GRENADES;

function HurtPPL()
{
	Spawn(Class 'SpriteBallExplosion',,,Location);
	BurnRadius( DamageAmount, DamageRadius, 'exploded', 0, Location);
}

function BurnRadius( float DamageAmount, float DamageRadius, name DamageName, float Momentum, vector HitLocation )
{
	local actor Victims;
	local float damageScale, dist;
	local vector dir;
	
	if( bHurtEntry )
		return;

	bHurtEntry = true;
	foreach VisibleCollidingActors( class 'Actor', Victims, DamageRadius, HitLocation )
	{
		if( Victims != self )
		{
			dir = Victims.Location - HitLocation;
			dist = FMax(1,VSize(dir));
			dir = dir/dist; 
			damageScale = 1 - FMax(0,(dist - Victims.CollisionRadius)/DamageRadius);
			Victims.TakeDamage
			(
				damageScale * DamageAmount,
				Instigator, 
				Victims.Location - 0.5 * (Victims.CollisionHeight + Victims.CollisionRadius) * dir,
				(damageScale * Momentum * dir),
				DamageName
			);
			if( Victims.bIsPawn )
				AddFireFor(Victims);
		} 
	}
	bHurtEntry = false;
}
function AddFireFor( Actor Other )
{
	local BurningThing bt;
	
	if ((Other.Region.Zone.bWaterZone && !Other.Region.Zone.bDestructive) || Other.IsA('Projectile')) Return;
	
	if( Other.bIsPawn && Pawn(Other).FindInventoryType(class'ElemSuit')!=None )
		Return;
	ForEach AllActors(class'BurningThing',bt)
	{
		if( bt.Owner==Other )
		{
			bt.Heat+=0.1;
			Return;
		}
	}
	
	bt = Spawn(class'BurningThing',Other);
	bt.Heat = 20;
	bt.Burner = Instigator;
}

defaultproperties
{
     DamageRadius=500.000000
     DamageAmount=400
     bCanHaveMultipleCopies=True
     bActivatable=True
     bDisplayableInv=True
     bRotatingPickup=True
     PickupMessage="You got a He Grenade"
     ItemName="He-Grenade"
     RespawnTime=20.000000
     PickupViewMesh=Mesh'Pack6.FragGrenMesh'
     PickupViewScale=0.100000
     Charge=5
     PickupSound=Sound'UnrealShare.Pickups.GenPickSnd'
     Icon=Texture'Pack6.GrenadeIcon'
     M_Activated=" thrown"
     Texture=Texture'UnrealShare.Skins.aPower1'
     Skin=Texture'UnrealShare.Skins.aPower1'
     Mesh=Mesh'Pack6.FragGrenMesh'
     DrawScale=0.100000
     MultiSkins(0)=Texture'UnrealI.Skins.JBlob1'
     MultiSkins(1)=Texture'UnrealShare.Skins.aPower1'
     CollisionRadius=5.000000
     CollisionHeight=7.500000
     RotationRate=(Pitch=1000,Roll=2000)
}
