//=============================================================================
// HoldFlash.
// Hidden actor, for use of flash bang!
//=============================================================================
class HoldFlash expands Actor;

var float TimeLeft;

replication
{
	// Things the server should send to the client.
	unreliable if( Role==ROLE_Authority )
		TimeLeft;
}

simulated function Tick( float DeltaTime )
{
	TimeLeft-=DeltaTime;
	
	if( !bNetOwner && Level.NetMode==NM_Client )
		Return;
	if( (TimeLeft<=0 || Owner==None || Owner.Class==None || Owner.bDeleteMe || PlayerPawn(Owner)==None) ) Destroy();
	
	if( PlayerPawn(Owner).Player!=None && PlayerPawn(Owner).Player.Console!=None )
		PlayerPawn(Owner).ClientFlash(100*TimeLeft,vect(1000,1000,1000)*TimeLeft);
}

defaultproperties
{
     bHidden=True
     Physics=PHYS_Trailer
     RemoteRole=ROLE_SimulatedProxy
}
