//=============================================================================
// IceThing.
//=============================================================================
class IceThing expands WoodenBox;

var() sound Broke;
Auto State Animate
{

	function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
	{
		Instigator = InstigatedBy;
		if (Health<0) Return;
		if ( Instigator != None )
			MakeNoise(1.0);
		bBobbing = false;
		Health -= NDamage;
		if (Health <0)
			Destroy();
		else 
		{
			SetPhysics(PHYS_Falling);
			Momentum.Z = 1000;
			Velocity=Momentum*0.016;
		}
	}
}
simulated function skinnedFrag(class<fragment> FragType, texture FragSkin, vector Momentum, float DSize, int NumFrags) 
{
	local int i;
	local actor A, Toucher;
	local Fragment s;

	if ( bOnlyTriggerable )
		return; 
	if (Event!='')
		foreach AllActors( class 'Actor', A, Event )
			A.Trigger( Toucher, pawn(Toucher) );
	if ( Region.Zone.bDestructive )
	{
		Destroy();
		return;
	}
	for (i=0 ; i<NumFrags ; i++) 
	{
		s = Spawn( FragType, Owner);
		s.CalcVelocity(Momentum/100,0);
		s.Skin = FragSkin;
		s.DrawScale = DSize*0.5+0.7*DSize*FRand();
		s.Style=STY_Translucent;
	}
}
function Destroyed()
{
	skinnedFrag(class'GlassFragments',FireTexture'Pack6.IceEffect',vect(0,0,100),0.8,Rand(3)+6);
	PlaySound(Broke);
	Super.Destroyed();
}

defaultproperties
{
     Broke=Sound'UnrealShare.General.BreakGlass'
     Health=30
     PushSound=None
     EndPushSound=None
     LifeSpan=20.000000
     Style=STY_Translucent
     Texture=FireTexture'Pack6.IceEffect'
     bMeshEnviroMap=True
     CollisionRadius=1.000000
     CollisionHeight=1.000000
}
