//=============================================================================
// LuckyCharm.
//=============================================================================
class LuckyCharm expands Pickup;

var bool bAbsordingNow;

function ArmorImpactEffect(vector HitLocation)
{ 
	if ( Owner.IsA('Pawn') && bAbsordingNow )
		Pawn(Owner).ClientMessage("Lucky!");
	Charge = 1;
}
function int ArmorAbsorbDamage(int Damage, name DamageType, vector HitLocation)
{
	if( bAbsordingNow )
	{
		Pawn(Owner).ClientMessage("Lucky! Saved you from"@Damage@"damage");
		Spawn(class'ParticleBurst',,,HitLocation).DrawScale = 0.1;
		Return 0;
	}
	else Return Super.ArmorAbsorbDamage(Damage,DamageType,HitLocation);
}
function int ReduceDamage( int Damage, name DamageType, vector HitLocation )
{
	if( bAbsordingNow )
	{
		Pawn(Owner).ClientMessage("Lucky! Saved you from"@Damage@"damage");
		Spawn(class'ParticleBurst',,,HitLocation).DrawScale = 0.1;
		Return 0;
	}
	else Return Super.ReduceDamage(Damage,DamageType,HitLocation);
}
function inventory PrioritizeArmor( int Damage, name DamageType, vector HitLocation )
{
	if( bAbsordingNow )
		Return Self;
	else Return Super.PrioritizeArmor(Damage,DamageType,HitLocation );
}
function PickupFunction(Pawn Other)
{
	SetTimer(0.5,True);
}
function Timer()
{
	local inventory inv2;
	
	if ( Owner.IsA('Pawn') )
	{
		if( (Pawn(Owner).Health>Pawn(Owner).Default.Health/5 && FRand()<0.2) || (Pawn(Owner).Health<=Pawn(Owner).Default.Health/5 && FRand()<0.7) )
			bAbsordingNow = True;
		else bAbsordingNow = False;
		Charge = 1;
		if( Pawn(Owner).Health<Pawn(Owner).Default.Health && FRand()<0.2 )
			Pawn(Owner).Health+=Rand(10);
		for( Inv2=Pawn(Owner).Inventory; Inv2!=None; Inv2=Inv2.Inventory ) 
		{
			if( Inv2.IsA('Ammo') && Ammo(Inv2).AmmoAmount<Ammo(Inv2).MaxAmmo && FRand()<0.1 )
				Ammo(Inv2).AmmoAmount+=Rand(10);
			else if( !Inv2.IsA('LuckyCharm') && !Inv2.IsA('Ammo') && Inv2.Charge<Inv2.Default.Charge
			 && FRand()<0.1 )
				Inv2.Charge+=Rand(10);
		}
	}
}
auto state Pickup
{
	function bool ValidTouch( actor Other )
	{
		local Actor A;

		if( Other.bIsPawn && (Pawn(Other).Health > 0) && Level.Game.PickupQuery(Pawn(Other), self) )
		{
			if( Event != '' )
				foreach AllActors( class 'Actor', A, Event )
					A.Trigger( Other, Other.Instigator );
			return true;
		}
		return false;
	}
	function EndState()
	{
		LifeSpan = 0;
		Super.EndState();
	}
}

defaultproperties
{
     PickupMessage="You found the Lucky Charm"
     PickupViewMesh=LodMesh'UnrealShare.ShieldBeltMesh'
     PickupViewScale=0.300000
     Charge=1
     bIsAnArmor=True
     PickupSound=Sound'UnrealShare.Pickups.BeltSnd'
     Icon=Texture'UnrealShare.Icons.I_ShieldBelt'
     Texture=Texture'UnrealShare.GoldSkin'
     Mesh=LodMesh'UnrealShare.ShieldBeltMesh'
     DrawScale=0.300000
     bMeshEnviroMap=True
     CollisionRadius=8.000000
     CollisionHeight=2.000000
}
