//=============================================================================
// LungeHunter.
//=============================================================================
class LungeHunter expands SkaarjBerserker;

var float C;
var vector CheckItOut;
var Actor Node;
var(Sounds) sound ArmorImpact;
var() texture FireEffectTexture[4];
var() bool bHasFireEffect;
var() int EffectCharge;
var NonEffect Ef;

function PreBeginPlay()
{
	Super.PreBeginPlay();
	
	if(bHasFireEffect && !bDeleteMe)
	{
		Ef = Spawn(class'NonEffect2',Self,,Location, Rotation);
		Ef.Mesh = Mesh;
		Ef.DrawScale = Drawscale;
		Ef.SetOwner(Self);
		Ef.Texture = FireEffectTexture[Rand(4)];
	}
}
function Destroyed()
{
	if( Ef!=None )
		Ef.Destroy();
	Super.Destroyed();
}
state RangedAttack
{
ignores SeePlayer, HearNoise;
	
	function PlayRangedAttack()
	{
		DoLunge();
	}
}
function PlayRangedAttack()
{
	if( FRand()<0.3 ) Super.PlayRangedAttack();
	else DoLunge();
}
function PlayMovingAttack()
{
	if( FRand()<0.3 ) Super.PlayMovingAttack();
	else DoLunge();
}
function DoLunge()
{
	GoToState('Lunging');
}
function Tick(float DeltaTime)
{
	local Pawn P;
	
	C+=DeltaTime;
	if( C>=4 )
	{
		C=0;
		CheckVisibleEnemys();
	}
}
function bool CheckVisibleEnemys()
{
	local Pawn P;
	local vector HitL,HitN;
	local Actor TraceActor;
	
	For( P=Level.PawnList; P!=None; P=P.NextPawn )
	{
		if( VSize(P.Location-Location)<3000 && FlockPawn(P)==None &&
		 FlockMasterPawn(P)==None && P.Health>0 && !P.bHidden )
		{
			TraceActor = Trace(HitL,HitN,P.Location,Location);
			if( (TraceActor==P || TraceActor==None) && SetEnemy(P) )
				Return True;
		}
	}
	Return false;
}
function bool SetEnemy( Pawn NewEnemy )
{
	Return SetRealEnemy(NewEnemy,Self,'Wandering','Attacking');
}
function bool SetRealEnemy( Pawn NewEnemy, Pawn Hater, name ReadyStates, name AttackState )
{
	local EAttitude Temp;
	local Pawn P;
	
	if( NewEnemy==None || NewEnemy.bDeleteMe || NewEnemy.Health<=0 || NewEnemy==Self ) Return false;
	if( FlockPawn(NewEnemy)!=None || FlockMasterPawn(NewEnemy)!=None ) Return false;
	
	if( !NewEnemy.bIsPlayer )
	{
		if( ScriptedPawn(Hater)!=None )
			Temp = ScriptedPawn(Hater).AttitudeToCreature(NewEnemy);
		else if( NewEnemy.Class==Hater.Class )
			Temp = ATTITUDE_Friendly;
		else Temp = ATTITUDE_Hate;
	}
	else Temp = Hater.AttitudeToPlayer;
	
	if( Temp~=ATTITUDE_Friendly || Temp~=ATTITUDE_Follow || (Temp~=ATTITUDE_Ignore && FRand()<0.6) )
		Return False;
	if( ScriptedPawn(Hater)!=None && ScriptedPawn(Hater).OldEnemy!=NewEnemy )
		ScriptedPawn(Hater).OldEnemy=NewEnemy;
	Hater.Enemy = NewEnemy;
	For( P=Level.PawnList; P!=None; P=P.NextPawn )
	{
		if( LungeHunter(P)!=None && P.Health>0 && P.Enemy==None && VSize(P.Location-Location)<3000 && !P.IsInState('GetOverHere') )
		{
			LungeHunter(P).CheckItOut = Location;
			LungeHunter(P).GoToState('GetOverHere');
		}
	}
	if( !IsInState('Attacking') && !IsInState('RangedAttack') && !IsInState('MeleeAttack') 
	 && !IsInState('TakeHit') && !IsInState('FallingState') && !IsInState('Hunting')
	 && !IsInState('TacticalMove') )
		Hater.GoToState(AttackState);
	if( NewEnemy.bIsPlayer && ScriptedPawn(Hater)!=None && !ScriptedPawn(Hater).bFirstHatePlayer
	 && (ScriptedPawn(Hater).FirstHatePlayerEvent != '') )
		ScriptedPawn(Hater).TriggerFirstHate();
	Return True;
}
function eAttitude AttitudeToCreature(Pawn Other)
{
	if ( !Other.IsA('LungeHunter') )
		return ATTITUDE_Hate;
	else
		return ATTITUDE_Friendly;
}

State Lunging
{
ignores SeePlayer, EnemyNotVisible, HearNoise, HitWall, Falling, WarnTarget;

	function BeginState()
	{
		local float dist;
		
		dist = VSize(Target.Location - Location + vect(0,0,1) * (CollisionHeight - Target.CollisionHeight));
		PlaySound(Lunge, SLOT_Interact);
		Velocity = 900 * (Target.Location - Location)/dist; //instant acceleration in that direction 
		Velocity.Z += 1.2 * dist;
		if (Physics != PHYS_Swimming)
		 	SetPhysics(PHYS_Falling);
		Enable('Bump');
		PlayAnim('Lunge');
		Enable('AnimEnd');
	}
	function Bump (Actor Other)
	{
		if ( AttackSuccess || (AnimSequence != 'Lunge') )
			return;
		else		
			LungeDamageTarget();

		if (!AttackSuccess && Pawn(Other) != None) //always add momentum
			Pawn(Other).AddVelocity((60000.0 * (Normal(Other.Location - Location)))/Other.Mass);
	}
	function Tick(float DeltaTime)
	{
		SetRotation(rotator(Enemy.Location - Location));
		ViewRotation=rotator(Enemy.Location - Location);
		Velocity = vector(ViewRotation)*1000;
		Acceleration = vector(ViewRotation)*1000;
	}
	function LungeDamageTarget()
	{
		If (MeleeDamageTarget(LungeDamage, (LungeDamage * 2000 * Normal(Target.Location - Location))))
			PlaySound(Slice, SLOT_Interact);
	}
	event AnimEnd()
	{
		GoToState('Attacking');
	}
}
function DoJump()
{
	if ( Physics == PHYS_Walking )
	{
		if ( Role == ROLE_Authority )
			PlaySound(Sound'UnrealI.Skaarj.SKPJump1', SLOT_Talk, 1.5, true, 1200, 1.0 );
		if ( (Level.Game != None) && (Level.Game.Difficulty > 0) )
			MakeNoise(0.1 * Level.Game.Difficulty);
		PlayInAir();
		Velocity.Z = JumpZ;
		if ( Base != Level )
			Velocity.Z += Base.Velocity.Z; 
		SetPhysics(PHYS_Falling);
	}
}
State GetOverHere
{
	event HitWall( vector HitNormal, actor Other )
	{
		DoJump();
	}
	function Bump( Actor Other )
	{
		if( Other.bIsPawn && LungeHunter(Other)==None )
			Global.Bump(Other);
		else DoJump();
	}
Begin:
	Sleep(FRand()*3);
	PlayRunning();
	CheckVisibleEnemys();
	if( pointReachable(CheckItOut) )
	{
		MoveTo(CheckItOut,GroundSpeed);
		Acceleration = vect(0,0,0);
		PlayWaiting();
		Sleep(1);
		GoToState('wandering');
	}
	Node = FindPathTo(CheckItOut);
	if( Node==None )
	{
		MoveTo(CheckItOut,GroundSpeed);
		Acceleration = vect(0,0,0);
		PlayWaiting();
		Sleep(1);
		GoToState('wandering');
	}
	MoveToward(Node,GroundSpeed);
	Sleep(0.1);
	GoTo 'Begin';
}
function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
{
	local int TheDamage;
	
	TheDamage = Damage;
	if( Ef!=None && Default.EffectCharge>0 )
	{
		TheDamage-=EffectCharge;
		if( TheDamage<0 ) TheDamage=0;
		EffectCharge-=Damage;
		Ef.Fatness = 255;
		PlaySound(ArmorImpact, SLOT_None, 2.7);
		if ( EffectCharge<=0 ) Ef.Destroy();
	}
	if ( !bIsPlayer && Inventory!=None )
		Super.TakeDamage(Inventory.ReduceDamage(TheDamage, DamageType, HitLocation),
		instigatedBy,hitlocation,momentum,damageType);
	else Super.TakeDamage(TheDamage,instigatedBy,hitlocation,momentum,damageType);
}

defaultproperties
{
     ArmorImpact=Sound'UnrealShare.Pickups.Sbelthe2'
     FireEffectTexture(0)=FireTexture'UnrealShare.Belt_fx.ShieldBelt.BlueShield'
     FireEffectTexture(1)=FireTexture'UnrealShare.Belt_fx.ShieldBelt.Greenshield'
     FireEffectTexture(2)=FireTexture'UnrealShare.Belt_fx.ShieldBelt.N_Shield'
     FireEffectTexture(3)=FireTexture'UnrealShare.Belt_fx.ShieldBelt.RedShield'
     bHasFireEffect=True
     EffectCharge=250
     LungeDamage=104
     SpinDamage=68
     ClawDamage=63
     Orders=wandering
     RangedProjectile=Class'UnrealShare.DAmmo5'
     Skin=Texture'UnrealI.Skins.Skaarjw5'
     DrawScale=0.500000
     Fatness=158
     CollisionRadius=17.500000
     CollisionHeight=23.000000
}
