//=============================================================================
// MadSleeper.
//=============================================================================
class MadSleeper expands SkaarjWarrior;

var(Sounds) sound ScreamSound;

state TacticalMove
{
ignores SeePlayer, HearNoise;

	function PickDestination(bool bNoCharge)
	{
		if ( FRand() < 0.4 )
			GotoState('SleepAttack');
		else
			Super.PickDestination(bNoCharge);
	}
}		
		
State SleepAttack
{
ignores SeePlayer, EnemyNotVisible, HearNoise, KilledBy, Bump, HitWall, HeadZoneChange,SetEnemy,
 FootZoneChange, ZoneChange, Falling, WarnTarget, PlayTakeHit;
	function PutAllToSleep()
	{
		local ParalyseThing Pa;
		local bool bNoShit;
		local Pawn P;
		
		ForEach VisibleActors(class'Pawn',P,2000)
		{
			if( P.FindInventoryType(class'ParalSuit')!=None )
				GoTo 'GoGo1';
			if( !P.IsA('MadSleeper') )
			{
				bNoShit=False;
				ForEach AllActors(class'ParalyseThing',Pa)
					if( P==Pa.Burner && Pa.IsA('SleepyTime') )
						bNoShit=True;
				if( !bNoShit )
				{
					P.ClientMessage("Uah!! That skaarj makes me so sleepy, guess, I'll take a nap");
					Pa = Spawn(class'SleepyTime');
					Pa.SetOwner(Self);
					Pa.Burner = P;
					Pa.Heat=10;
				}
			}
			GoGo1:
		}
	}
	function MakeReport()
	{
		local Pawn P;
		
		ForEach VisibleActors(class'Pawn',P,2000)
			if( P.bIsPlayer )
				P.ClientMessage("Dam stupid skaarj did go asleep");
	}
	function Timer()
	{
		if( Health<Default.Health )
			Health++;
	}
Begin:
	PlayAnim('Death2');
	MoveTo(Location,GroundSpeed);
	FinishAnim();
	PlaySound(ScreamSound, SLOT_Talk, 2 * TransientSoundVolume);
	PlaySound(ScreamSound, SLOT_None, 2 * TransientSoundVolume);
	PlaySound(ScreamSound, SLOT_None, 2 * TransientSoundVolume);
	PlaySound(ScreamSound, SLOT_None, 2 * TransientSoundVolume);
	AmbientSound=Sound'snore1k';
	if( FRand()<0.6 )
	{
		PutAllToSleep();
		Sleep(0.5);
	}
	else
	{
		SetTimer(0.1,true);
		MakeReport();
		Enemy=None;
		OldEnemy=None;
		Target=None;
		Sleep(20);
		SetTimer(0,false);
	}
	AmbientSound=Sound'UnrealShare.Skaarj.amb1sk';
	PlayAnim('GetUp');
	FinishAnim();
	PlayAnim('Lunge');
	FinishAnim();
	GoToState('Attacking');
}
function SpawnTwoShots()
{
	local rotator FireRotation;
	local vector X,Y,Z, projStart;

	GetAxes(Rotation,X,Y,Z);
	MakeNoise(1.0);
	projStart = Location + 0.9 * CollisionRadius * X + 0.9 * CollisionRadius * Y + 0.4 * CollisionHeight * Z;
	spawn(RangedProjectile,self,'',projStart,rotator(Target.Location-projStart));
		
	projStart = projStart - 1.8 * CollisionRadius * Y;
	spawn(RangedProjectile,self,'',projStart,rotator(Target.Location-projStart));
}
function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
{
	if ( !bIsPlayer && Inventory!=None )
		Super.TakeDamage(Inventory.ReduceDamage(Damage, DamageType, HitLocation),
		instigatedBy,hitlocation,momentum,damageType);
	else Super.TakeDamage(Damage,instigatedBy,hitlocation,momentum,damageType);
}
function bool SetEnemy( Pawn NewEnemy )
{
	Return SetRealEnemy(NewEnemy,Self,'Waiting','Attacking');
}
function bool SetRealEnemy( Pawn NewEnemy, Pawn Hater, name ReadyStates, name AttackState )
{
	local EAttitude Temp;
	
	if( NewEnemy==None || NewEnemy.bDeleteMe || NewEnemy.Health<=0 || NewEnemy==Self ) Return false;
	if( FlockPawn(NewEnemy)!=None || FlockMasterPawn(NewEnemy)!=None ) Return false;
	
	if( !NewEnemy.bIsPlayer )
	{
		if( ScriptedPawn(Hater)!=None )
			Temp = ScriptedPawn(Hater).AttitudeToCreature(NewEnemy);
		else if( NewEnemy.Class==Hater.Class )
			Temp = ATTITUDE_Friendly;
		else Temp = ATTITUDE_Hate;
	}
	else Temp = Hater.AttitudeToPlayer;
	
	if( Temp~=ATTITUDE_Friendly || Temp~=ATTITUDE_Follow || (Temp~=ATTITUDE_Ignore && FRand()<0.6) )
		Return False;
	if( ScriptedPawn(Hater)!=None && ScriptedPawn(Hater).OldEnemy!=NewEnemy )
		ScriptedPawn(Hater).OldEnemy=NewEnemy;
	Hater.Enemy = NewEnemy;
	if( !IsInState('Attacking') && !IsInState('RangedAttack') && !IsInState('MeleeAttack') 
	 && !IsInState('TakeHit') && !IsInState('FallingState') && !IsInState('Hunting')
	 && !IsInState('TacticalMove') )
		Hater.GoToState(AttackState);
	if( NewEnemy.bIsPlayer && ScriptedPawn(Hater)!=None && !ScriptedPawn(Hater).bFirstHatePlayer
	 && (ScriptedPawn(Hater).FirstHatePlayerEvent != '') )
		ScriptedPawn(Hater).TriggerFirstHate();
	Return True;
}

defaultproperties
{
     ScreamSound=Sound'UnrealShare.Skaarj.chalnge1s'
     Health=500
     Texture=IceTexture'XFX.flareZw'
     bMeshEnviroMap=True
     SoundRadius=16
     SoundVolume=255
}
