//=============================================================================
// MasterArrow.
//=============================================================================
class MasterArrow expands Arrow;

function ProcessTouch (Actor Other, vector HitLocation)
{
	if ((Other != instigator) && (MasterArrow(Other) == none)) 
	{
		Explode(HitLocation,Normal(HitLocation-Other.Location));
		if ( Role == ROLE_Authority )
			Other.TakeDamage(damage, instigator,HitLocation,
				(MomentumTransfer * Normal(Velocity)), 'shot');
		Destroy();
	}
}
function Explode(vector HitLocation, vector HitNormal)
{
	local vector start;
	local Arrow A;
	local int i;

	HurtRadius(damage, 150, 'exploded', MomentumTransfer, HitLocation);	
	start = Location + 10 * HitNormal;
	if ( Role == ROLE_Authority )
		for (i = 0; i< 20; i++)
			Spawn( class'Arrow',,,Start,RotRand(true));
}

defaultproperties
{
     MaxSpeed=3000.000000
     Damage=160.000000
     Texture=Texture'UnrealShare.Effects.Arc1'
     DrawScale=3.000000
     Fatness=255
     bMeshEnviroMap=True
}
