//=============================================================================
// MissileE.
//=============================================================================
class MissileE expands SeekingRocket;

var Actor Enemy;
var vector RealLoc;

replication
{
	// Things the server should send to the client.
	unreliable if( Role==ROLE_Authority )
		Enemy,RealLoc;
}

simulated function Tick(float DeltaTime)
{
	local SpriteSmokePuff b;
	
	Count += DeltaTime;
	if ( (Count>(SmokeRate+FRand()*(SmokeRate+NumExtraRockets*0.035))) && (Level.NetMode!=NM_DedicatedServer) ) 
	{
		b = Spawn(class'SpriteSmokePuff');
		b.RemoteRole = ROLE_None;		
		Count=0.0;
	}
	SetRotation(rotator(Enemy.Location - Location));
	Velocity = vector(Rotation)*speed;
}
auto state Flying
{
	simulated function Timer()
	{
		if( Level.NetMode!=NM_Client )
			RealLoc = Location;
		else
			SetLocation(RealLoc);
	}
	simulated function ZoneChange( Zoneinfo NewZone )
	{
		local waterring w;
		
		if (!NewZone.bWaterZone || bHitWater) Return;

		bHitWater = True;
		if ( Level.NetMode != NM_DedicatedServer )
		{
			w = Spawn(class'WaterRing',,,,rot(16384,0,0));
			w.DrawScale = 0.2;
			w.RemoteRole = ROLE_None;
			PlayAnim( 'Still', 3.0 );
		}		
		Velocity=0.6*Velocity;
	}
	function BlowUp(vector HitLocation, RingExplosion r)
	{
		HurtRadius(Damage,900.0, 'exploded', MomentumTransfer, HitLocation );
		MakeNoise(1.0);
	}
	simulated function Explode(vector HitLocation, vector HitNormal)
	{
		local SpriteBallExplosion s;
		local FlameBall FB;

		s = spawn(class'SpriteBallExplosion',,,HitLocation + HitNormal*16);	
 		s.RemoteRole = ROLE_None;
 		s.DrawScale = 3;
 		FB = spawn(class'FlameBall',,,HitLocation + HitNormal*16);	
 		FB.RemoteRole = ROLE_None;
 		FB.DrawScale = 5;

		BlowUp(HitLocation,None);

 		Destroy();
	}
	function BeginState()
	{
		initialDir = vector(Rotation);
		if ( Role == ROLE_Authority )	
			Velocity = speed*initialDir;
		Acceleration = initialDir*50;
		PlaySound(SpawnSound, SLOT_None, 2.3);	
		PlayAnim( 'Armed', 0.2 );
		if (Region.Zone.bWaterZone)
		{
			bHitWater = True;
			Velocity=0.6*Velocity;
		}
		SetTimer(0.3,true);
	}
}

defaultproperties
{
     Damage=450.000000
     RemoteRole=ROLE_SimulatedProxy
     DrawScale=0.550000
}
