//=============================================================================
// MissileL.
//=============================================================================
class MissileL expands Pack6Weps;

function PlayIdleAnim()
{
	PlayAnim('Idle',1.0,0.0);
}
function Projectile ProjectileFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
	local Vector Start, X,Y,Z;
	local Pawn PawnOwner;
	local MissileE ME;

	PawnOwner = Pawn(Owner);
	Owner.MakeNoise(PawnOwner.SoundDampening);
	GetAxes(PawnOwner.ViewRotation,X,Y,Z);
	Start = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = PawnOwner.AdjustAim(ProjSpeed, Start, AimError, True, bWarn);	
	if( PawnOwner.IsA('PlayerPawn') )
	{
		ME = Spawn(class'MissileP',,,Start,AdjustedAim);
		PlayerPawn(PawnOwner).ViewTarget = ME;
	}
	else
	{
		ME = Spawn(class'MissileE',,,Start,AdjustedAim);
		ME.Enemy = PawnOwner.Enemy;
	}
}
function PlayFiring()
{
	PlayAnim('Fire',1.0,0.0);
	if( Pawn(Owner).bIsPlayer )
		AmmoType.AmmoAmount=0;
}

function PlayAltFiring()
{
	PlayAnim('Fire',1.0,0.0);
	if( Pawn(Owner).bIsPlayer )
		AmmoType.AmmoAmount=0;
}
state NormalFire
{
	function Fire(float F) 
	{
	}
	function AltFire(float F) 
	{
	}

Begin:
	FinishAnim();
	Sleep(5);
	Finish();
}

////////////////////////////////////////////////////////
state AltFiring
{
	function Fire(float F) 
	{
	}

	function AltFire(float F) 
	{
	}

Begin:
	FinishAnim();
	Sleep(5);
	Finish();
}
function Fire( float Value )
{
	if ((Pawn(Owner).bIsPlayer && AmmoType.UseAmmo(1)) || !Pawn(Owner).bIsPlayer)
	{
		GotoState('NormalFire');
		if ( PlayerPawn(Owner) != None )
			PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
		bPointing=True;
		PlayFiring();
		if ( !bRapidFire && (FiringSpeed > 0) )
			Pawn(Owner).PlayRecoil(FiringSpeed);
		ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);
		if ( Owner.bHidden )
			CheckVisibility();
	}
}

function AltFire( float Value )
{
	if ((Pawn(Owner).bIsPlayer && AmmoType.UseAmmo(1)) || !Pawn(Owner).bIsPlayer)
	{
		GotoState('AltFiring');
		if ( PlayerPawn(Owner) != None )
			PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
		bPointing=True;
		PlayAltFiring();
		if ( !bRapidFire && (FiringSpeed > 0) )
			Pawn(Owner).PlayRecoil(FiringSpeed);
		ProjectileFire(AltProjectileClass, AltProjectileSpeed, bAltWarnTarget);
		if ( Owner.bHidden )
			CheckVisibility();
	}
}

defaultproperties
{
     AmmoName=Class'Pack6.RocketCan2'
     PickupAmmoCount=1
     FireSound=Sound'UnrealShare.Eightball.EightAltFire'
     AltFireSound=Sound'UnrealShare.Eightball.EightAltFire'
     AutoSwitchPriority=10
     InventoryGroup=10
     PickupMessage="You got the MissileLauncher"
     ItemName="MissileLauncher"
     PlayerViewOffset=(X=1.900000,Z=-1.890000)
     PlayerViewMesh=LodMesh'UnrealShare.EightB'
     PlayerViewScale=1.400000
     PickupViewMesh=LodMesh'UnrealShare.EightPick'
     ThirdPersonMesh=LodMesh'UnrealShare.8Ball3rd'
     ThirdPersonScale=3.000000
     PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
}
