//=============================================================================
// Pack6Pawns.
//=============================================================================
class Pack6Pawns expands ScriptedPawn
	Abstract;

var(Sounds) sound ArmorImpact;
var() texture FireEffectTexture;
var() bool bHasFireEffect;
var() int EffectCharge;
var() class<RingExplosion4> TraceEffect;
var() class<Effects> TraceHitEffect;
var NonEffect Ef;

function PreBeginPlay()
{
	Super.PreBeginPlay();
	
	if(bHasFireEffect && !bDeleteMe)
	{
		Ef = Spawn(class'NonEffect',Self,,Location, Rotation);
		Ef.Mesh = Mesh;
		Ef.DrawScale = Drawscale;
		Ef.SetOwner(Self);
		Ef.Texture = FireEffectTexture;
	}
}
function Destroyed()
{
	if( Ef!=None )
		Ef.Destroy();
	Super.Destroyed();
}
simulated function DrawEffect(vector HitLocation,vector HitNormal,vector StartLoc)
{
	local RingExplosion4 Smoke;
	local vector SmokeLocation;
	local float Distance;
	local rotator SmokeRotation;
	
	Distance = VSize(HitLocation - StartLoc);
	Distance /= 20;
	if( Distance>15 ) Distance=16;
	SmokeLocation = StartLoc - HitLocation;
	SmokeLocation *= -1;
	SmokeLocation /= Distance;
	SmokeRotation = rotator(HitLocation-StartLoc);
	Smoke = Spawn(TraceEffect,,,StartLoc,SmokeRotation);
	Smoke.MoveAmount = SmokeLocation;
	Smoke.NumPuffs = Distance;
	if( TraceHitEffect!=None )
		Spawn(TraceHitEffect,,,HitLocation,rotator(HitNormal));
}
function bool SetEnemy( Pawn NewEnemy )
{
	if( Health<=0 ) Return false;
	Return SetRealEnemy(NewEnemy,Self,'Waiting','Attacking');
}
function bool SetRealEnemy( Pawn NewEnemy, Pawn Hater, name ReadyStates, name AttackState )
{
	local EAttitude Temp;
	
	if( NewEnemy==None || NewEnemy.bDeleteMe || NewEnemy.Health<=0 || NewEnemy==Self ) Return false;
	if( FlockPawn(NewEnemy)!=None || FlockMasterPawn(NewEnemy)!=None ) Return false;
	
	if( !NewEnemy.bIsPlayer )
	{
		if( ScriptedPawn(Hater)!=None )
			Temp = ScriptedPawn(Hater).AttitudeToCreature(NewEnemy);
		else if( NewEnemy.Class==Hater.Class )
			Temp = ATTITUDE_Friendly;
		else Temp = ATTITUDE_Hate;
	}
	else Temp = Hater.AttitudeToPlayer;
	
	if( Temp~=ATTITUDE_Friendly || Temp~=ATTITUDE_Follow || (Temp~=ATTITUDE_Ignore && FRand()<0.6) )
		Return False;
	if( ScriptedPawn(Hater)!=None && ScriptedPawn(Hater).OldEnemy!=NewEnemy )
		ScriptedPawn(Hater).OldEnemy=NewEnemy;
	Hater.Enemy = NewEnemy;
	if( !IsInState('Attacking') && !IsInState('RangedAttack') && !IsInState('MeleeAttack') 
	 && !IsInState('TakeHit') && !IsInState('FallingState') && !IsInState('Hunting')
	 && !IsInState('TacticalMove') )
		Hater.GoToState(AttackState);
	if( NewEnemy.bIsPlayer && ScriptedPawn(Hater)!=None && !ScriptedPawn(Hater).bFirstHatePlayer
	 && (ScriptedPawn(Hater).FirstHatePlayerEvent != '') )
		ScriptedPawn(Hater).TriggerFirstHate();
	Return True;
}
function rotator RRRand( rotator DaRot , rotator MissAmount )
{
	local rotator Roti;
	
	Roti = DaRot;
	Roti.Roll += Rand(MissAmount.Roll)-MissAmount.Roll/2;
	Roti.Yaw += Rand(MissAmount.Yaw)-MissAmount.Roll/2;
	Roti.Pitch += Rand(MissAmount.Pitch)-MissAmount.Roll/2;
	Return Roti;
}
function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
{
	local int TheDamage;
	
	TheDamage = Damage;
	if( Ef!=None && Default.EffectCharge>0 )
	{
		TheDamage-=EffectCharge;
		if( TheDamage<0 ) TheDamage=0;
		EffectCharge-=Damage;
		Ef.Fatness = 255;
		PlaySound(ArmorImpact, SLOT_None, 2.7);
		if ( EffectCharge<=0 ) Ef.Destroy();
	}
	if ( !bIsPlayer && Inventory!=None )
		Super.TakeDamage(Inventory.ReduceDamage(TheDamage, DamageType, HitLocation),
		instigatedBy,hitlocation,momentum,damageType);
	else Super.TakeDamage(TheDamage,instigatedBy,hitlocation,momentum,damageType);
}
function bool CheckVisibleEnemys()
{
	local Pawn P;
	local vector HitL,HitN;
	local Actor TraceActor;
	
	For( P=Level.PawnList; P!=None; P=P.NextPawn )
	{
		if( VSize(P.Location-Location)<3000 && FlockPawn(P)==None &&
		 FlockMasterPawn(P)==None && P.Health>0 && !P.bHidden )
		{
			TraceActor = Trace(HitL,HitN,P.Location,Location);
			if( (TraceActor==P || TraceActor==None) && SetEnemy(P) )
				Return True;
		}
	}
	Return false;
}

defaultproperties
{
}
