//=============================================================================
//  __           __
// |\ \   __    / /____ _____    ___
// \ \ \ /  \  / // __ \\  __ \/<__ \
//  \ \ | /\ \/ //\  __/ \   _/\/__> \
//   \ \_/_ \__/ \ \____\ \__\ /<  __/
//    \/_/ \/_/   \/____/\/__/ \ \___\
// Pack6Weps.                   \/__/
//=============================================================================
class Pack6Weps expands Weapon;

var() class<RingExplosion4> TraceEffect;
var() class<Effects> TraceHitEffect;
var() bool bDualWeaponed;
var() string SecondWeaponPickup;
var Pack6Weps MySecondWeapon,OwnerGun;
var bool bIsMySecondWeapon;
var travel bool bGotSecondWeaponToo;

replication
{
	// Things that server should send for client
	reliable if( Role==ROLE_Authority && bNetOwner )
		bDualWeaponed;
	reliable if( Role==ROLE_Authority && bNetOwner && bDualWeaponed )
		MySecondWeapon,bIsMySecondWeapon;
}
function TravelPostAccept()
{
	Super.TravelPostAccept();
	
	if( bDualWeaponed && MySecondWeapon==None && bGotSecondWeaponToo )
	{
		MySecondWeapon=Spawn(Class);
		MySecondWeapon.AmmoType = AmmoType;
		MySecondWeapon.AmmoName = AmmoName;
		MySecondWeapon.SetOwner(Owner);
		MySecondWeapon.BecomeItem();
		MySecondWeapon.OwnerGun=Self;
		MySecondWeapon.BringUp();
		MySecondWeapon.bIsMySecondWeapon = True;
		if( PlayerPawn(Owner)!=None )
			MySecondWeapon.setHand(PlayerPawn(Owner).Handedness);
		else MySecondWeapon.setHand(1);
	}
} // Add weapon after level change (if you got it)!
function DrawEffect(vector HitLocation,vector HitNormal,vector StartLoc,int MaxSmoke)
{
	local RingExplosion4 Smoke;
	local vector SmokeLocation;
	local float Distance;
	local rotator SmokeRotation;
	
	Distance = VSize(HitLocation - StartLoc);
	Distance /= 20;
	if( Distance>MaxSmoke ) Distance=MaxSmoke+1;
	SmokeLocation = StartLoc - HitLocation;
	SmokeLocation *= -1;
	SmokeLocation /= Distance;
	SmokeRotation = rotator(HitLocation-StartLoc);
	Smoke = Spawn(TraceEffect,,,StartLoc,SmokeRotation);
	Smoke.MoveAmount = SmokeLocation;
	Smoke.NumPuffs = Distance;
	Spawn(TraceHitEffect,,,HitLocation,rotator(HitNormal));
}
simulated event RenderOverlays( canvas Canvas )
{
	Super.RenderOverlays(Canvas);
	if( bDualWeaponed && MySecondWeapon!=None )
		RenderSecondW(Canvas);
}
function setHand(float Hand)
{
	if( bIsMySecondWeapon )
	{
		if (Hand==1)
			Super.setHand(-1);
		else if (Hand==0 || Hand==-1) Super.setHand(1);
		else Super.setHand(Hand);
	}
	else
	{
		if( mySecondWeapon!=None )
			mySecondWeapon.setHand(Hand);
		Super.setHand(Hand);
	}
}
simulated event RenderSecondW( canvas Canvas )
{
	local rotator NewRot;
	local bool bPlayerOwner;
	local int Hand;
	local PlayerPawn PlayerOwner;

	if ( bHideWeapon || (Owner == None) || mySecondWeapon==None )
		return;

	PlayerOwner = PlayerPawn(Owner);
	if ( PlayerOwner != None )
	{
		bPlayerOwner = true;
		Hand = PlayerOwner.Handedness;
	}

	if (  (Level.NetMode == NM_Client) && bPlayerOwner && (Hand == 2) )
	{
		mySecondWeapon.bHideWeapon = true;
		return;
	}
	mySecondWeapon.SetLocation( Owner.Location + mySecondWeapon.CalcDrawOffset() );
	NewRot = Pawn(Owner).ViewRotation;
	if ( Hand == 0 )
		newRot.Roll = Default.Rotation.Roll * Hand;
	else
		newRot.Roll = -2 * Default.Rotation.Roll;
	mySecondWeapon.setRotation(newRot);
	Canvas.DrawActor(mySecondWeapon, false);
}
function bool HandlePickupQuery( inventory Item )
{
	if (Item.Class == Class)
	{
		if( bDualWeaponed && MySecondWeapon==None && !bIsMySecondWeapon )
		{
			MySecondWeapon=Spawn(Class);
			MySecondWeapon.AmmoType = AmmoType;
			MySecondWeapon.AmmoName = AmmoName;
			MySecondWeapon.SetOwner(Owner);
			MySecondWeapon.BecomeItem();
			MySecondWeapon.BringUp();
			MySecondWeapon.bIsMySecondWeapon = True;
			MySecondWeapon.OwnerGun=Self;
			if( PlayerPawn(Owner)!=None )
				MySecondWeapon.setHand(PlayerPawn(Owner).Handedness);
			else MySecondWeapon.setHand(-1);
			Item.SetRespawn();
			Pawn(Owner).ClientMessage(SecondWeaponPickup,'Pickup');
			bGotSecondWeaponToo = True;
			return true;
		}
		else Return Super.HandlePickupQuery(Item);
	}
	else Return Super.HandlePickupQuery(Item);
}
function inventory SpawnCopy( pawn Other )
{
	local Pack6Weps Checked;
	
	Checked = Pack6Weps(Super.SpawnCopy(Other));
	if( bDualWeaponed && Checked.MySecondWeapon==None && bGotSecondWeaponToo )
	{
		Checked.MySecondWeapon=Spawn(Class);
		Checked.MySecondWeapon.AmmoType = AmmoType;
		Checked.MySecondWeapon.AmmoName = AmmoName;
		Checked.MySecondWeapon.SetOwner(Owner);
		Checked.MySecondWeapon.BecomeItem();
		Checked.MySecondWeapon.OwnerGun=Checked;
		Checked.MySecondWeapon.BringUp();
		Checked.MySecondWeapon.bIsMySecondWeapon = True;
		if( PlayerPawn(Owner)!=None )
			Checked.MySecondWeapon.setHand(PlayerPawn(Owner).Handedness);
		else Checked.MySecondWeapon.setHand(1);
	}
	Return Checked;
}
function Destroyed()
{
	if( MySecondWeapon!=None && MySecondWeapon.Class!=None && !MySecondWeapon.bDeleteMe )
	{
		MySecondWeapon.Destroy();
		MySecondWeapon = None;
	}
	Super.Destroyed();
}

defaultproperties
{
}
