//=============================================================================
// ParalyseEffect.
//=============================================================================
class ParalyseEffect expands GravEffect;

simulated function Tick(float DeltaTime)
{
	if( DrawScale<100 )
		DrawScale+=(DeltaTime*100);
	else DrawScale+=(DeltaTime*200);
	if( DrawScale>400 )
	{
		HurtRadius2(15,2000,'Paralysed',10,Location);
		Destroy();
	}
}

function HurtRadius2( float DamageAmount, float DamageRadius, name DamageName, float Momentum, vector HitLocation )
{
	local actor Victims;
	local float dist;
	local vector dir;
	local ParalyseThing PT;
	
	if( bHurtEntry )
		return;

	bHurtEntry = true;
	foreach VisibleActors( class 'Actor', Victims, DamageRadius, HitLocation )
	{
		if( Victims.bIsPawn && Pawn(Victims).FindInventoryType(class'ParalSuit')!=None )
			GoTo 'GoGo1';
		if( Victims.IsA('Pawn') && Victims.Class!=Owner.Class )
		{
			PT = Spawn(class'ParalyseThing',Owner);
			PT.Heat = 7;
			PT.Burner = Pawn(Victims);
		}
		GoGo1:
	}
	bHurtEntry = false;
}

defaultproperties
{
}
