//=============================================================================
// Phantom.
//=============================================================================
class Phantom expands GhostStalker;

State BallsAround
{
Ignores Tick;

	function BeginState()
	{
		SetLocation(Enemy.Location+VRand()*1000);
		SetPhysics(PHYS_Flying);
		ScaleGlow = 1;
		DesiredSpeed = 0;
		SetCollision(true,false,false);
		bMeshEnviroMap = False;
		Style = STY_Normal;
		bHidden = false;
		SetRotation(rotator(Enemy.Location-Location));
		SetTimer(0.1,true);
	}
	function Timer()
	{
		local int i;
		local vector SpawnVect;
		
		SetRotation(rotator(Enemy.Location-Location));
		For( i=0; i<2; i++ )
		{
			SpawnVect = VRand()*200+Location;
			Spawn(class'BlueProjectile',,,SpawnVect,rotator(Enemy.Location-SpawnVect));
		}
	}
Begin:
	PlaySound(Sound'yell1t',SLOT_None,255,,,0.3);
	TurnToward(Enemy);
	Sleep(5);
	Spawn(Class'ParticleBurst');
	SetLocation(Enemy.Location+VRand()*1000);
	GoToState('AttackStatics');
}
State BounchyBalls
{
	function BeginState()
	{
		SetLocation(Enemy.Location+VRand()*1000);
		SetPhysics(PHYS_Flying);
		ScaleGlow = 3;
		SetCollision(False,false,false);
		bMeshEnviroMap = True;
		Style = STY_Translucent;
		bHidden = true;
		SetTimer(0.4,true);
	}
	function Tick( float DeltaTime )
	{
		if( Enemy==None || Enemy.Class==None || Enemy.bDeleteMe || Enemy.Health<=0 )
		{
			Enemy = None;
			GoToState('Idle');
		}
		if( bHidden )
		{
			ScaleGlow-=DeltaTime/5;
			if( ScaleGlow<=0 )
				bHidden = false;
		}
		else
		{
			ScaleGlow+=DeltaTime/4;
			if( ScaleGlow>=2 )
				GoToState('AttackStatics');
		}
	}
	function Timer()
	{
		Spawn(class'BounchBall').Velocity = (Enemy.Location-Location)*2;
	}
Begin:
	PlaySound(Sound'yell2t',SLOT_None,255,,,0.6);
	MoveV = VRand()*300+Enemy.Location+vect(0,0,600);
	MoveTo(MoveV,AirSpeed);
	GoTo('Begin');
}
State MultiBallZ
{
Ignores Tick;

	function BeginState()
	{
		local int i;
		local vector SpawnVect;
		local Projectile P;
		
		DesiredSpeed = 0;
		SetLocation(Enemy.Location+VRand()*400+vect(0,0,300));
		SetPhysics(PHYS_Flying);
		ScaleGlow = 1;
		SetCollision(true,false,false);
		bMeshEnviroMap = false;
		Style = STY_Normal;
		bHidden = false;
		For( i=0; i<20; i++ )
		{
			SpawnVect = VRand()*700;
			SpawnVect.Z = 0;
			SpawnVect += Enemy.Location+vect(0,0,1000);
			P = Spawn(class'BounchBall',,,SpawnVect);
			if( P!=None ) P.Velocity = (Enemy.Location-SpawnVect)*2;
		}
	}
Begin:
	PlaySound(Sound'yell3t',SLOT_None,255,,,0.4);
	Sleep(2);
	GoToState('AttackStatics');
}
State AttackStatics
{
	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
	{
		if( SetLocation(VRand()*1000+Location) )
			Spawn(class'ParticleBurst');
		if( Damage>100 )
			NextAttackState();
		Global.TakeDamage(Damage,instigatedBy,hitlocation,momentum,damageType);
	}
Begin:
	MoveV = VRand()*1000+Location;
	MoveTo(MoveV,AirSpeed);
	GoTo('Begin');
}

defaultproperties
{
     Health=2500
     NameArticle=" the "
     Texture=FireTexture'UnrealShare.Belt_fx.Invis.Invis'
     DrawScale=1.300000
     MultiSkins(0)=Texture'UnrealShare.Skins.JBoulder1'
     MultiSkins(2)=Texture'UnrealI.Skins.JBlob1'
}
