//=============================================================================
// PlayOwnMus.
//=============================================================================
class PlayOwnMus expands NoLieExp;

var string ToPlay;
var byte SongSection;

replication
{
	// Things the server should send to the client.
	unreliable if( Role==ROLE_Authority && bNetOwner )
		ToPlay,SongSection;
}

simulated function PostBeginPlay()
{
	SetTimer(0.7,false);
}
simulated function Timer()
{
	local playerpawn p;
	local Music ThaMus;

	if( Level.NetMode==NM_Client && !bNetOwner ) Return;
	
	ForEach AllActors(class'PlayerPawn',P)
	{
		if( P.Player!=None && P.Player.Console!=None )
		{
			ThaMus = Music(DynamicLoadObject(ToPlay, class'Music'));
			if( ThaMus==None )
				P.ClientMessage("--== WARNING ==-- Music"@ToPlay@"was not found!");
			else
			{
				P.ClientMessage("Music"@ThaMus@"is now playing!");
				P.Song = ThaMus;
				P.SongSection = SongSection;
				P.Transition = MTRAN_Fade;
				Destroy();
			}
		}
	}
}

defaultproperties
{
     bAlwaysRelevant=False
}
