//=============================================================================
// PowerPistol.
//=============================================================================
class PowerPistol expands Pack6Weps;

// pickup version
#exec MESH IMPORT MESH=AutoMagPickup ANIVFILE=MODELS\pislow_a.3D DATAFILE=MODELS\pislow_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AutoMagPickup X=0 Y=0 Z=0 YAW=64
#exec MESH SEQUENCE MESH=AutoMagPickup SEQ=All  STARTFRAME=0  NUMFRAMES=1
#exec TEXTURE IMPORT NAME=Automa1 FILE=MODELS\pistol.PCX GROUP="Skins"
#exec MESHMAP SCALE MESHMAP=AutoMagPickup X=0.04 Y=0.04 Z=0.08
#exec MESHMAP SETTEXTURE MESHMAP=AutoMagPickup NUM=1 TEXTURE=Automa1

// 3rd person perspective version 
#exec MESH IMPORT MESH=auto3rd ANIVFILE=MODELS\pis3rd_a.3D DATAFILE=MODELS\pis3rd_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=auto3rd X=0 Y=-60 Z=-220 YAW=64 PITCH=0 ROLL=-72
#exec MESH SEQUENCE MESH=auto3rd SEQ=All  STARTFRAME=0  NUMFRAMES=5
#exec MESH SEQUENCE MESH=auto3rd SEQ=Still  STARTFRAME=0  NUMFRAMES=1
#exec MESH SEQUENCE MESH=auto3rd SEQ=Shoot  STARTFRAME=1  NUMFRAMES=4 RATE=30.0
#exec MESH SEQUENCE MESH=auto3rd SEQ=Shot2b  STARTFRAME=1  NUMFRAMES=4 RATE=30.0
#exec MESH SEQUENCE MESH=auto3rd SEQ=Shot2a  STARTFRAME=1  NUMFRAMES=4 RATE=30.0
#exec TEXTURE IMPORT NAME=Automa1 FILE=MODELS\pistol.PCX GROUP="Skins"
#exec OBJ LOAD FILE=textures\FireEffect18.utx PACKAGE=UnrealShare.Effect18
#exec MESHMAP SCALE MESHMAP=auto3rd X=0.02 Y=0.02 Z=0.04
#exec MESHMAP SETTEXTURE MESHMAP=auto3rd NUM=1 TEXTURE=Automa1
#exec MESHMAP SETTEXTURE MESHMAP=auto3rd NUM=0 TEXTURE=UnrealShare.Effect18.FireEffect18

//  player view version
#exec MESH IMPORT MESH=AutoMagL ANIVFILE=MODELS\pistol_a.3D DATAFILE=MODELS\pistol_d.3D X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=AutoMagL X=0 Y=0 Z=0 YAW=64 ROLL=-64
#exec MESH SEQUENCE MESH=AutoMagL SEQ=All     STARTFRAME=0  NUMFRAMES=190
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Still   STARTFRAME=0  NUMFRAMES=1
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Shoot   STARTFRAME=0  NUMFRAMES=4
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Shoot0  STARTFRAME=6  NUMFRAMES=3
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Shoot1  STARTFRAME=7  NUMFRAMES=7
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Shoot2  STARTFRAME=15 NUMFRAMES=5
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Shot2a  STARTFRAME=20  NUMFRAMES=5
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Shot2b  STARTFRAME=29  NUMFRAMES=3
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Shot2c  STARTFRAME=45  NUMFRAMES=5
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Twiddle STARTFRAME=50  NUMFRAMES=25
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Sway1   STARTFRAME=50  NUMFRAMES=2
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Eject   STARTFRAME=75  NUMFRAMES=25
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Down    STARTFRAME=100  NUMFRAMES=5
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Select  STARTFRAME=105  NUMFRAMES=30 RATE=40 GROUP=Select
#exec MESH SEQUENCE MESH=AutoMagL SEQ=T1      STARTFRAME=135  NUMFRAMES=5
#exec MESH SEQUENCE MESH=AutoMagL SEQ=Twirl   STARTFRAME=140  NUMFRAMES=45
#exec MESH SEQUENCE MESH=AutoMagL SEQ=T2      STARTFRAME=185  NUMFRAMES=5
#exec TEXTURE IMPORT NAME=Automa1 FILE=MODELS\pistol.PCX GROUP="Skins" 
#exec OBJ LOAD FILE=textures\FireEffect18.utx PACKAGE=UnrealShare.Effect18
#exec MESHMAP SCALE MESHMAP=AutoMagL X=0.007 Y=0.005 Z=0.01
#exec MESHMAP SETTEXTURE MESHMAP=AutoMagL NUM=1 TEXTURE=Automa1
#exec MESHMAP SETTEXTURE MESHMAP=AutoMagL NUM=0 TEXTURE=UnrealShare.Effect18.FireEffect18

// right handed player view version
#exec MESH IMPORT MESH=AutoMagR ANIVFILE=MODELS\pistol_a.3D DATAFILE=MODELS\pistol_d.3D unmirror=1
#exec MESH ORIGIN MESH=AutoMagR X=0 Y=0 Z=0 YAW=64 ROLL=-64
#exec MESH SEQUENCE MESH=AutoMagR SEQ=All     STARTFRAME=0  NUMFRAMES=190
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Still   STARTFRAME=0  NUMFRAMES=1
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Shoot   STARTFRAME=0  NUMFRAMES=4
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Shoot0  STARTFRAME=6  NUMFRAMES=3
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Shoot1  STARTFRAME=7  NUMFRAMES=7
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Shoot2  STARTFRAME=15 NUMFRAMES=5
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Shot2a  STARTFRAME=20  NUMFRAMES=5
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Shot2b  STARTFRAME=29  NUMFRAMES=3
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Shot2c  STARTFRAME=45  NUMFRAMES=5
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Twiddle STARTFRAME=50  NUMFRAMES=25
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Sway1   STARTFRAME=50  NUMFRAMES=2
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Eject   STARTFRAME=75  NUMFRAMES=25
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Down    STARTFRAME=100  NUMFRAMES=5
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Select  STARTFRAME=105  NUMFRAMES=30 RATE=40 GROUP=Select
#exec MESH SEQUENCE MESH=AutoMagR SEQ=T1      STARTFRAME=135  NUMFRAMES=5
#exec MESH SEQUENCE MESH=AutoMagR SEQ=Twirl   STARTFRAME=140  NUMFRAMES=45
#exec MESH SEQUENCE MESH=AutoMagR SEQ=T2      STARTFRAME=185  NUMFRAMES=5
#exec MESHMAP SCALE MESHMAP=AutoMagR X=0.007 Y=0.005 Z=0.01
#exec MESHMAP SETTEXTURE MESHMAP=AutoMagR NUM=1 TEXTURE=Automa1
#exec MESHMAP SETTEXTURE MESHMAP=AutoMagR NUM=0 TEXTURE=UnrealShare.Effect18.FireEffect18

#exec AUDIO IMPORT FILE="Sounds\automag\cocking.WAV" NAME="Cocking" GROUP="AutoMag"
#exec AUDIO IMPORT FILE="Sounds\automag\shot.WAV" NAME="shot" GROUP="AutoMag"
#exec AUDIO IMPORT FILE="Sounds\flak\click.WAV" NAME="click" GROUP="flak"
#exec AUDIO IMPORT FILE="Sounds\automag\reload1.WAV" NAME="Reload" GROUP="Automag"

var() int hitdamage;
var int ClipCount;
var bool bLaser;
var LaserSight LS;

function AltFire( float Value )
{
	bPointing=True;
	CheckVisibility();
	bLaser = !bLaser;
}

function PlayFiring()
{
	ClipCount++;
	Owner.PlaySound(Sound'UnrealI.Rifle.RifleShot',,,,,0.4);
}

// set which hand is holding weapon
function setHand(float Hand)
{
	Super.SetHand(Hand);
	if ( Hand == 1 )
		Mesh = mesh'AutoMagL';
	else
		Mesh = mesh'AutoMagR';
}

///////////////////////////////////////////////////////
state NormalFire
{
Begin:
	if (AnimSequence!='Shoot0') 
	{
		if( bLaser )
			PlayAnim('Shoot',0.7, 0.02);
		else PlayAnim('Shoot',1, 0.02);
		FinishAnim();
	}
	if( bLaser )
		PlayAnim('Shoot0',0.08, 0.04);
	else PlayAnim('Shoot0',0.13, 0.04);
	FinishAnim();
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	else if ( PlayerPawn(Owner) == None )
		Super.Finish();
	else if ( (AmmoType.AmmoAmount<=0) || (Pawn(Owner).Weapon != self) )
		GotoState('Idle');
	else if (ClipCount>=20) GoToState('NewClip');
	else if ( Pawn(Owner).bFire!=0 ) Global.Fire(0);
	else if ( Pawn(Owner).bAltFire!=0 )Global.AltFire(0);	
	if( bLaser )
		PlayAnim('Shoot2',0.2, 0.0);
	else PlayAnim('Shoot2',0.3, 0.0);
	FinishAnim();
	GoToState('Idle');
}


////////////////////////////////////////////////////////
state NewClip
{
ignores Fire, AltFire;
Begin:
	PlayAnim('Eject',1.5,0.05);
	Owner.PlaySound(Misc2Sound, SLOT_None,1.0*Pawn(Owner).SoundDampening);	
	FinishAnim();
	PlayAnim('Down',1.2,0.05);
	FinishAnim();
	ClipCount = 0;
	Owner.PlaySound(SelectSound, SLOT_None,1.0*Pawn(Owner).SoundDampening);	
	PlayAnim('Select',1.6,0.07);
	FinishAnim();
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	else if ( Pawn(Owner).bFire!=0 )
		Global.Fire(0);
	else if ( Pawn(Owner).bAltFire!=0 )
		Global.AltFire(0);	
	else GotoState('Idle');
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local shellcase s;
	local vector realLoc;

	realLoc = Owner.Location + CalcDrawOffset();
	s = Spawn(class'ShellCase',Pawn(Owner), '', realLoc + 20 * X + FireOffset.Y * Y + Z);
	if ( s != None )
		s.Eject(((FRand()*0.3+0.4)*X + (FRand()*0.2+0.2)*Y + (FRand()*0.3+1.0) * Z)*160);              
	if (Other == Level) 
		Spawn(class'WallHitEffect',,, HitLocation+HitNormal*9, Rotator(HitNormal));
	else if ((Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( FRand() < 0.2 )
			X *= 5;
		Other.TakeDamage(HitDamage, Pawn(Owner), HitLocation, 3000.0*X, 'shot');
		if ( !Other.IsA('Pawn') && !Other.IsA('Carcass') )
			spawn(class'SpriteSmokePuff',,,HitLocation+HitNormal*9);
	}		
}

function PlayPostSelect()
{
	ClipCount = 0;
}

function Finish()
{
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	else if ( PlayerPawn(Owner) == None )
		Super.Finish();
	else if ( (AmmoType.AmmoAmount<=0) || (Pawn(Owner).Weapon != self) )
		GotoState('Idle');
	else if (ClipCount>=20) GoToState('NewClip');
	else if ( /*bFireMem ||*/ Pawn(Owner).bFire!=0 )
		Global.Fire(0);
	else if ( /*bAltFireMem ||*/ Pawn(Owner).bAltFire!=0 )
		Global.AltFire(0);
	else 
		GotoState('Idle');
}

state Idle
{
	function AnimEnd()
	{
		PlayIdleAnim();
	}

	function bool PutDown()
	{
		GotoState('DownWeapon');
		return True;
	}
	
	function Timer()
	{
		if (FRand()>0.8) PlayAnim('Twiddle',0.6,0.3);
		else if (AnimSequence == 'Twiddle') LoopAnim('Sway1',0.02, 0.3);
	}

Begin:
	bPointing=False;
	if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0) ) 
		Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
	Disable('AnimEnd');
	LoopAnim('Sway1',0.02, 0.1);
	SetTimer(1.5,True);
	if ( /*bFireMem ||*/ Pawn(Owner).bFire!=0 ) Global.Fire(0.0);
	if ( /*bAltFireMem ||*/ Pawn(Owner).bAltFire!=0 ) Global.AltFire(0.0);	
}
function PlaySelect()
{
	PlayAnim('Select',1.0,0.0);
	Owner.PlaySound(SelectSound, SLOT_Misc, Pawn(Owner).SoundDampening,,,0.36);	
}
function Tick( float DeltaTime )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z;
	local actor Other;
	local Pawn PawnOwner;

	if( Owner==None || !Owner.IsA('Pawn') || Pawn(Owner).Weapon!=Self )
	{
		if( LS!=None )
		{
			LS.Destroy();
			LS=None;
		}
		Return;
	}
	SetLocation(Owner.Location);
	if( bLaser )
	{
		PawnOwner = Pawn(Owner);
		GetAxes(PawnOwner.ViewRotation,X,Y,Z);
		StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z; 
		AdjustedAim = PawnOwner.AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
		EndTrace = StartTrace + 10000* Vector(PawnOwner.ViewRotation);
		X = vector(AdjustedAim);
		EndTrace += (10000 * X); 
		Other = PawnOwner.TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
		if( LS==None )
			LS = Spawn(class'LaserSight',,,HitLocation+HitNormal);
		if( Other!=None )
			LS.SetLocation(HitLocation+HitNormal);
		else LS.SetLocation(EndTrace);
	}
	else if( LS!=None )
	{
		LS.Destroy();
		LS=None;
	}
	else LS=None;
}
function Fire( float Value )
{
	if (AmmoType.UseAmmo(1))
	{
		GotoState('NormalFire');
		if ( PlayerPawn(Owner) != None )
			PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
		bPointing=True;
		PlayFiring();
		if ( !bRapidFire && (FiringSpeed > 0) )
			Pawn(Owner).PlayRecoil(FiringSpeed);
		if( bLaser )
			TraceFire(0.0);
		else TraceFire(1.0);
		if ( Owner.bHidden )
			CheckVisibility();
	}
}
function float RateSelf( out int bUseAltMode )
{
	if( LS==None )
	{
		bUseAltMode = 2;
		return 0;
	}
	bUseAltMode = 0;
	return 2;
}

defaultproperties
{
     hitdamage=75
     AmmoName=Class'UnrealShare.ShellBox'
     PickupAmmoCount=100
     bInstantHit=True
     bAltInstantHit=True
     bOwnsCrosshair=True
     FireOffset=(Y=-10.000000,Z=-4.000000)
     shakemag=200.000000
     shakevert=4.000000
     AIRating=0.200000
     RefireRate=0.700000
     AltRefireRate=0.900000
     FireSound=Sound'UnrealShare.AutoMag.shot'
     AltFireSound=Sound'UnrealShare.AutoMag.shot'
     CockingSound=Sound'UnrealShare.AutoMag.Cocking'
     SelectSound=Sound'UnrealShare.AutoMag.Cocking'
     Misc1Sound=Sound'UnrealShare.flak.Click'
     Misc2Sound=Sound'UnrealShare.AutoMag.Reload'
     AutoSwitchPriority=2
     InventoryGroup=2
     PickupMessage="You got a PowerPistol"
     ItemName="PowerPistol"
     PlayerViewOffset=(X=4.800000,Y=-1.700000,Z=-2.700000)
     PlayerViewMesh=LodMesh'UnrealShare.AutoMagL'
     PickupViewMesh=LodMesh'UnrealShare.AutoMagPickup'
     PickupViewScale=1.200000
     ThirdPersonMesh=LodMesh'UnrealShare.auto3rd'
     ThirdPersonScale=1.600000
     PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
     Mesh=LodMesh'UnrealShare.AutoMagPickup'
     DrawScale=1.200000
     Fatness=129
     CollisionRadius=25.000000
     CollisionHeight=10.000000
}
